/*****************************************************************************/
/*                                                                           */
/*                                BASENAME.C                                 */
/*                                                                           */
/*             provide a basename() and a getprogname() function             */
/*                                                                           */
/*****************************************************************************/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>


/* strip off drive and path of a file name */
char *basename(char *name)
{
char *ptr;

  while ((ptr = strpbrk(name, ":\\/")) != NULL)
    name = ptr+1;
  return(name);
}


/* strip off drive, path and extension elements of a program name */
char *getprogname(char *name)
{
int len;

  name = basename(name);
  len = strlen(name);
  if ((len > 4) && (strcasecmp(name+len-4, ".exe") == 0))
    name[len-4] = '\0';
  return(name);
}


#if defined(BASENAME_TEST)

int main(int argc, char *argv[])
{
int i;
char name[FILENAME_MAX+1];
  for (i = 0; i < argc; i++)
  {
    strcpy(name, argv[i]);
    printf("basename(\"%s\") = \"%s\"\ngetprogname(\"%s\") = \"%s\"\n",
           argv[i], basename(argv[i]), argv[i], getprogname(name));
  }
  return(0);
}

#endif
