/*****************************************************************************/
/*                                                                           */
/*                                 DATABASE.C                                */
/*                                                                           */
/*                   database routines for mypasswd/mygroup                  */
/*                                                                           */
/*****************************************************************************/


#include <sys/types.h>
#include <sys/signal.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

#include <mysql.h>

#include "mypasswd.h"


static MYSQL mysql;
static Flag connected = FALSE;


/* open mysqlDatabase */
Flag openDatabase(char *host, char *db, char *auth_user, char *auth_password)
{
  if (mysql_connect(&mysql, host, auth_user, auth_password))
  {
    connected = TRUE;
    if (!mysql_select_db(&mysql, db))
      return(TRUE);
  }
  return(FALSE);
}


/* close database atexit routine */
Flag closeDatabase(void)
{
  if (connected)
  {
    mysql_close(&mysql);
    connected = FALSE;
  }
  return(!connected);
}


/* return database error */
char *DatabaseError(void)
{
  if (connected)
  {
    connected = FALSE;
    return(mysql_error(&mysql));
  }
  else
  {
    return("not connected");
  }
}


/* set entry in password or group field */
Flag SetEntry(char *table, char *userfield, char *otherfield, char *username, char *othername)
{
MYSQL_RES *res;
char *sql = (char*) malloc(sizeof(char) * dSQLBuffer);

  if ((sql != NULL) && (table != NULL) && 
      (userfield != NULL) && (otherfield != NULL) &&
      (username != NULL) && (othername != NULL))
  { 
    sprintf(sql, "SELECT %s,%s FROM %s WHERE %s='%s'",
            userfield, otherfield, table, userfield, username);

    if (verbose)
      printf("%s\n", sql);

    if (!mysql_query(&mysql, sql))
    {
      if ((res = mysql_store_result(&mysql)) != NULL)
      {
        if (mysql_num_rows(res) == 0)
        {    /* We got no results - so the user doesn't exist */
          sprintf(sql, "INSERT INTO %s (%s, %s) VALUES ('%s','%s')",
                  table, userfield, otherfield, username, othername);

          if (verbose)
            printf("%s\n", sql);

          if (!mysql_query(&mysql, sql))
          { 
            free(sql);
            return(TRUE);
          }
        }
        else
        {    /* The user exists - we have to change his password only */
          sprintf(sql, "UPDATE %s SET %s='%s' WHERE %s='%s'",
                  table, otherfield, othername, userfield, username); 

          if (verbose)
            printf("%s\n", sql);

          if (!mysql_query(&mysql, sql))
          {
            free(sql);
            return(TRUE);
          }
        }
      }
    }
  }
  free(sql);
  return(FALSE);
}


/* delete entry from password or group table */
Flag DeleteEntry(char *table, char *userfield, char *otherfield, char *username, char *othername)
{
MYSQL_RES *res;
char *sql = (char*) malloc(sizeof(char) * dSQLBuffer);

  if ((sql != NULL) && (table != NULL) &&
      (userfield != NULL) && (otherfield != NULL) && (username != NULL))
  {
    if ((othername != NULL) && (*othername != '\0'))
      sprintf(sql, "SELECT %s,%s FROM %s WHERE %s='%s'",
              userfield, otherfield, table, userfield, username);
    else
      sprintf(sql, "SELECT %s FROM %s WHERE %s='%s'",
              userfield, table, userfield, username);

    if (verbose)
      printf("%s\n", sql);

    if (!mysql_query(&mysql, sql))
    {
      if ((res = mysql_store_result(&mysql)) != NULL)
      {
        if (mysql_num_rows(res) > 0) /* user exists */
        {    
          if ((othername != NULL) && (*othername != '\0'))
            sprintf(sql, "DELETE FROM %s WHERE %s='%s' AND %s='%s'",
                    table, userfield, username, otherfield, othername); 
          else
            sprintf(sql, "DELETE FROM %s WHERE %s='%s'",
                    table, userfield, username); 

          if (verbose)
            printf("%s\n", sql);

          if (!mysql_query(&mysql, sql))
          {
            free(sql);
            return(TRUE);
          }
        }
        else
        {
          free(sql);
          return(TRUE);
        }
      }
    }
  }
  free(sql);
  return(FALSE);
}

