/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.UnsupportedEncodingException;

class Buffer {
    byte[] buf;
    int buf_length;
    int pos;
    int send_length;
    static final int NO_LENGTH_LIMIT = -1;
    int max_length = -1;
    static long NULL_LENGTH = -1L;

    Buffer(byte[] byArray) {
        this.buf = byArray;
        this.buf_length = byArray.length;
    }

    Buffer(int n, int n2) {
        this.buf = new byte[n];
        this.buf_length = this.buf.length;
        this.pos = 4;
        this.max_length = n2;
    }

    Buffer(int n) {
        this(n, -1);
    }

    final void setBytes(byte[] byArray) {
        this.send_length = this.buf_length;
        System.arraycopy(byArray, 0, this.buf, 0, this.buf_length);
    }

    final byte readByte() {
        return this.buf[this.pos++];
    }

    final int readInt() {
        int n = this.buf[this.pos++];
        int n2 = this.buf[this.pos++];
        return (n < 0 ? 256 + n : n) + 256 * (n2 < 0 ? 256 + n2 : n2);
    }

    final int readLongInt() {
        int n = this.buf[this.pos++];
        int n2 = this.buf[this.pos++];
        int n3 = this.buf[this.pos++];
        return (n < 0 ? 256 + n : n) + 256 * (n2 < 0 ? 256 + n2 : n2) + 65536 * (n3 < 0 ? 256 + n3 : n3);
    }

    final long readLong() {
        int n = this.buf[this.pos++];
        int n2 = this.buf[this.pos++];
        int n3 = this.buf[this.pos++];
        ++this.pos;
        return (n < 0 ? 256 + n : n) + 256 * (n2 < 0 ? 256 + n2 : n2) + 65536 * (n3 < 0 ? 256 + n3 : n3) + 0x1000000 * (n3 < 0 ? 256 + n3 : n3);
    }

    final long readLongLong() {
        int n = this.buf[this.pos++];
        byte by = this.buf[this.pos++];
        byte by2 = this.buf[this.pos++];
        byte by3 = this.buf[this.pos++];
        int n2 = this.buf[this.pos++];
        byte by4 = this.buf[this.pos++];
        byte by5 = this.buf[this.pos++];
        byte by6 = this.buf[this.pos++];
        return (n < 0 ? 256 + n : n) + (by < 0 ? 256 + by : by << 8) + (by2 < 0 ? 256 + by2 : by2 << 16) + (by3 < 0 ? 256 + by3 : by3 << 24) + ((n2 < 0 ? 256 + n2 : n2) + (by4 < 0 ? 256 + by4 : by4 << 8) + (by5 < 0 ? 256 + by5 : by5 << 16) + (by6 < 0 ? 256 + by6 : by6 << 24) << 32);
    }

    final int readnBytes() {
        int n;
        switch ((n = this.buf[this.pos++]) < 0 ? 256 + n : n) {
            case 1: {
                byte by = this.buf[this.pos++];
                if (by < 0) {
                    return 256 + by;
                }
                return by;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    final long readLength() {
        int n = this.buf[this.pos];
        switch (n < 0 ? 256 + n : n) {
            case 251: {
                ++this.pos;
                return 0L;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLong();
            }
        }
        int n2 = this.buf[this.pos++];
        return n2 < 0 ? 256 + n2 : n2;
    }

    final long newReadLength() {
        int n = this.buf[this.pos];
        switch (n < 0 ? 256 + n : n) {
            case 251: {
                ++this.pos;
                return 0L;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLongLong();
            }
        }
        int n2 = this.buf[this.pos++];
        return n2 < 0 ? 256 + n2 : n2;
    }

    final long readFieldLength() {
        int n = this.buf[this.pos];
        switch (n < 0 ? 256 + n : n) {
            case 251: {
                ++this.pos;
                return NULL_LENGTH;
            }
            case 252: {
                ++this.pos;
                return this.readInt();
            }
            case 253: {
                ++this.pos;
                return this.readLongInt();
            }
            case 254: {
                ++this.pos;
                return this.readLong();
            }
        }
        int n2 = this.buf[this.pos++];
        return n2 < 0 ? 256 + n2 : n2;
    }

    final byte[] readByteArray() {
        return this.getNullTerminatedBytes();
    }

    final byte[] readLenByteArray() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return new byte[0];
        }
        return this.getBytes((int)l);
    }

    final String readString() {
        int n = this.pos;
        int n2 = 0;
        while (this.buf[n] != 0 && n < this.buf_length) {
            ++n2;
            ++n;
        }
        String string = new String(this.buf, this.pos, n2);
        this.pos += n2 + 1;
        return string;
    }

    final String readLenString() {
        long l = this.readFieldLength();
        if (l == NULL_LENGTH) {
            return null;
        }
        if (l == 0L) {
            return "";
        }
        String string = new String(this.buf, this.pos, (int)l);
        this.pos = (int)((long)this.pos + l);
        return string;
    }

    final byte[] getBytes(int n) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.buf, this.pos, byArray, 0, n);
        this.pos += n;
        return byArray;
    }

    final byte[] getNullTerminatedBytes() {
        int n = this.pos;
        int n2 = 0;
        while (this.buf[n] != 0 && n < this.buf_length) {
            ++n2;
            ++n;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        this.pos += n2 + 1;
        return byArray;
    }

    final boolean isLastDataPacket() {
        int n;
        return this.buf_length <= 2 && ((n = this.buf[0]) < 0 ? 256 + n : n) == 254;
    }

    final void clear() {
        this.pos = 4;
    }

    final void writeByte(byte by) {
        this.buf[this.pos++] = by;
    }

    final void writeInt(int n) {
        int n2 = n % 256;
        this.buf[this.pos++] = (byte)n2;
        this.buf[this.pos++] = (byte)(n /= 256);
    }

    final void writeLongInt(int n) {
        int n2 = n % 256;
        this.buf[this.pos++] = (byte)n2;
        n2 = (n /= 256) % 256;
        this.buf[this.pos++] = (byte)n2;
        this.buf[this.pos++] = (byte)(n /= 256);
    }

    final void writeLong(long l) {
        long l2 = l % 256L;
        this.buf[this.pos++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buf[this.pos++] = (byte)l2;
        l2 = (l /= 256L) % 256L;
        this.buf[this.pos++] = (byte)l2;
        this.buf[this.pos++] = (byte)(l /= 256L);
    }

    final void writeString(String string) {
        this.writeStringNoNull(string);
        this.buf[this.pos++] = 0;
    }

    final void writeStringNoNull(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf, this.pos, n);
        this.pos += n;
    }

    final void writeStringNoNull(String string, String string2) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf, this.pos, n);
        this.pos += n;
    }

    final void writeBytesNoNull(byte[] byArray) {
        int n = byArray.length;
        this.ensureCapacity(n);
        System.arraycopy(byArray, 0, this.buf, this.pos, n);
        this.pos += n;
    }

    static final int ub(byte by) {
        if (by < 0) {
            return 256 + by;
        }
        return by;
    }

    final void ensureCapacity(int n) {
        if (this.pos + n > this.buf_length) {
            if (this.max_length != -1 && this.buf_length + (int)(1.25 * (double)n) > this.max_length) {
                throw new IllegalArgumentException("Packet is larger than max_allowed_packet from server configuration of " + this.max_length + " bytes");
            }
            int n2 = this.buf_length + (int)(1.25 * (double)n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
            this.buf = byArray;
            this.buf_length = this.buf.length;
        }
    }

    final void dump() {
        int n;
        int n2;
        int n3 = 0;
        int n4 = this.buf_length / 8;
        int n5 = 0;
        while (n5 < n4) {
            n2 = n3;
            n = 0;
            while (n < 8) {
                String string = Integer.toHexString(this.buf[n2]);
                if (string.length() == 1) {
                    string = "0" + string;
                }
                System.out.print(String.valueOf(string) + " ");
                ++n2;
                ++n;
            }
            System.out.print("    ");
            int n6 = 0;
            while (n6 < 8) {
                if (this.buf[n3] > 32 && this.buf[n3] < 127) {
                    System.out.print(String.valueOf((char)this.buf[n3]) + " ");
                } else {
                    System.out.print(". ");
                }
                ++n3;
                ++n6;
            }
            System.out.println();
            ++n5;
        }
        n2 = 0;
        n = n3;
        while (n < this.buf_length) {
            String string = Integer.toHexString(this.buf[n]);
            if (string.length() == 1) {
                string = "0" + string;
            }
            System.out.print(String.valueOf(string) + " ");
            ++n2;
            ++n;
        }
        int n7 = n2;
        while (n7 < 8) {
            System.out.print("   ");
            ++n7;
        }
        System.out.print("    ");
        int n8 = n3;
        while (n8 < this.buf_length) {
            if (this.buf[n8] > 32 && this.buf[n8] < 127) {
                System.out.print(String.valueOf((char)this.buf[n8]) + " ");
            } else {
                System.out.print(". ");
            }
            ++n8;
        }
        System.out.println();
    }
}

