#ifndef PLUGINMANAGER_H
#define PLUGINMANAGER_H

#include <kconfig.h>
#include <Plugin.h>
#include <kmysql/ISqlServer.h>
#include <qstring.h>
#include <qstrlist.h>

/**
  *@author Frdrik Bilhaut
  */

const int MAX_PLUGINS = 10;

class PluginManager
	{
	public:
		PluginManager(void);
		~PluginManager(void);
		int registerPlugin(QString path); // Returns the id to be used for future references to the plugin. A negative value means an error
		int unregisterPlugin(int id);
		ISqlServer *createInstance(int id);
		const char *getPluginName(int id);
		const char *getPluginInfo(int id);
		const char *getPluginPath(int id);
		int getPluginByName(QString);
		QStrList *getPluginNames(void);
		void savePref(KConfig *);		
		void readPref(KConfig *);
		int count(void);
	private:
		Plugin *plugins[MAX_PLUGINS];
	};

#endif











