#ifndef PLUGIN_H
#define PLUGIN_H

#include <dlfcn.h>
#include <IObject.h>
#include <qstring.h>

typedef IObject *(*CreateInstanceFuncType)(void);
typedef int (*DeleteInstanceFuncType)(IObject *);
typedef const char *(*GetNameFuncType)(void);
typedef const char *(*GetInfoFuncType)(void);

class Plugin
  {
  public:
    bool load(const char *libName);
    bool unload(void);
    IObject *createInstance();
    bool deleteInstance(IObject *);
    const char *getPluginName(void);
    const char *getPluginInfo(void);
    const char *getPluginPath(void);
    int getErrorCode(void);
    char *getErrorString(void);
  private:
    void *libPtr;
    char *errorString;
    int errorCode;
    QString path;
    CreateInstanceFuncType createFunc;
    DeleteInstanceFuncType deleteFunc;
    GetNameFuncType getNameFunc;
    GetInfoFuncType getInfoFunc;
  };

#endif





