#include "Form.h"

Form::Form(void)
  {
  items.setAutoDelete(true);
  }


Form::Form(const Form &) {} // Forbiden

Form::~Form(void)
  {
  clear();
  }

void Form::clear(void)
  {
  items.clear();
  name = "";
  query = "";
  }

void Form::addItem(FormItem *item)
  {
  items.append(item);
  }

void Form::removeItem(QString itemName)
  {
  int index = findItemFromName(itemName);
  if(index != -1)
    items.remove(index);
  else
    warning("Removing item that not exists");
  }

int Form::findItemFromName(QString itemName, FormItem *except)
  {
  int count = items.count();
  for(int i=0; i<count; i++)
    {
    if(items.at(i)->getName() == itemName && items.at(i) != except)
      return i;
    }
  return -1;
  }

bool Form::itemExists(QString itemName, FormItem *except)
  {
  return findItemFromName(itemName, except) != -1;
  }

void Form::setName(QString str)
  {
  name = str;
  }

QString Form::getName(void)
  {
  return name;
  }

void Form::setQuery(QString str)
  {
  query = str;
  }

QString Form::getQuery(void)
  {
  return query;
  }

bool Form::writeFile(const char *filename)
  {
  ofstream out(filename, ios::out);
  if(!out)
    return false;
  out << "form " << name << endl
      << "  {" << endl;
  out << "  query=" << query << ";" << endl;
  for(FormItem *item = items.first(); item; item=items.next())
    item->writeFile(out);
  out << "  }" << endl;
  out.close();
  return true;
  }

int Form::readFile(const char *filename)
  {
  clear();
  QScanner scanner(filename);
  if(!scanner.isValid())
    return -1;
  scanner.setSpecialChars(";{}()=");
  scanner.setCommentStyle(QScanner::CXX_STYLE);
  QString token;
  // Entete de la forme
  token = scanner.getToken();
  if(token != "form")
    return scanner.currentLine();
  // Le nom de la forme
  token = scanner.getToken();
  name = token;
  // Ouverture du bloc
  token = scanner.getToken();
  if(token != "{")
    return scanner.currentLine();
  // Le bloc lui-meme
  bool fin = false;
  while(!fin)
    {
    token = scanner.getToken();
    if(token == "}") // fin du bloc
      {
      fin = true;
      }
    else if(token == "query")
      {
      // Signe =
      token = scanner.getToken();
      if(token != "=")
	return scanner.currentLine();
      // La valeur
      token = scanner.getUntil(';');
      query = token;
      // Le point-virgule
      token = scanner.getToken();
      if(token != ";")
	return scanner.currentLine();
      }
    else if(token == "text") // Definition d'un item text
      {
      FormItemText *item = new FormItemText;
      // Le nom de l'item
      token = scanner.getToken(); 
      item->setName(token);
      // Accolade ouvrante
      token = scanner.getToken();
      if(token != "{")
	return scanner.currentLine();
      // Le bloc lui-meme
      bool fin2 = false;
      while(!fin2)
	{
	token = scanner.getToken();
	// Fin du bloc
	if(token == "}") 
	  fin2 = true;
	// Sinon erreur
	else
	  return scanner.currentLine(); // Erreur
	}
      // Ajout de l'item
      addItem(item);
      }
    else if(token == "combo") // Definition d'un item combo
      {
      FormItemCombo *item = new FormItemCombo;
      // Le nom de l'item
      token = scanner.getToken(); 
      item->setName(token);
      // Accolade ouvrante
      token = scanner.getToken();
      if(token != "{")
	return scanner.currentLine();
      // Le bloc lui-meme
      bool fin2 = false;
      while(!fin2)
	{
	token = scanner.getToken();
	// Fin du bloc
	if(token == "}") 
	  fin2 = true;
	// Dfinition d'une option
	else if(token == "option") 
	  {
	  // Le signe =
	  token = scanner.getToken(); 
	  if(token != "=")
	    return scanner.currentLine();
	  // L'option elle-meme
	  token = scanner.getUntil(';');
	  item->addChoice(token);
	  // Le point-virgule
	  token = scanner.getToken();
	  if(token != ";")
	    return scanner.currentLine();
	  }
	else
	  return scanner.currentLine(); // Erreur
	}
      // Ajout de l'item
      addItem(item);
      }
    else
      return scanner.currentLine();
    }
  return 0;  
  }


bool Form::writeDatabase(ISqlServer *sql)
	{
	if(!sql)
		return false;
	// Create entry in forms tabls
	QString request = "INSERT INTO __KmysqlForms (Name, Query) VALUES (";
	request += "'" + Utils::insertQuotes(name) + "', '" + Utils::insertQuotes(query) + "')";
	QueryResult res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;
	// Get the key correspondig to the form
	request = "SELECT Ref FROM __KmysqlForms WHERE Name='"+name+"'";
	res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;
	QString id = res.result.at(0);
	// Create entries for each item
	for(FormItem *item = items.first(); item; item=items.next())
    if(!item->writeDatabase(sql, id))
    	return false;
 	return true;
	}

		
bool Form::readDatabase(ISqlServer *sql, QString aName)
	{
	if(!sql)
		return false;
	clear();
	QString request = "SELECT Ref,Name,Query FROM __KmysqlForms WHERE Name='"+aName+"'";
	QueryResult res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;
	QString fields = res.result.at(0);
	QString fieldFormRef = Utils::subStringAt(fields, '\t', 0);
	QString fieldName = Utils::subStringAt(fields, '\t', 1);
	QString fieldQuery = Utils::subStringAt(fields, '\t', 2);
	setQuery(fieldQuery);	
	setName(aName);
	// Les champs
	request = "SELECT Name,Type,Extra FROM __KmysqlFields WHERE FormRef="+fieldFormRef;
	res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;
	for(unsigned int i=0; i<res.result.count(); i++)
		{
		QString fields = res.result.at(i);
		QString fieldName = Utils::subStringAt(fields, '\t', 0);
		QString fieldType = Utils::subStringAt(fields, '\t', 1);
		QString fieldExtra = Utils::subStringAt(fields, '\t', 2);
		if(fieldType=="text")
			{
			FormItemText *item = new FormItemText;
			item->setName(fieldName);
			addItem(item);
			}
		else if(fieldType=="combo")
			{
			FormItemCombo *item = new FormItemCombo;
			item->setName(fieldName);
			if(!item->setOptions(fieldExtra))
				{
				delete item;
				return false;
				}
			addItem(item);
			}
		else
			{
			warning("unknown FormItem type: '%s'", (const char *)fieldType);
			return false;
			}
		}	
	return true;
	}


bool Form::removeFromDatabase(ISqlServer *sql, QString name)
	{
	if(!sql)
		return false;
	// Get ref
	QString request = "SELECT Ref FROM __KmysqlForms WHERE Name='"+name+"'";
	QueryResult res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;	
	QString ref = res.result.at(0);
	// Delete fields
	request = "DELETE FROM __KmysqlFields WHERE FormRef="+ref;
	res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;	
	// Delete form
	request = "DELETE FROM __KmysqlForms WHERE Name='"+name+"'";
	res = sql->query(request);
	if(res.type == QueryResult::Error)
		return false;				
	return true;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	












