#include "DialogNewField.h"

#define Inherited DialogNewFieldData

DialogNewField::DialogNewField(QWidget* parent, const char* name)
  : Inherited( parent, name )
  {
  setCaption("New field");
  }


DialogNewField::~DialogNewField()
  {
  }

void DialogNewField::fill(FormItem *anItem)
	{
	if(anItem->getType() == FormItem::TypeText)
		{
		FormItemText *item = (FormItemText *)anItem;
		comboType->setCurrentItem(0);
		editName->setText(item->getName());
		}
	else if(anItem->getType() == FormItem::TypeCombo)
		{
		FormItemCombo *item = (FormItemCombo *)anItem;
		comboType->setCurrentItem(1);
		editName->setText(item->getName());
		comboChoices = item->choices;
		}
	}

void DialogNewField::ok(void)
  {
  QString name = editName->text();
  if(name.isEmpty())
    QMessageBox::warning(this, "Error", "Please enter a field name");
  else
    done(1);
  }

void DialogNewField::cancel(void)
  {
  done(0);
  }

void DialogNewField::options(void)
  {
  QString type = comboType->currentText();
  if(type == "Text Field")
    {
    QMessageBox::warning(this, "Sorry", "No options available for text field yet");
    }
  else if(type = "Combo box")
    {
    DialogComboOptions dlg(this);
    dlg.setChoices(comboChoices);
    if(dlg.exec())
      {
      comboChoices.clear();
      comboChoices = dlg.getChoices();
      }
    }
  }

FormItem *DialogNewField::getItem(void)
  {
  QString name = editName->text();
  QString type = comboType->currentText();
  if(type == "Text Field")
    {
    FormItemText *res = new FormItemText;
    res->setName(name);
    return res;
    }
  else if(type == "Combo box")
    {
    FormItemCombo *res = new FormItemCombo;
    res->setName(name);
    for(unsigned int i=0; i<comboChoices.count(); i++)
      res->addChoice(comboChoices.at(i));
    return res;
    }
  return NULL;
  }

