#ifndef CONNECTION_H
#define CONNECTION_H

#include <qstring.h>
#include "ISqlServer.h"

class Connection
  {
  public:
    Connection(ISqlServer *, const char *, const char *, const char *, const char *, const char *);
    ~Connection(void);
    QueryResult connect(void);
    ISqlServer *sql(void) const;
    QString getName(void) const;
    const char *getLogin(void) { return login; }
    const char *getPassword(void) { return passwd; }
    const char *getHost(void) { return host; }
    const char *getPluginName(void) { return pluginName; }
  private:
    QString login, passwd, host;
    ISqlServer *_sql;
    QString pluginName;
    QString pluginPath;
  };


#endif // CONNECTION_H

