// testurl.java
// Author: Xiaokun Kelvin ZHU
// Address: kelvinxz@iname.com
// 1997/09/04
package test;
                
import java.net.URL;
import java.sql.*;
import zxk.util.*;

class testurl implements DBugConstant
{

  public static void main (String args[]) 
  {
    // load the driver
    try
    {
      Class.forName ("gwe.sql.gweMysqlDriver");
    } catch (Exception e)
    { e.printStackTrace(); }

    if (zxk_debug)
      DBug.dbug.dbPush("-#d:t");

    //
    // All tests use local connect to mysql server
    //
    String database = new String("");
    String user = new String("user=www;");
    String password = new String("password=;");
    String command = new String("command=status;");

    doTest(database, user, password, command);

    command = new String("command=reload;");
    doTest(database, user, password, command);

    command = new String("command=proclist;");
    doTest(database, user, password, command);

    command = new String("command=kill 300;");
    // The following test will failed because we do not know
    // which thread id we current have ;-)
    doTest(database, user, password, command);

    database = new String("test_99");
    command = new String("command=create;");
    doTest(database, user, password, command);

    command = new String("command=drop;");
    doTest(database, user, password, command);

    database = new String("");
    command = new String("command=shutdown;");
    //doTest(database, user, password, command);
  } 
                
  private static void doTest(String database, String user, 
  	String password, String command)
  {
    // for MySQL 3.21.x server
    String url = "jdbc:mysql://localhost:3306/" + database + "?" + user + password 
    //String url = "jdbc:mysql:" + database + "?" + user + password 
      + command;
    try {
      Connection con = DriverManager.getConnection (url);
      getMessageFromServer(con.getWarnings ());
      System.out.println("Test " + command + " ... ok\n");
      con.close();
    }       
    catch (SQLException ex) 
    {
      System.out.println (ex.getMessage ());
      System.out.println("Test " + command + " ... failed\n");
    }       
    catch (java.lang.Exception ex) 
    {
      ex.printStackTrace ();
    }       
  }

  private static void  getMessageFromServer(SQLWarning warn)
    throws SQLException  
  {
    if (warn != null) 
    {
      String s = warn.getMessage ();
      int i = s.indexOf(':');
      if (i == -1)
        throw new SQLException("Wrong and expected message started with Command=xxxx:");
      else
        System.out.println("Server said:\n" + s.substring(i+2));
    }       
  }       
}
