/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.border.*;

import com.ice.util.AWTUtilities;


public class
MainPanel extends JPanel
		implements ActionListener
	{
	private HostInfoPanel		hostPanel;
	private QueryPanel			qPanel;
	private QueryTablePanel		qtPanel;
	private UpdatePanel			updPanel;
	private CommandPanel		cmdPanel;
	private TablesPanel			tblPanel;
	private TableDefsPanel		defsPanel;
	private AboutPanel			aboutPanel;

	private JTabbedPane			tabbedPane;


	public
	MainPanel()
		{
		super();

		JPanel			panel;
		JButton			button;

		this.setLayout( new GridBagLayout() );

		// Create a tab pane
		this.tabbedPane = new JTabbedPane();
		AWTUtilities.constrain(
			this, this.tabbedPane,
			GridBagConstraints.BOTH,
			GridBagConstraints.CENTER,
			0, 0, 1, 1, 1.0, 1.0 );

		this.aboutPanel = new AboutPanel();
		this.tabbedPane.addTab( "About", null, this.aboutPanel );

		this.hostPanel = new HostInfoPanel( this );
		this.tabbedPane.addTab( "Connection", null, this.hostPanel );
		
		this.tblPanel = new TablesPanel();
		this.tabbedPane.addTab( "Tables", null, this.tblPanel );
		
		this.defsPanel = new TableDefsPanel();
		this.tabbedPane.addTab( "Columns", null, this.defsPanel );

		this.qtPanel = new QueryTablePanel();
		this.tabbedPane.addTab( "Query", null, this.qtPanel );

		this.qPanel = new QueryPanel();
		this.tabbedPane.addTab( "Query (Text)", null, this.qPanel );
		
		this.updPanel = new UpdatePanel();
		this.tabbedPane.addTab( "Update", null, this.updPanel );

		this.adjustConnectedTabs( false );

		this.tabbedPane.setSelectedIndex( 1 );

		this.tabbedPane.addChangeListener( this.tblPanel );
		this.tabbedPane.addChangeListener( this.defsPanel );
		}

	public void
	dbHasChanged( String dbName )
		{
		this.tblPanel.refresh();
		this.defsPanel.refresh();
		}

	public void
	adjustConnectedTabs( boolean show )
		{
		this.tabbedPane.setEnabledAt( 2, show );
		this.tabbedPane.setEnabledAt( 3, show );
		this.tabbedPane.setEnabledAt( 4, show );
		this.tabbedPane.setEnabledAt( 5, show );
		this.tabbedPane.setEnabledAt( 6, show );
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "QUIT" ) )
			{
			System.exit(0);
			}
		else
			{
			System.err.println
				( "UNKNOWN Command '" + command + "'" );
			}
		}

	}

