/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.sun.java.swing.table.AbstractTableModel;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Vector;

public class JDBCAdapter
extends AbstractTableModel {
    private Vector rows = new Vector();
    private ColumnMeta[] columnMetas = new ColumnMeta[0];
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public JDBCAdapter(ResultSet resultSet) {
        this.setQueryResult(resultSet);
    }

    public void setQueryResult(ResultSet resultSet) {
        Object object;
        int n;
        int n2;
        if (resultSet == null) {
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            n2 = resultSetMetaData.getColumnCount();
            this.columnMetas = new ColumnMeta[n2];
            n = 0;
            while (n < n2) {
                object = new ColumnMeta(n + 1);
                ((ColumnMeta)object).cacheMetaData(resultSetMetaData);
                this.columnMetas[n] = object;
                ++n;
            }
        }
        catch (SQLException sQLException) {
            System.err.println("ERROR getting META DATA in MySQLAdapter!!!!");
            System.err.println("\t" + sQLException.getMessage());
            return;
        }
        n2 = 1;
        this.rows = new Vector();
        while (true) {
            n = 0;
            try {
                n = resultSet.next() ? 1 : 0;
            }
            catch (SQLException sQLException) {
                System.err.println("ERROR getting ROW DATA in JDBCAdapter!!!!");
                System.err.println("\tROW = " + (this.rows.size() + 1));
                System.err.println("\t" + sQLException.getMessage());
                break;
            }
            if (n == 0) break;
            object = new Vector();
            n2 = 1;
            while (n2 <= this.getColumnCount()) {
                Object object2;
                try {
                    object2 = resultSet.getObject(n2);
                    if (object2 instanceof byte[]) {
                        byte[] byArray = (byte[])object2;
                        object2 = "byte[" + byArray.length + "]";
                    }
                }
                catch (SQLException sQLException) {
                    object2 = new String("");
                    System.err.println("JDBCAdapter: ERROR getting column data:  Row = " + (this.rows.size() + 1) + " Col = " + n2 + " Type = " + this.columnMetas[n2 - 1].dataType);
                    System.err.println("\t" + sQLException.getMessage());
                }
                ((Vector)object).addElement(object2);
                ++n2;
            }
            this.rows.addElement(object);
        }
        this.fireTableChanged(null);
    }

    public String getColumnName(int n) {
        if (this.columnMetas == null || n < 0 || n > this.columnMetas.length) {
            return "";
        }
        ColumnMeta columnMeta = this.columnMetas[n];
        return columnMeta.getName();
    }

    public Class getColumnClass(int n) {
        if (this.columnMetas == null || n < 0 || n > this.columnMetas.length) {
            if (AbstractTableModel.class$java$lang$Object != null) {
                return AbstractTableModel.class$java$lang$Object;
            }
            AbstractTableModel.class$java$lang$Object = JDBCAdapter.class$("java.lang.Object");
            return AbstractTableModel.class$java$lang$Object;
        }
        ColumnMeta columnMeta = this.columnMetas[n];
        return this.getJDBCTypeClass(columnMeta.getDataType());
    }

    private Class getJDBCTypeClass(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                if (class$java$lang$String != null) {
                    return class$java$lang$String;
                }
                class$java$lang$String = JDBCAdapter.class$("java.lang.String");
                return class$java$lang$String;
            }
            case -4: 
            case -3: 
            case -2: {
                if (class$java$lang$String != null) {
                    return class$java$lang$String;
                }
                class$java$lang$String = JDBCAdapter.class$("java.lang.String");
                return class$java$lang$String;
            }
            case -7: {
                if (class$java$lang$Boolean != null) {
                    return class$java$lang$Boolean;
                }
                class$java$lang$Boolean = JDBCAdapter.class$("java.lang.Boolean");
                return class$java$lang$Boolean;
            }
            case -6: 
            case 4: 
            case 5: {
                if (class$java$lang$Integer != null) {
                    return class$java$lang$Integer;
                }
                class$java$lang$Integer = JDBCAdapter.class$("java.lang.Integer");
                return class$java$lang$Integer;
            }
            case -5: {
                if (class$java$lang$Long != null) {
                    return class$java$lang$Long;
                }
                class$java$lang$Long = JDBCAdapter.class$("java.lang.Long");
                return class$java$lang$Long;
            }
            case 2: 
            case 3: {
                if (class$java$math$BigDecimal != null) {
                    return class$java$math$BigDecimal;
                }
                class$java$math$BigDecimal = JDBCAdapter.class$("java.math.BigDecimal");
                return class$java$math$BigDecimal;
            }
            case 6: 
            case 7: {
                if (class$java$lang$Float != null) {
                    return class$java$lang$Float;
                }
                class$java$lang$Float = JDBCAdapter.class$("java.lang.Float");
                return class$java$lang$Float;
            }
            case 8: {
                if (class$java$lang$Double != null) {
                    return class$java$lang$Double;
                }
                class$java$lang$Double = JDBCAdapter.class$("java.lang.Double");
                return class$java$lang$Double;
            }
            case 91: {
                if (class$java$sql$Date != null) {
                    return class$java$sql$Date;
                }
                class$java$sql$Date = JDBCAdapter.class$("java.sql.Date");
                return class$java$sql$Date;
            }
            case 92: {
                if (class$java$sql$Time != null) {
                    return class$java$sql$Time;
                }
                class$java$sql$Time = JDBCAdapter.class$("java.sql.Time");
                return class$java$sql$Time;
            }
            case 93: {
                if (class$java$sql$Timestamp != null) {
                    return class$java$sql$Timestamp;
                }
                class$java$sql$Timestamp = JDBCAdapter.class$("java.sql.Timestamp");
                return class$java$sql$Timestamp;
            }
        }
        if (AbstractTableModel.class$java$lang$Object != null) {
            return AbstractTableModel.class$java$lang$Object;
        }
        AbstractTableModel.class$java$lang$Object = JDBCAdapter.class$("java.lang.Object");
        return AbstractTableModel.class$java$lang$Object;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.columnMetas == null || n2 < 0 || n2 > this.columnMetas.length) {
            return false;
        }
        ColumnMeta columnMeta = this.columnMetas[n2];
        return columnMeta.isEditable();
    }

    public int getColumnCount() {
        return this.columnMetas.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n > this.rows.size() || n < 0) {
            return null;
        }
        if (n2 > this.columnMetas.length || n2 < 0) {
            return null;
        }
        Vector vector = (Vector)this.rows.elementAt(n);
        return vector.elementAt(n2);
    }

    private String dbRepresentation(ColumnMeta columnMeta, Object object) {
        int n = columnMeta.getDataType();
        System.err.println("DBREP: Col '" + columnMeta.getName() + "' Type=" + n);
        if (object == null) {
            return "(null)";
        }
        switch (n) {
            case 4: 
            case 6: 
            case 8: {
                return object.toString();
            }
            case -7: {
                if (((Boolean)object).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            case 91: {
                return object.toString();
            }
        }
        System.err.println("DBREP: DEFAULT: Type=" + n);
        return "\"" + object.toString() + "\"";
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n < 0 || n > this.rows.size()) {
            return;
        }
        if (n2 < 0 || n2 > this.columnMetas.length) {
            return;
        }
        Vector vector = (Vector)this.rows.elementAt(n);
        vector.setElementAt(object, n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ColumnMeta {
        int index;
        String name;
        String label;
        String tableName;
        int dataType;
        boolean isEditable;

        public ColumnMeta(int n) {
            JDBCAdapter.this = JDBCAdapter.this;
            this.index = n;
        }

        public void cacheMetaData(ResultSetMetaData resultSetMetaData) throws SQLException {
            this.name = resultSetMetaData.getColumnName(this.index);
            this.label = resultSetMetaData.getColumnLabel(this.index);
            this.dataType = resultSetMetaData.getColumnType(this.index);
            this.tableName = resultSetMetaData.getTableName(this.index);
            this.isEditable = resultSetMetaData.isWritable(this.index);
            if (this.tableName == null) {
                this.tableName = "(null)";
            }
        }

        public int getDataType() {
            return this.dataType;
        }

        public void setDataType(int n) {
            this.dataType = n;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getTableName() {
            return this.tableName;
        }

        public boolean isEditable() {
            return this.isEditable;
        }
    }
}

