/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.MainFrame;
import com.ice.sqlclient.MySQLClient;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.StringUtilities;
import com.ice.util.UserProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;

public class SQLClient {
    public static final String RCS_ID = "$Id: SQLClient.java,v 1.8 1998/04/30 18:37:10 time Exp $";
    public static final String RCS_REV = "$Revision: 1.8 $";
    public static final String RCS_NAME = "$Name:  $";
    public static final String VERSION_STR = "1.5";
    private static final String PROP_PREFIX = "SQLClient.";
    private static final String PROP_PACKAGE = "com.ice.sqlclient";
    private static final String DEFAULTS_RSRC = "/com/ice/sqlclient/defaults.txt";
    private static final String LOCAL_PROPERTIES = "properties.txt";
    public static SQLClient app = null;

    public static void main(String[] stringArray) {
        UserProperties.setPropertyPrefix(PROP_PREFIX);
        UserProperties.setDefaultsResource(DEFAULTS_RSRC);
        UserProperties.setLocalPropertyFile(LOCAL_PROPERTIES);
        String[] stringArray2 = UserProperties.processOptions(stringArray);
        UserProperties.loadProperties(PROP_PACKAGE, null);
        app = new SQLClient();
        app.instanceMain(stringArray2);
    }

    public void instanceMain(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].startsWith("-")) break;
            if (stringArray[n].equals("-?") || stringArray[n].equals("-help") || stringArray[n].equals("-usage")) {
                this.printUsage();
            } else {
                System.err.println("ignoring option '" + stringArray[n]);
            }
            ++n;
        }
        System.err.println("Loading jdbc drivers...");
        this.loadJDBCDrivers();
        String string = UserProperties.getProperty("mainWindow.title", "SQL Client");
        MainFrame mainFrame = new MainFrame(string);
        int n2 = UserProperties.getProperty("mainWindow.x", 20);
        int n3 = UserProperties.getProperty("mainWindow.y", 20);
        ((Component)((Object)mainFrame)).setLocation(n2, n3);
        int n4 = UserProperties.getProperty("mainWindow.width", -1);
        int n5 = UserProperties.getProperty("mainWindow.height", -1);
        ((Window)((Object)mainFrame)).pack();
        Dimension dimension = ((Component)((Object)mainFrame)).getSize();
        if (n4 == -1) {
            n4 = dimension.width;
        }
        if (n5 == -1) {
            n5 = dimension.height;
        }
        ((Component)((Object)mainFrame)).setSize(n4, n5);
        ((Window)((Object)mainFrame)).show();
    }

    private void loadJDBCDrivers() {
        int n = 1;
        while (n < 100) {
            String string = UserProperties.getProperty("jdbcDriver." + n, null);
            if (string == null) {
                System.err.println("Loaded " + (n - 1) + " drivers.");
                return;
            }
            String[] stringArray = StringUtilities.splitString(string, ":");
            if (stringArray.length != 4) {
                System.err.println("Invalid driver property:\n\t" + string);
            } else if (stringArray[0].equalsIgnoreCase("MySQL")) {
                try {
                    MySQLClient mySQLClient = new MySQLClient(stringArray[1], stringArray[2], stringArray[3]);
                    SQLClientHandler.addHandler(mySQLClient);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("ERROR creating SQL Handler '" + stringArray[0] + "', " + classNotFoundException.getMessage());
                }
            } else {
                System.err.println("UNKNOWN SQL Handler '" + stringArray[1] + "'");
            }
            ++n;
        }
    }

    public void printUsage() {
        System.err.println("usage: com.ice.sqlclient.SQLClient [options...]");
        System.err.println("SQLClient options:");
        System.err.println("    currently no options");
        UserProperties.printUsage(System.err);
    }
}

