#!/usr/bin/perl
########################################################################
#                                                                      #
#    radius.cgi                   InnerCite                            #
#                                 Mike Machado <mike@innercite.com>    #
#                                 14 May 1999                          #
#                                                                      #
#    Web administration for ICRADIUS                                   #
#                                                                      #
#                   Copyright under same terms as Cistron RADIUS       #
#                                                                      #
########################################################################

use DBI;
use strict;
use CGI;


my ($sth);
my $dbusername = 'radius';
my $dbpassword = 'rootpass';
my $dbh = DBI->connect("DBI:mysql:radius", $dbusername, $dbpassword);

my $query = new CGI;
my $cgi = $query->url();
my $now = getdatetime();
my $printmainpage = 1;

my $cookiedomain = ".innercite.com";
my $logfile = "/var/log/radius.log";
my $body = "<body bgcolor=dddddd>";

# Should not have to change anything under this line
my $total = 0;
my $i = 0;
my $DAYSPERMON = 30;
my $printheader = 1;

# if they are trying to login we wont check the session yet
if ($query->param('login') eq '' && $query->param('action') ne 'login') {
  checksession();
  printheader();
}

if ($query->param('removeuserchecks') ne '') {

   my @id = $query->param('argvid');
   foreach my $argv (@id) {
      $sth = $dbh->do("DELETE FROM radcheck WHERE id = \"$argv\"");
   }
   $query->param('action','userargvlist');

} elsif ($query->param('removeuserreply') ne '') {

   my @id = $query->param('argvid');
   foreach my $argv (@id) {
      $sth = $dbh->do("DELETE FROM radreply WHERE id = \"$argv\"");
   }
   $query->param('action','userargvlist');

} elsif ($query->param('removegroupchecks') ne '') {

   my @id = $query->param('argvid');
   foreach my $argv (@id) {
      $sth = $dbh->do("DELETE FROM radgroupcheck WHERE id = \"$argv\"");
   }
   $query->param('action','groupargvlist');
   $query->param('from','check');

   $sth = $dbh->prepare("SELECT id FROM radgroupcheck WHERE GroupName = \"".$query->param('groupname')."\"");
   $sth->execute;
   my $check = $sth->fetchrow_array;
   if ($check eq '') {
      $sth = $dbh->prepare("SELECT id FROM radgroupreply WHERE GroupName = \"".$query->param('groupname')."\"");
      $sth->execute;
      my $groupid = $sth->fetchrow_array;
      if ($groupid) {
         $query->param('from','reply');
         $query->param('groupid', $groupid);
      } else {
         $sth = $dbh->do("DELETE FROM usergroup WHERE GroupName = \"".$query->param('groupname')."\"");
         print "<html>$body<center><h2>Group Deleted</h2></center></html>\n";
         exit;
      }
   } else {
      $query->param('groupid', $check);
   }



} elsif ($query->param('removegroupreply') ne '') {

   my @id = $query->param('argvid');
   foreach my $argv (@id) {
      $sth = $dbh->do("DELETE FROM radgroupreply WHERE id = \"$argv\"");
   }
   $query->param('action','groupargvlist');
   $query->param('from','reply');

   $sth = $dbh->prepare("SELECT id FROM radgroupreply WHERE GroupName = \"".$query->param('groupname')."\"");
   $sth->execute;
   my $check = $sth->fetchrow_array;
   if ($check eq '') {
      $sth = $dbh->prepare("SELECT id FROM radgroupcheck WHERE GroupName = \"".$query->param('groupname')."\"");
      $sth->execute;
      my $groupid = $sth->fetchrow_array;
      if ($groupid) {
         $query->param('from','check');
         $query->param('groupid', $groupid);
      } else {
         $sth = $dbh->do("DELETE FROM usergroup WHERE GroupName = \"".$query->param('groupname')."\"");
         print "<html>$body<center><h2>Group Deleted</h2></center></html>\n";
         exit;
      }
   } else {
      $query->param('groupid', $check);
   }


} elsif ($query->param('removeusergroup') ne '') {

   my @id = $query->param('usergroupid');
   foreach my $argv (@id) {
      $sth = $dbh->do("DELETE FROM usergroup WHERE id = \"$argv\"");
   }
   $query->param('action','userargvlist');

} elsif ($query->param('doaddusercheck') ne '') {
   
   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("INSERT INTO radcheck VALUES \(\"\",\"".$query->param('username')."\",\"".$query->param('attribute')."\",$quoted\)");

} elsif ($query->param('doeditusercheck') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("UPDATE radcheck SET Attribute = \"".$query->param('attribute')."\", Value = $quoted WHERE id = \"".$query->param('userid')."\"");

} elsif ($query->param('doadduserreply') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("INSERT INTO radreply VALUES \(\"\",\"".$query->param('username')."\",\"".$query->param('attribute')."\",$quoted\)");

} elsif ($query->param('doedituserreply') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("UPDATE radreply SET Attribute = \"".$query->param('attribute')."\", Value = $quoted WHERE id = \"".$query->param('replyid')."\"");

} elsif ($query->param('doaddgroupcheck') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("INSERT INTO radgroupcheck VALUES \(\"\",\"".$query->param('groupname')."\",\"".$query->param('attribute')."\",$quoted\)");
   $sth = $dbh->prepare("SELECT LAST_INSERT_ID()");
   $sth->execute;
   my $id = $sth->fetchrow_array;
   $query->param('groupid', $id);

} elsif ($query->param('doeditgroupcheck') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("UPDATE radgroupcheck SET Attribute = \"".$query->param('attribute')."\", Value = $quoted WHERE id = \"".$query->param('groupid')."\"");

} elsif ($query->param('doaddgroupreply') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("INSERT INTO radgroupreply VALUES \(\"\",\"".$query->param('groupname')."\",\"".$query->param('attribute')."\",$quoted\)");
   $sth = $dbh->prepare("SELECT LAST_INSERT_ID()");
   $sth->execute;
   my $id = $sth->fetchrow_array;
   $query->param('groupid', $id);

} elsif ($query->param('doeditgroupreply') ne '') {

   my $quoted = $dbh->quote($query->param('value'));
   $sth = $dbh->do("UPDATE radgroupreply SET Attribute = \"".$query->param('attribute')."\", Value = $quoted WHERE id = \"".$query->param('groupid')."\"");

} elsif ($query->param('doadduser') ne '') {

   $sth = $dbh->prepare("SELECT id FROM radcheck WHERE UserName = \"".$query->param('username')."\"");
   $sth->execute;
   my $check = $sth->fetchrow_array;
   error('exists') if $check;

   $sth = $dbh->do("INSERT INTO radcheck VALUES \(\"\",\"".$query->param('username')."\",\"Password\",\"".$query->param('password')."\"\)");

   $sth = $dbh->prepare("SELECT LAST_INSERT_ID()");
   $sth->execute;
   my $userid = $sth->fetchrow_array;

   $query->param('action','edituser');
   $query->param('userid',$userid);

} elsif ($query->param('doaddtogroup') ne '') {

   my @groups = $query->param('groups');
   my $userid = $query->param('userid');
   foreach my $group (@groups) {
     $sth = $dbh->prepare("SELECT id FROM usergroup WHERE UserName = \"".$query->param('username')."\" AND GroupName = \"$group\"");
     $sth->execute;
     my $check = $sth->fetchrow_array;
     error('ingroup', $group) if $check;
   }

   foreach my $group (@groups) {
      $sth = $dbh->do("INSERT INTO usergroup VALUES \(\"\",\"".$query->param('username')."\",\"$group\"\)");
   }

   print "<html><head>\n";
   print qq!

   <script language=javascript>
     function reloadwin() {
       opener.location.href="$cgi\?action=userargvlist\&userid=$userid"
       window.close();
     }
   </script>
  !; 
   print "</head>\n";
   print "<body OnLoad=\"reloadwin()\">\n";
   print "</body></html>\n";
   exit;


} elsif ($query->param('dodeluser') ne '') {

   $sth = $dbh->do("DELETE FROM radcheck WHERE UserName = \"".$query->param('username')."\"");
   $sth = $dbh->do("DELETE FROM radreply WHERE UserName = \"".$query->param('username')."\"");
   $sth = $dbh->do("DELETE FROM usergroup WHERE UserName = \"".$query->param('username')."\"");

   print "<html>$body\n";
   print "<center><h2>User ".$query->param('username')." Has Been Deleted</h2>\n";
   print "</body></html>\n";
 
   $printmainpage = 0;


} elsif ($query->param('dodelgroup') ne '') {

   $sth = $dbh->do("DELETE FROM radgroupcheck WHERE GroupName = \"".$query->param('groupname')."\"");
   $sth = $dbh->do("DELETE FROM radgroupreply WHERE GroupName = \"".$query->param('groupname')."\"");
   $sth = $dbh->do("DELETE FROM UserGroup WHERE GroupName = \"".$query->param('groupname')."\"");

   print "<html>$body\n";
   print "<center><h2>Group ".$query->param('groupname')." Has Been Deleted</h2>\n";
   print "</body></html>\n";
 
   $printmainpage = 0;

}



if ($query->param('action') eq 'summary') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter date ranges below. Leave blank for a complete total.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>From Time</td><td><input type=text name=from value=\"\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "<tr><td>Sort By</td><td><select name=orderby>\n";
  print "<option value=\"UserName\">UserName\n";
  print "<option value=\"s\">Hours Used\n";
  print "</select> Acending<input type=radio name=\"direction\" value=\"ASC\" CHECKED>\&nbsp\;\&nbsp\;Decending<input type=radio name=\"direction\" value=\"DESC\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"summaryreport\" value=\"Get Report\"><br>\n";


  $printmainpage = 0;

} elsif ($query->param('action') eq 'utilization') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter a date below to get a graph of nas usage. Leave blank to get current usage.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>Time</td><td><input type=text name=time value=\"\"></td></tr>\n";
#  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"utilgraph\" value=\"Get Graph\"><br>\n";

  $printmainpage = 0;



} elsif ($query->param('login') ne '') {

   my $username = $query->param('username');
   my $password = $query->param('password');

   checkuserpass($username, $password);

   my $cookie1 = $query->cookie(-name=>'username',
				-value=>$username,
				-expires=>'+12h',
				-domain=>$cookiedomain);

   my $cookie2 = $query->cookie(-name=>'password',
				-value=>$password,
				-expires=>'+12h',
				-domain=>$cookiedomain);

   print $query->header(-COOKIE=>[$cookie1, $cookie2]);
 
   $printmainpage = 1;

} elsif ($query->param('doviewlog') ne '') {

   $| = 1;
   my $lines = $query->param('lines');
   print "<html><head>\n";
 if ($query->param('doviewlog_scroll')) {
   print qq!
   <script language="JavaScript">

   // toggle scrolling mode
   function toggleScroll() {
      if (scrolltimeron) {
          stopScroll();
      }
      else {
          scrollit(8);
      }
   }

   timerShow = null;
   var scrolltimer = null;
   var scrolltimeron = false;

   function stopScroll() {
      if (scrolltimeron) {
        clearTimeout(scrolltimer);
      }
      scrolltimeron = false;
   }

   function scrollit(speed) {
      s = speed;
      top.window.rightmainframe.scrollBy(0,s);
      scrolltimer = setTimeout('scrollit(s)','50');
      scrolltimeron = true;
   }
   toggleScroll();

   </script>
   !;
 }
   print "</head>$body\n";
   if ($query->param('doviewlog_scroll')) {
      #print "<body OnLoad=\"window.rightmainframe.scrollBy(0,8)\">\n";
   }
   print "<pre>\n";
   my @args;
   if ($query->param('doviewlog_scroll')) {
      @args = ("tail","-f","$logfile");
      exec(@args);
   } else {
      @args = ("tail","-$lines","$logfile");
      system(@args);
   }
   print "</pre>\n";
   print "<center><form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"lines\" value=\"$lines\">\n";
   print "<input type=hidden name=\"doviewlog\" value=\"true\">\n";
   print "<input type=submit name=\"doviewlog_reload\" value=\"Reload\">\n";
   print "<input type=submit name=\"doviewlog_scroll\" value=\"Auto Scroll\">\n";
   print "</form></center></body></html>\n";

   $printmainpage = 0;

} elsif ($query->param('action') eq 'blankframe') {
   
  print "<html>$body</body></html>\n";
   $printmainpage = 0;

} elsif ($query->param('action') eq 'navframe') {

  print "<html><body bgcolor=bbbbbb>\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2></center>\n";

  print "<br><center>Choose Action:</center><br>\n";
  print "<center><table border=0>\n";
  print "<ul>\n";
  print "<tr><td><li><a href=\"$cgi\?action=manageusers\" target=\"rightmainframe\">Manage Users</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=managegroups\" target=\"rightmainframe\">Manage Groups</a></td></tr>\n";
 print "<tr><td><li><a href=\"$cgi\?action=managerealms\" target=\"rightmainframe\">Manage Realms</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=managenas\" target=\"rightmainframe\">Manage NASs</a></td></tr>\n";
  print "</ul>\n";
  print "</table></center>\n";

  print "<br><br><center>Choose Report:</center><br>\n";
  print "<center><table border=0>\n";
  print "<ul>\n";
  print "<tr><td><li><a href=\"$cgi\?action=summary\" target=\"rightmainframe\">Usage Summary</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=detailed\" target=\"rightmainframe\">Detailed by User</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=loginstatus\" target=\"rightmainframe\">Login Report</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=abuse\" target=\"rightmainframe\">Abuse Report</a></td></tr>\n";
  print "<tr><td><li><a href=\"$cgi\?action=viewlog\" target=\"rightmainframe\">View Log</a></td></tr>\n";
  print "</ul>\n";
  print "</table></center>\n";

  print "<br><br><center>Choose Graph:</center><br>\n";
  print "<center><table border=0>\n";
  print "<tr><td><li><a href=\"$cgi\?action=utilization\" target=\"rightmainframe\">Utilization Graph</a></td></tr>\n";
  print "</table></center>\n";
  
  print "<br><br><br>\n";
  print "</body></html>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'rightmainframe') {

  print "<html>$body\n";
  print "<br><br><br>\n";
  print "<font size=4><----- Please choose function on the left menu</font>\n";
  print "</body></html>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'manageusers') {

  print "<FRAMESET rows=\"155,*\" BORDER=\"0\">\n";
  print "<FRAME NAME=\"usersearchframe\" src=\"$cgi?action=manageusersearch\">\n";
  print "<FRAME NAME=\"usersearchdisplay\" src=\"$cgi?action=blankframe\">\n";
  print "</FRAMESET>\n";
  $printmainpage = 0;
  

} elsif ($query->param('action') eq 'manageusersearch') {

  print "<html>$body\n";
  print "<body onload=\"document.form1.user.focus()\">\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2></center>\n";
  print "<form name=form1 action=\"$cgi\" method=post target=\"usersearchdisplay\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>Username:</td><td> <input type=\"text\" name=\"user\"></td></tr>\n";
  print "<tr><td></td><td><input type=\"submit\" name=\"finduser\" value=\"Search\">\&nbsp\;\&nbsp\;<a href=\"$cgi\?action=adduser\" target=\"rightmainframe\">Add New User</a></td></tr>\n";
  print "</table>\n";
  print "</form>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('finduser') ne '') {

  $sth = $dbh->prepare("SELECT DISTINCT UserName AS U, id FROM radcheck WHERE UserName LIKE \"".$query->param('user')."\%\" GROUP BY U");
  $sth->execute;
  print "<html>$body\n";
  print "<br><br><center><table border=1>\n";
  print "<tr><th>UserName</th></tr>\n";
  while (my @users = $sth->fetchrow_array) {
    print "<tr align=center><td><a href=\"$cgi\?userid=$users[1]\&action=edituser\" target=\"rightmainframe\">$users[0]</a></td></tr>\n";
  }
  print "</table>\n";
  print "</body></html>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'managegroups') {

  print "<FRAMESET rows=\"155,*\" BORDER=\"0\">\n";
  print "<FRAME NAME=\"groupsearchframe\" src=\"$cgi?action=managegroupsearch\">\n";
  print "<FRAME NAME=\"groupsearchdisplay\" src=\"$cgi?action=blankframe\">\n";
  print "</FRAMESET>\n";
  $printmainpage = 0;
  

} elsif ($query->param('action') eq 'managegroupsearch') {

  print "<html>$body\n";
  print "<body onload=\"document.form1.user.focus()\">\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2></center>\n";
  print "<form name=form1 action=\"$cgi\" method=post target=\"groupsearchdisplay\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>Groupname:</td><td> <input type=\"text\" name=\"group\"></td></tr>\n";
  print "<tr><td></td><td><input type=\"submit\" name=\"findgroup\" value=\"Search\">\&nbsp\;\&nbsp\;<a href=\"$cgi\?action=addgroup\" target=\"rightmainframe\">Add New Group</a></td></tr>\n";
  print "</table>\n";
  print "</form>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'newnas') {

  print "<html>$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2></center>\n";
                                                                                                         print "<form action=\"$cgi\" method=post>\n";
  print "<center><table border=0>\n";



} elsif ($query->param('action') eq 'editnas') {

  print "<html><head>\n";
  print "<center><h2>ICRADIUS Web Interface</h2></center>\n";
  print "<br><center><h3>Edit NAS</h3></center>\n";
  print "<form name=form action=\"$cgi\" method=post>\n";
  $sth = $dbh->prepare("SELECT * FROM nas WHERE id = \"".$query->param('nasid')."\"");
  $sth->execute;
  my @nas = $sth->fetchrow_array;
  print "<center><table border=0>\n";
  print "<tr><td>NAS Name</td><td><input type=text name=\"nasname\" value=\"$nas[1]\" size=35></td></tr>\n";
  print "<tr><td>Short Name</td><td><input type=text name=\"shortame\" value=\"$nas[2]\" size=25></td></tr>\n";
  print "<tr><td>IP Address</td><td><input type=text name=\"ipaddr\" value=\"$nas[3]\" size=15></td></tr>\n";
  print "<tr><td>Type</td><td><input type=text name=\"type\" value=\"$nas[4]\" size=20></td></tr>\n";
  print "<tr><td>Number of Ports</td><td><input type=text name=\"ports\" value=\"$nas[5]\" size=10></td></tr>\n";
  print "<tr><td>Secret</td><td><input type=text name=\"secret\" value=\"$nas[6]\" size=25></td></tr>\n";
  print "<tr><td>SNMP Comminity</td><td><input type=text name=\"community\" value=\"$nas[7]\" size=25></td></tr>\n";
  my $CHECKED = '';
  $CHECKED = 'CHECKED' if $nas[8] eq 'on';
  print "<tr><td>SNMP Port<br>Limit Checking</td><td><input type=checkbox name=\"snmp\" value=\"YES\" $CHECKED></td></tr>\n";
  print "</table>\n";
  print "<input type=submit value=\"Save Changes\"><input type=button value=\"Cancel\" onClick=\"window.close()\">\n";
  print "</center></form>\n";
  print "</html>\n";



} elsif ($query->param('action') eq 'managenas') {

  print "<html>\n";
  print "<head>\n";
  print "<script language=\"JavaScript\">\n";
  print qq!

   function newnas() {
      url = "$cgi\?action=newnas"
      newnaswin = window.open(url,"remotewin","width=530,height=400,scrollbars=yes");
   }

   function editnas(id) {
      url = "$cgi\?action=editnas\&nasid="+id
      editnaswin = window.open(url,"remotewin","width=530,height=500,scrollbars=yes");
   }

   function check() {
      message=("Remove Selected NAS Configurations?")
      if(confirm(message)) {
        return true
      } else {
        return false
      }
   }

  !;                                                                                                     print "</script></head>\n";
  print "$body\n";
  print "<center><h2>ICRADIUS Web Interface</h2></center>\n";
  print "<br><center><h3>Current NAS Configurations</h3></center>\n";
                                                                                                         print "<form action=\"$cgi\" method=post>\n";                                                          print "<center><table border=1>\n";
  print "<tr><th>NAS Name</th><th>Short Name</th><th>IP Address</th><th>NAS Type</th><th>Ports</th><th>Shared Secret</th><th>SNMP Community</th><th>Use SNMP</th><th>Select</th></tr>\n";
  $sth = $dbh->prepare("SELECT * FROM nas");
  $sth->execute;
  while (my @nas = $sth->fetchrow_array) {
    print "<tr align=center><td><a href=\"javascript:editnas($nas[0])\">$nas[1]</a></td><td>$nas[2]</td><td>$nas[3]</td><td>$nas[4]</td><td>$nas[5]</td><td>$nas[6]</td><td>$nas[7]</td><td>$nas[8]</td><td><input type=checkbox name=nasid value=\"$nas[0]\"></tr>\n";
  }
  print "</table></center>\n";

  print "<br><center>\n";
  print "<input type=button value=\"Add NAS\" onClick=\"newnas()\">\n";
  print "<input type=submit name=\"removenas\" value=\"Delete Selected NASs\" onClick=\"return check()\">\n";
  print "</center></form>\n";

  print "</body></html>\n"; 



} elsif ($query->param('findgroup') ne '') {

   my @list = ();
   $sth = $dbh->prepare("SELECT DISTINCT GroupName FROM radgroupcheck WHERE GroupName LIKE \"".$query->param('group')."\%\"");
   $sth->execute;
   while (my $group = $sth->fetchrow_array) {
     push(@list, $group);
   }

   $sth = $dbh->prepare("SELECT DISTINCT GroupName FROM radgroupreply WHERE GroupName LIKE \"".$query->param('group')."\%\"");
   $sth->execute;
   while (my $group = $sth->fetchrow_array) {
     push(@list, $group);
   }


  print "<html>$body\n";
  print "<br><br><center><table border=1>\n";
  print "<tr><th>GroupName</th></tr>\n";
  my %seen = ();
  foreach my $group (@list) {
    next if $seen{$group}++;
    $sth = $dbh->prepare("SELECT id FROM radgroupcheck WHERE GroupName = \"$group\"");
    $sth->execute;
    my $groupid = $sth->fetchrow_array;
    my $from = 'check';
    if (!$groupid) {
       $sth = $dbh->prepare("SELECT id FROM radgroupreply WHERE GroupName = \"$group\"");
       $sth->execute;
       $groupid = $sth->fetchrow_array;
       $from = 'reply';
    }
      
    print "<tr align=center><td><a href=\"$cgi\?groupid=$groupid\&from=$from\&action=editgroup\" target=\"rightmainframe\">$group</a></td></tr>\n";
  }
  print "</table>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'edituser') {


  my $userid = $query->param('userid');
  print "<FRAMESET rows=\"155,*\" BORDER=\"0\">\n";
  print "  <FRAME NAME=\"editusertop\" src=\"$cgi?action=editusertop\">\n";
  print "  <FRAME NAME=\"edituserbody\" src=\"$cgi?action=userargvlist\&userid=$userid\">\n";
  print "</FRAMESET>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'editusertop') {

  print "<html>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2></center>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'userargvlist') {

   my $userid = $query->param('userid');

   print "<html>\n";
   print "<head>\n";
   print qq!

   <script language="javascript">

   function openwin() {
      url = "$cgi\?action=addtogroup\&userid=$userid"
      addtogroup = window.open(url,"remotewin","width=530,height=400,scrollbars=yes");

   }  

   function verify(from) {
      if (from == 'check')
       message=("Remove Selected Check Items?")
      else if (from == 'reply') 
       message=("Remove Selected Reply Items?")
      else if (from == 'group')
       message=("Remove User From Selected Groups?")
      else if (from == 'delete')
       message=("Delete This User?")

      if(confirm(message)) {
        return true
      } else {
        return false
      }           
   }
   </script>
   !;
   print "</head>$body\n";
   print "<a href=\"$cgi\?action=userargvlist\&userid=$userid#check\">Check Items</a>\&nbsp\;<a href=\"$cgi\?action=userargvlist\&userid=$userid#reply\">Reply Items</a>\&nbsp\;<a href=\"$cgi\?action=userargvlist\&userid=$userid#groups\">Groups</a>\n";
   $sth = $dbh->prepare("SELECT UserName FROM radcheck WHERE id = \"$userid\"");
   $sth->execute;
   my $name = $sth->fetchrow_array;

   print "<center><font size=4>UserName: $name</font><form action=\"$cgi\" method=post target=\"rightmainframe\">\n";
   print "<input type=hidden name=\"username\" value=\"$name\">\n";
   print "<input type=submit name=\"dodeluser\" value=\"Delete This User\" OnClick=\"return verify('delete')\">\n";
   print "</form>\n";
   print "</center><br>\n";

   $sth = $dbh->prepare("SELECT * FROM radcheck WHERE UserName = \"$name\"");
   $sth->execute;
   print "<a name=\"check\">\n";
   print "<center><font size=4>Check Items</font></center>\n";
   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<br><center><table border=1>\n";
   print "<tr align=center><th>Attribute</th><th>Value</th><th>Check To<br>Remove</th><th>Group</th></tr>\n";
   while (my @checks = $sth->fetchrow_array) {
      print "<tr><td><a href=\"$cgi\?action=editusercheck\&userid=$checks[0]\" target=\"editusertop\">$checks[2]</a></td><td>$checks[3]</td><td align=center><input type=checkbox name=argvid value=\"$checks[0]\"></td><td align=center>--</td></tr>\n";
   }
   $sth = $dbh->prepare("SELECT radgroupcheck.* FROM radgroupcheck, usergroup where usergroup.GroupName = radgroupcheck.GroupName and usergroup.UserName = \"$name\"");
   $sth->execute;
   while (my @checks = $sth->fetchrow_array) {
      print "<tr><td><font color=green>$checks[2]</font></td><td><font color=green>$checks[3]</font></td><td align=center><font color=green>--</font></td><td align=center><a href=\"$cgi\?action=editgroup\&groupid=$checks[0]\&from=check\" target=\"rightmainframe\">$checks[1]</a></td></tr>\n";
   }
   print "</table>\n\n";

   print "<br><table border=0>\n";
   print "<tr><td><input type=submit name=\"removeuserchecks\" value=\"Remove Selected Check Items\" OnClick=\"return verify('check')\"></td>\n";
   print "</form>\n";
   print "<form action=\"$cgi\" method=post target=\"editusertop\">\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<input type=hidden name=\"username\" value=\"$name\">\n";
   print "<td><input type=submit name=\"addusercheck\" value=\"Add Check Item\"></td></tr>\n";
   print "</table>\n";
   print "</form></center>\n\n\n\n";


   print "<br><br>\n";
   $sth = $dbh->prepare("SELECT * FROM radreply WHERE UserName = \"$name\"");
   $sth->execute;
   print "<a name=\"reply\">\n";
   print "<center><font size=4>Reply Items</font></center>\n";
   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<br><center><table border=1>\n";
   print "<tr align=center><th>Attribute</th><th>Value</th><th>Check To<br>Remove</th><th>Group</th></tr>\n";
   while (my @reply = $sth->fetchrow_array) {
      print "<tr><td><a href=\"$cgi\?action=edituserreply\&userid=$userid\&replyid=$reply[0]\" target=\"editusertop\">$reply[2]</a></td><td>$reply[3]</td><td align=center><input type=checkbox name=argvid value=\"$reply[0]\"></td><td align=center>--</td></tr>\n";
   }
   $sth = $dbh->prepare("SELECT radgroupreply.* FROM radgroupreply, usergroup where usergroup.GroupName = radgroupreply.GroupName and usergroup.UserName = \"$name\"");
   $sth->execute;
   while (my @reply = $sth->fetchrow_array) {
      print "<tr><td><font color=green>$reply[2]</font></td><td><font color=green>$reply[3]</font></td><td align=center><font color=green>--</font></td><td align=center><a href=\"$cgi\?action=editgroup\&groupid=$reply[0]\&from=reply\" target=\"rightmainframe\">$reply[1]</a></td></tr>\n";
   }
   print "</table>\n\n";

   print "<br><table border=0>\n";
   print "<tr><td><input type=submit name=\"removeuserreply\" value=\"Remove Selected Reply Items\" OnClick=\"return verify('reply')\"></td>\n";
   print "</form>\n";
   print "<form action=\"$cgi\" method=post target=\"editusertop\">\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<input type=hidden name=\"username\" value=\"$name\">\n";
   print "<td><input type=submit name=\"adduserreply\" value=\"Add Reply Item\"></td></tr>\n";
   print "</table>\n";
   print "</form></center>\n\n\n\n";
   print "<br><center>Note: green items are inheriteded from groups\n</center>";



   print "<br><br><br>\n";
   print "<a name=\"groups\">\n";
   print "<center><font size=4>Group Memberships</font></center>\n";
   $sth = $dbh->prepare("SELECT * FROM usergroup WHERE UserName = \"$name\"");
   $sth->execute;
   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<center><table border=1>\n";
   print "<tr><th>GroupName</th><th>Check To Remove<br>From Group</th></tr>\n";
   while (my @groups = $sth->fetchrow_array) {
      print "<tr><td><a href=\"$cgi\?action=editusergroup\&groupid=$groups[0]\" target=\"rightmaingrame\">$groups[2]</a></td><td align=center><input type=checkbox name=\"usergroupid\" value=\"$groups[0]\"></tr>\n";
   }
   print "</table>\n";

   print "<br><table border=0>\n";
   print "<tr><td><input type=submit name=\"removeusergroup\" value=\"Remove From Selected Groups\" OnClick=\"return verify('group')\"></td>\n";
   print "<td><input type=button value=\"Add To Groups\" OnClick=\"openwin()\"></td></tr>\n";
   print "</table>\n";
   print "</form></center>\n";
 
   print "</body></html>\n";

   $printmainpage = 0;

} elsif ($query->param('action') eq 'addtogroup') {

   my $userid = $query->param('userid');
   $sth = $dbh->prepare("SELECT UserName FROM radcheck WHERE id = \"$userid\"");
   $sth->execute;
   my $name = $sth->fetchrow_array;
   print "<html><head><title>Select Groups</title></head>$body\n";
   print "<center><font size=4>Select Groups</font></center>\n";
   print "<br><center><font size=3>Adding Groups to User: $name</font></center>\n";

   my @list = ();
   $sth = $dbh->prepare("SELECT DISTINCT GroupName FROM radgroupcheck");
   $sth->execute;
   while (my $group = $sth->fetchrow_array) {
     push(@list, $group);
   }

   $sth = $dbh->prepare("SELECT DISTINCT GroupName FROM radgroupreply");
   $sth->execute;
   while (my $group = $sth->fetchrow_array) {
     push(@list, $group);
   }

   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"username\" value=\"$name\">\n";
   print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
   print "<center><select name=groups multiple>\n";
   my %seen = ();
   foreach my $group (@list) {
     print "<option>$group\n" unless $seen{$group}++;
   }
   print "</select><br>\n";
   print "<input type=submit name=\"doaddtogroup\" value=\"Add To Groups\">\n";
   print "\&nbsp\;<input type=button value=\"Close Window\" OnClick=\"window.close()\">\n";
   print "</form></body></html>\n";
   $printmainpage = 0;


} elsif ($query->param('addusercheck') ne '') {

  my $userid = $query->param('userid');
  print "<html><head>\n";
  print qq!

  <script language="javascript">
    function makechanges(userid) {
      top.rightmainframe.edituserbody.location.href="$cgi\?action=userargvlist\&userid="+userid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doaddusercheck') ne '') {
     print "<body OnLoad=\"makechanges(\'$userid\')\">\n";
  }
  print "<center><font size=4>Add User Check Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"addusercheck\" value=\"true\">\n";
  print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
  print "<input type=hidden name=\"username\" value=\"".$query->param('username')."\">\n";
  print "<input type=hidden name=\"oldattrib\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<select name=\"attribute\" OnChange=\"form1.submit()\">\n";
  if ($query->param('attribute')) {
    print "<option selected>".$query->param('attribute')."\n";
  } else {
    print "<option selected>Choose Check Item Attribute\n";
  }
  $sth = $dbh->prepare("SELECT Attribute, Vendor FROM dictionary WHERE type = 'ATTRIBUTE' ORDER BY Attribute");
  $sth->execute;
  while (my ($attrib, $vendor) = $sth->fetchrow_array) {
    next if $attrib eq $query->param('attribute');
    print "<option value=\"$attrib\">$attrib";
    print " (VSA $vendor)" if $vendor;
    print "\n";
  }
  print "</select></td>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value') if $query->param('attribute') eq $query->param('oldattrib');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=10></td>\n";
  }
  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doaddusercheck\" value=\"Add Check Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";
  
  $printmainpage = 0;

} elsif ($query->param('adduserreply') ne '') {

  my $userid = $query->param('userid');
  print "<html>\n";
  print qq!

  <script language="javascript">
    function makechanges(userid) {
      top.rightmainframe.edituserbody.location.href="$cgi\?action=userargvlist\&userid="+userid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doadduserreply') ne '') {
     print "<body OnLoad=\"makechanges(\'$userid\')\">\n";
  }
  print "<center><font size=4>Add User Reply Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"adduserreply\" value=\"true\">\n";
  print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
  print "<input type=hidden name=\"username\" value=\"".$query->param('username')."\">\n";
  print "<input type=hidden name=\"oldattrib\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<select name=\"attribute\" OnChange=\"form1.submit()\">\n";
  if ($query->param('attribute')) {
    print "<option selected>".$query->param('attribute')."\n";
  } else {
    print "<option selected>Choose Reply Item Attribute\n";
  }
  $sth = $dbh->prepare("SELECT Attribute, Vendor FROM dictionary WHERE type = 'ATTRIBUTE' ORDER BY Attribute");
  $sth->execute;
  while (my ($attrib, $vendor) = $sth->fetchrow_array) {
    next if $attrib eq $query->param('attribute');
    print "<option value=\"$attrib\">$attrib";
    print " (VSA $vendor)" if $vendor;
    print "\n";
  }
  print "</select></td>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value') if $query->param('attribute') eq $query->param('oldattrib');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }

  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doadduserreply\" value=\"Add Reply Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'editusercheck') {

  my $userid = $query->param('userid');
  $sth = $dbh->prepare("SELECT * FROM radcheck WHERE id = \"$userid\"");
  $sth->execute;
  my @checks = $sth->fetchrow_array;
  $query->param('attribute', $checks[2]);
  $query->param('value', $checks[3]);
  print "<html><head>\n";
  print qq!

  <script language="javascript">
    function makechanges(userid) {
      top.rightmainframe.edituserbody.location.href="$cgi\?action=userargvlist\&userid="+userid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doeditusercheck') ne '') {
     print "<body OnLoad=\"makechanges(\'$userid\')\">\n";
  }
  print "<center><font size=4>Edit User Check Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"action\" value=\"editusercheck\">\n";
  print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
  print "<input type=hidden name=\"attribute\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<font size=4>Attribute: ".$query->param('attribute')."</font>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }
  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doeditusercheck\" value=\"Save Changes To Check Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";
  
  $printmainpage = 0;


} elsif ($query->param('action') eq 'edituserreply') {

  my $userid = $query->param('userid');
  my $replyid = $query->param('replyid');
  $sth = $dbh->prepare("SELECT * FROM radreply WHERE id = \"$replyid\"");
  $sth->execute;
  my @reply = $sth->fetchrow_array;
  $query->param('attribute', $reply[2]);
  $query->param('value', $reply[3]);
  print "<html>\n";
  print qq!

  <script language="javascript">
    function makechanges(userid) {
      top.rightmainframe.edituserbody.location.href="$cgi\?action=userargvlist\&userid="+userid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doedituserreply') ne '') {
     print "<body OnLoad=\"makechanges(\'$userid\')\">\n";
  }
  print "<center><font size=4>Edit User Reply Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"action\" value=\"edituserreply\">\n";
  print "<input type=hidden name=\"userid\" value=\"$userid\">\n";
  print "<input type=hidden name=\"replyid\" value=\"$replyid\">\n";
  print "<input type=hidden name=\"attribute\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<font size=4>Attribute: ".$query->param('attribute')."</font>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }

  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doedituserreply\" value=\"Save Changes To Reply Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'editgroup') {


  my $groupid = $query->param('groupid');
  my $from = $query->param('from');
  print "<FRAMESET rows=\"155,*\" BORDER=\"0\">\n";
  print "  <FRAME NAME=\"editgrouptop\" src=\"$cgi?action=editgrouptop\">\n";
  print "  <FRAME NAME=\"editgroupbody\" src=\"$cgi?action=groupargvlist\&groupid=$groupid\&from=$from\">\n";
  print "</FRAMESET>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'editgrouptop') {

  print "<html>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2></center>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'groupargvlist') {

   my $groupid = $query->param('groupid');
   my $from = $query->param('from');

   print "<html>\n";
   print "<head>\n";
   print qq!

   <script language="javascript">

   function openwin() {
      url = "$cgi\?action=addtogroup\&groupid=$groupid"
      addtogroup = window.open(url,"remotewin","width=530,height=400,scrollbars=yes");

   }  

   function verify(from) {
      if (from == 'check')
       message=("Remove Selected Check Items?")
      else if (from == 'reply') 
       message=("Remove Selected Reply Items?")
      else if (from == 'delete') 
       message=("Delete This Group?")

      if(confirm(message)) {
        return true
      } else {
        return false
      }           
   }
   </script>
   !;
   print "</head>$body\n";
   print "<a href=\"$cgi\?action=groupargvlist\&groupid=$groupid#check\">Check Items</a>\&nbsp\;<a href=\"$cgi\?action=groupargvlist\&groupid=$groupid#reply\">Reply Items</a>\n";
   my $name;
   if ($query->param('groupname') eq '') {
       $sth = $dbh->prepare("SELECT GroupName FROM radgroup$from WHERE id = \"$groupid\"");
       $sth->execute;
       $name = $sth->fetchrow_array;
    } else {
       $name = $query->param('groupname');
    }

   print "<center><font size=4>GroupName: $name</font><form action=\"$cgi\" method=post target=\"rightmainframe\">\n";
   print "<input type=hidden name=\"groupname\" value=\"$name\">\n";
   print "<input type=submit name=\"dodelgroup\" value=\"Delete This Group\" OnClick=\"return verify('delete')\">\n";
   print "</form>\n";
   print "</center><br>\n";

   $sth = $dbh->prepare("SELECT * FROM radgroupcheck WHERE GroupName = \"$name\"");
   $sth->execute;
   print "<a name=\"check\">\n";
   print "<center><font size=4>Check Items</font></center>\n";
   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
   print "<input type=hidden name=\"groupname\" value=\"$name\">\n";
   print "<br><center><table width=320 border=1>\n";
   print "<tr align=center><th>Attribute</th><th>Value</th><th>Check To<br>Remove</th></tr>\n";
   while (my @checks = $sth->fetchrow_array) {
      print "<tr><td><a href=\"$cgi\?action=editgroupcheck\&groupid=$checks[0]\" target=\"editgrouptop\">$checks[2]</a></td><td>$checks[3]</td><td align=center><input type=checkbox name=argvid value=\"$checks[0]\"></td></tr>\n";
   }
   print "</table>\n\n";

   print "<br><table border=0>\n";
   print "<tr><td><input type=submit name=\"removegroupchecks\" value=\"Remove Selected Check Items\" OnClick=\"return verify('check')\"></td>\n";
   print "</form>\n";
   print "<form action=\"$cgi\" method=post target=\"editgrouptop\">\n";
   print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
   print "<input type=hidden name=\"groupname\" value=\"$name\">\n";
   print "<td><input type=submit name=\"addgroupcheck\" value=\"Add Check Item\"></td></tr>\n";
   print "</table>\n";
   print "</form></center>\n\n\n\n";


   print "<br><br>\n";
   $sth = $dbh->prepare("SELECT * FROM radgroupreply WHERE GroupName = \"$name\"");
   $sth->execute;
   print "<a name=\"reply\">\n";
   print "<center><font size=4>Reply Items</font></center>\n";
   print "<form action=\"$cgi\" method=post>\n";
   print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
   print "<input type=hidden name=\"groupname\" value=\"$name\">\n";
   print "<br><center><table width=320 border=1>\n";
   print "<tr align=center><th>Attribute</th><th>Value</th><th>Check To<br>Remove</th></tr>\n";
   while (my @reply = $sth->fetchrow_array) {
      print "<tr><td><a href=\"$cgi\?action=editgroupreply\&groupid=$reply[0]\" target=\"editgrouptop\">$reply[2]</a></td><td>$reply[3]</td><td align=center><input type=checkbox name=argvid value=\"$reply[0]\"></td></tr>\n";
   }
   print "</table>\n\n";

   print "<br><table border=0>\n";
   print "<tr><td><input type=submit name=\"removegroupreply\" value=\"Remove Selected Reply Items\" OnClick=\"return verify('reply')\"></td>\n";
   print "</form>\n";
   print "<form action=\"$cgi\" method=post target=\"editgrouptop\">\n";
   print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
   print "<input type=hidden name=\"groupname\" value=\"$name\">\n";
   print "<td><input type=submit name=\"addgroupreply\" value=\"Add Reply Item\"></td></tr>\n";
   print "</table>\n";
   print "</form></center>\n\n\n\n";
 
   print "</body></html>\n";

   $printmainpage = 0;


} elsif ($query->param('addgroupcheck') ne '') {

  my $groupid = $query->param('groupid');
  print "<html><head>\n";
  print qq!

  <script language="javascript">
    function makechanges(groupid) {
      top.rightmainframe.editgroupbody.location.href="$cgi\?action=groupargvlist\&from=check\&groupid="+groupid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doaddgroupcheck') ne '') {
     print "<body OnLoad=\"makechanges(\'$groupid\')\">\n";
  }
  print "<center><font size=4>Add Group Check Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"addgroupcheck\" value=\"true\">\n";
  print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
  print "<input type=hidden name=\"groupname\" value=\"".$query->param('groupname')."\">\n";
  print "<input type=hidden name=\"oldattrib\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<select name=\"attribute\" OnChange=\"form1.submit()\">\n";
  if ($query->param('attribute')) {
    print "<option selected>".$query->param('attribute')."\n";
  } else {
    print "<option selected>Choose Check Item Attribute\n";
  }
  $sth = $dbh->prepare("SELECT Attribute, Vendor FROM dictionary WHERE type = 'ATTRIBUTE' ORDER BY Attribute");
  $sth->execute;
  while (my ($attrib, $vendor) = $sth->fetchrow_array) {
    next if $attrib eq $query->param('attribute');
    print "<option value=\"$attrib\">$attrib";
    print " (VSA $vendor)" if $vendor;
    print "\n";
  }
  print "</select></td>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value') if $query->param('attribute') eq $query->param('oldattrib');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }
  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doaddgroupcheck\" value=\"Add Check Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;
 

} elsif ($query->param('addgroupreply') ne '') {

  my $groupid = $query->param('groupid');
  print "<html>\n";
  print qq!

  <script language="javascript">
    function makechanges(groupid) {
      top.rightmainframe.editgroupbody.location.href="$cgi\?action=groupargvlist\&from=reply\&groupid="+groupid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doaddgroupreply') ne '') {
     print "<body OnLoad=\"makechanges(\'$groupid\')\">\n";
  }
  print "<center><font size=4>Add Group Reply Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"addgroupreply\" value=\"true\">\n";
  print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
  print "<input type=hidden name=\"groupname\" value=\"".$query->param('groupname')."\">\n";
  print "<input type=hidden name=\"oldattrib\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<select name=\"attribute\" OnChange=\"form1.submit()\">\n";
  if ($query->param('attribute')) {
    print "<option selected>".$query->param('attribute')."\n";
  } else {
    print "<option selected>Choose Reply Item Attribute\n";
  }
  $sth = $dbh->prepare("SELECT Attribute, Vendor FROM dictionary WHERE type = 'ATTRIBUTE' ORDER BY Attribute");
  $sth->execute;
  while (my ($attrib, $vendor) = $sth->fetchrow_array) {
    next if $attrib eq $query->param('attribute');
    print "<option value=\"$attrib\">$attrib";
    print " (VSA $vendor)" if $vendor;
    print "\n";
  }
  print "</select></td>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value') if $query->param('attribute') eq $query->param('oldattrib');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }

  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doaddgroupreply\" value=\"Add Reply Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'editgroupcheck') {

  my $groupid = $query->param('groupid');
  $sth = $dbh->prepare("SELECT * FROM radgroupcheck WHERE id = \"$groupid\"");
  $sth->execute;
  my @checks = $sth->fetchrow_array;
  $query->param('attribute', $checks[2]);
  $query->param('value', $checks[3]);
  print "<html><head>\n";
  print qq!

  <script language="javascript">
    function makechanges(groupid) {
      top.rightmainframe.editgroupbody.location.href="$cgi\?action=groupargvlist\&from=check\&groupid="+groupid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doeditgroupcheck') ne '') {
     print "<body OnLoad=\"makechanges(\'$groupid\')\">\n";
  }
  print "<center><font size=4>Edit Group Check Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"action\" value=\"editgroupcheck\">\n";
  print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
  print "<input type=hidden name=\"attribute\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<font size=4>Attribute: ".$query->param('attribute')."</font>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value');
  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }

  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doeditgroupcheck\" value=\"Save Changes To Check Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";
  
  $printmainpage = 0;


} elsif ($query->param('action') eq 'editgroupreply') {

  my $groupid = $query->param('groupid');
  $sth = $dbh->prepare("SELECT * FROM radgroupreply WHERE id = \"$groupid\"");
  $sth->execute;
  my @reply = $sth->fetchrow_array;
  $query->param('attribute', $reply[2]);
  $query->param('value', $reply[3]);
  print "<html>\n";
  print qq!

  <script language="javascript">
    function makechanges(groupid) {
      top.rightmainframe.editgroupbody.location.href="$cgi\?action=groupargvlist\&from=reply\&groupid="+groupid
    }
  </script>

  !;
  print "</head>$body\n";
  if ($query->param('doeditgroupreply') ne '') {
     print "<body OnLoad=\"makechanges(\'$groupid\')\">\n";
  }
  print "<center><font size=4>Edit Group Reply Item</font></center>\n";
  print "<br><hr width=200>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=\"action\" value=\"editgroupreply\">\n";
  print "<input type=hidden name=\"groupid\" value=\"$groupid\">\n";
  print "<input type=hidden name=\"attribute\" value=\"".$query->param('attribute')."\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>\n";
  print "<font size=4>Attribute: ".$query->param('attribute')."</font>\n";
  print "<td width=50></td>\n";
  my $val = $query->param('value');

  $sth = $dbh->prepare("SELECT Value FROM dictionary WHERE Type = 'VALUE' AND Attribute = '".$query->param('attribute')."'");
  $sth->execute;
  my @vals;
  while (my ($currval) = $sth->fetchrow_array) {
    push(@vals, $currval);
  }
  if (@vals) {
     print "<td><select name=\"value\">\n";
     print "<option selected>$val\n" if $val;
     foreach my $printval (@vals) {
        next if $printval eq $val;
        print "<option>$printval\n";
     }
     print "</select></td>\n";
  } else {
     print "<td><input type=textbox name=\"value\" value=\"$val\" size=20></td>\n";
  }

  print "<td width=50></td>\n";
  print "<td><input type=submit name=\"doeditgroupreply\" value=\"Save Changes To Reply Item\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;



} elsif ($query->param('action') eq 'adduser') {
 
  print "<html>$body\n";
  print "<body OnLoad=\"document.form1.username.focus()\">\n";
  print "<center><font size=4>Add New User</font></center>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<center><table border=0>\n";
  print "<tr><td>Username</td><td width=20></td><td><input type=text name=username></td></tr>\n";
  print "<tr><td>Password</td><td width=20></td><td><input type=text name=password></td></tr>\n";
  print "<tr><td></td><td></td><td><input type=submit name=\"doadduser\" value=\"Add User\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'addgroup') {

  print "<FRAMESET rows=\"155,*\" BORDER=\"0\">\n";
  print "  <FRAME NAME=\"editgrouptop\" src=\"$cgi?action=blankframe\">\n";
  print "  <FRAME NAME=\"editgroupbody\" src=\"$cgi?action=realaddgroup\">\n";
  print "</FRAMESET>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'realaddgroup') {
 
  print "<html>$body\n";
  print "<body OnLoad=\"document.form1.username.focus()\">\n";
  print "<center><font size=4>Add New Group</font></center>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<input type=hidden name=groupid value=\"0\">\n";
  print "<input type=hidden name=action value=\"groupargvlist\">\n";
  print "<center><table border=0>\n";
  print "<tr><td>Groupname</td><td width=20></td><td><input type=text name=groupname></td></tr>\n";
  print "<tr><td></td><td></td><td><input type=submit value=\"Add Group\"></td></tr>\n";
  print "</table></center>\n";
  print "</body></html>\n";

  $printmainpage = 0;

} elsif ($query->param('action') eq 'loginstatus' || $query->param('loginstatusreport') ne '') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title>\n";

  print qq!
  <script language=javascript>

  function resetdate() {
  
    d = new Date();
    m = d.getMonth();
    m++;
    y = d.getFullYear();
    t = d.getTime();
    day = d.getDate();
    h = d.getHours();
    min = d.getMinutes();
    sec = d.getSeconds();
    time = y+"-"+m+"-"+day+" "+h+":"+min+":"+sec;

    document.form1.fromtime.value = time;
    document.form1.totime.value = time;
    document.form1.username.focus();
  }

  function clearboxes() {

    document.form1.username.value = ''
    document.form1.fromtime.value = ''
    document.form1.totime.value = ''
    document.form1.nasip.value = ''
    document.form1.nasport.value = ''
    document.form1.nasporttype.value = ''
    document.form1.framedipaddress.value = ''
//    document.form1.terminatecause.SelectedIndex = 0
    document.form1.username.focus()

  }

  </script>

  !;

  print "</head>$body<body onload=\"document.form1.username.focus()\">\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Leave From and To Time blank to search current logged in users<br>\n";
  print "<form name=form1 action=\"$cgi\" method=post>\n";
  print "<br><table>\n";
  my $fromtime = getdatetime() if $query->param('loginstatusreport') eq '';
  $fromtime = $query->param('fromtime') if $query->param('fromtime');
  my $totime = getdatetime() if $query->param('loginstatusreport') eq '';
  $totime = $query->param('totime') if $query->param('totime');
  print "<tr><td>User</td><td><input type=text name=username value=\"".$query->param('username')."\"></td><td width=20></td><td>NAS IP Address</td><td><input type=text name=nasip value=\"".$query->param('nasip')."\"></td></tr>\n";
  print "<tr><td>From Time</td><td><input type=text name=fromtime value=\"$fromtime\"></td><td width=20></td><td>NAS Port</td><td><input type=text name=nasport value=\"".$query->param('nasport')."\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=totime value=\"$totime\"></td><td width=20></td><td>NAS Port Type</td><td><input type=text name=nasporttype value=\"".$query->param('nasporttype')."\"></td></tr>\n";
  print "<tr><td>Framed IP Address</td><td><input type=text name=framedipaddress value=\"".$query->param('framedipaddress')."\"></td><td></td><td>Terminate Cause</td><td>";
  print "<select name=terminatecause>\n";
  print "<option selected>".$query->param('terminatecause')."\n";

  my @termcauses = ("","User-Request","Lost-Carrier","Lost-Service","Idle-Timeout","Session-Timeout","Admin-Reset","Admin-Reboot","Port-Error","NAS-Error","NAS-Request","NAS-Reboot","Port-Unneeded","Port-Preempted","Port-Suspended","Service-Unavailable","Callback","User-Error","Host-Request");
  foreach my $cause (@termcauses) {
     next if $cause eq $query->param('terminatecause');
     print "<option>$cause\n";
   }

  print "</select></td></tr>\n";
  print "<tr><td></td><td><input type=submit name=loginstatusreport value=\"Get Report\">\&nbsp\;<input type=button value=\"Clear Form\" onclick=\"clearboxes()\">\&nbsp\;<input type=button value=\"Fill Dates\" onclick=\"resetdate()\"></td><td></td><td></td></tr>\n";
  print "</table></form>\n";


  $printmainpage = 0;


} elsif ($query->param('action') eq 'getrecord') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<table width=400 border=1>";
  print "<tr align=center><th>Attribute</th><th>Value</th></tr>\n";
  $sth = $dbh->prepare("select * from radacct where RadacctID = \"".$query->param('id')."\"");
  $sth->execute;
  my @recorddata = $sth->fetchrow_array;
  print "<tr><td>Radius-Id</td><td>$recorddata[0]</td></tr>\n";
  print "<tr><td>Acct-Session-Id</td><td>$recorddata[1]</td></tr>\n";
  print "<tr><td>User-Name</td><td>$recorddata[2]</td></tr>\n";
  print "<tr><td>Realm</td><td>$recorddata[3]</td></tr>\n";
  print "<tr><td>NAS-IP-Address</td><td>$recorddata[4]</td></tr>\n";
  print "<tr><td>NAS-Port-Id</td><td>$recorddata[5]</td></tr>\n";
  print "<tr><td>NAS-Port-Type</td><td>$recorddata[6]</td></tr>\n";
  print "<tr><td>Acct-Start-Time</td><td>$recorddata[7]</td></tr>\n";
  print "<tr><td>Acct-Stop-Time</td><td>$recorddata[8]</td></tr>\n";
  print "<tr><td>Acct-Session-Time</td><td>$recorddata[9]</td></tr>\n";
  print "<tr><td>Acct-Authentic</td><td>$recorddata[10]</td></tr>\n";
  print "<tr><td>Connect-Info</td><td>$recorddata[11]</td></tr>\n";
  print "<tr><td>Acct-Input-Octets</td><td>$recorddata[12]</td></tr>\n";
  print "<tr><td>Acct-Output-Octets</td><td>$recorddata[13]</td></tr>\n";
  print "<tr><td>Called-Station-Id</td><td>$recorddata[14]</td></tr>\n";
  print "<tr><td>Calling-Station-Id</td><td>$recorddata[15]</td></tr>\n";
  print "<tr><td>Acct-Terminate-Cause</td><td>$recorddata[16]</td></tr>\n";
  print "<tr><td>Service-Type</td><td>$recorddata[17]</td></tr>\n";
  print "<tr><td>Framed-Protocol</td><td>$recorddata[18]</td></tr>\n";
  print "<tr><td>Framed-IP-Address</td><td>$recorddata[19]</td></tr>\n";
  print "<tr><td>Acct-Start-Delay-Time</td><td>$recorddata[20]</td></tr>\n";
  print "<tr><td>Acct-Stop-Delay-Time</td><td>$recorddata[21]</td></tr>\n";
  print "</table><br>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'viewlog') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Display how many lines from the bottom of the log file?<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table border=0>\n";
  print "<tr><td><input type=text name=lines size=\"5\" value=\"30\"></td><td><input type=submit name=\"doviewlog\" value=\"Display Log\"></td></tr>\n";
  print "</table></form>\n";
  print "</body></html>\n";

  $printheader = 0;

} elsif ($query->param('action') eq 'detailed') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "Enter date ranges and username below. Leave dates blank for a complete total.<br>\n";
  print "<form action=\"$cgi\" method=post><br>\n";
  print "<table>";
  print "<tr><td>UserName</td><td><input type=text name=username value=\"".$query->param('username')."\"></td></tr>\n";
  print "<tr><td>From Time</td><td><input type=text name=from value=\"\"></td></tr>\n";
  print "<tr><td>To Time</td><td><input type=text name=to value=\"$now\"></td></tr>\n";
  print "</table>\n";
  print "<input type=submit name=\"detailedreport\" value=\"Get Report\"><br>\n";

  $printmainpage = 0;


} elsif ($query->param('action') eq 'abuse' || $query->param('abusereport') ne '') {


  my $printlimit = "240";
  $printlimit = $query->param('hours') if $query->param('hours');
  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<h3>Abuse Report</h3>\n";
  print "<form action=\"$cgi\" method=post>\n";
  print "<table border=0>\n";
  print "<tr><td>Select Year and Month</td><td><select name=year>\n";
  print "<option>1999\n";
  print "<option>2000\n";
  print "<option>2001\n";
  print "<option>2002\n";
  print "</select><select name=month>\n";
  print "<option value=\"01\">January\n";
  print "<option value=\"02\">Feburary\n";
  print "<option value=\"03\">March\n";
  print "<option value=\"04\">April\n";
  print "<option value=\"05\">May\n";
  print "<option value=\"06\">June\n";
  print "<option value=\"07\">July\n";
  print "<option value=\"08\">August\n";
  print "<option value=\"09\">September\n";
  print "<option value=\"10\">October\n";
  print "<option value=\"11\">November\n";
  print "<option value=\"12\">December\n";
  print "</select></td></tr>\n";
  print "<tr><td>Enter limit in hours</td><td><input type=text name=hours value=\"$printlimit\" size=5></td></tr>\n";
  print "<tr><td></td><td><input type=submit name=abusereport value=\"Get Report\"></td></tr>\n";
  print "</table><br>\n";

  $printmainpage = 0;
}


if ($query->param('loginstatusreport') ne '') {


  print "<br><br><center><table border =1>\n";
  my $sql;

    print "<tr><th>UserName</th><th>IP Address</th><th>NAS IP/Port</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";

    if ($query->param('fromtime') eq '' && $query->param('totime') eq '') {
       $sql = "SELECT UserName, FramedIPAddress, AcctStartTime, AcctStopTime, AcctSessionTime, RadacctID, concat\(nasipaddress, '/S', nasportid\) FROM radacct WHERE AcctStopTime = 0";
    } else {
       $sql = "SELECT UserName, FramedIPAddress, AcctStartTime, AcctStopTime, AcctSessionTime, RadacctID, concat\(nasipaddress, '/S', nasportid\) FROM radacct WHERE \(AcctStopTime >= \"".$query->param('fromtime')."\" AND AcctStartTime <= \"".$query->param('totime')."\"\)";
    }


    $sql .= " AND UserName = \"".$query->param('username')."\"" if $query->param('username');
    $sql .= " AND NASIPAddress = \"".$query->param('nasip')."\"" if $query->param('nasip');
    $sql .= " AND NASPortId = \"".$query->param('nasport')."\"" if $query->param('nasport');
    $sql .= " AND NASPortType = \"".$query->param('nasporttype')."\"" if $query->param('nasporttype');
    $sql .= " AND FramedIPAddress = \"".$query->param('framedipaddress')."\"" if $query->param('framedipaddress');
    $sql .= " AND AcctTerminateCause = \"".$query->param('terminatecause')."\"" if $query->param('terminatecause');
  
    $sql .= " ORDER BY UserName";

    $sth = $dbh->prepare($sql);
  #  print "SQL: $sql<br>\n";
    $sth->execute || print "error was ". $dbh->errstr;
    my $timeused;
    my $secused;
    my $timesth;
    my $stoptimedisplay;
    while (my @sessiondata = $sth->fetchrow_array) {
       $i++;
       if ($sessiondata[4] eq '0') {
         $timesth = $dbh->prepare("SELECT UNIX_TIMESTAMP\(NOW\(\)\) - UNIX_TIMESTAMP\(\"$sessiondata[2]\"\)");
         $timesth->execute;
         $secused = $timesth->fetchrow_array;
         $timeused = formatseconds($secused);
         $total += $secused;
       } else {
         $timeused = formatseconds($sessiondata[4]);
         $total += $sessiondata[4];
       }
       $stoptimedisplay = $sessiondata[3];
       $stoptimedisplay = "Currently Logged On" if $sessiondata[3] eq '0000-00-00 00:00:00';
       print "<tr><td><a href=\"$cgi\?action=getrecord\&id=$sessiondata[5]\">$sessiondata[0]</a></td><td>$sessiondata[1]</td><td>$sessiondata[6]</td><td>$sessiondata[2]</td><td>$stoptimedisplay</td><td>$timeused</td></tr>\n";

    }

  my $realtotal = formatseconds($total);
  print "</table>\n";
  print "<br>Total Sessions: $i<br>\n";
  print "Total Usage: $realtotal<br>\n";



} elsif ($query->param('detailedreport') ne '') {


  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Detailed report for user '".$query->param('username')."':<br>\n";
  my $from = 'Any';
  my $to = 'Any';
  $from = $query->param('from') if $query->param('from');
  $to = $query->param('to') if $query->param('to');
  print "From: $from\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;To: $to<br><br>\n";
  print "<center><table border =1>\n";
  print "<tr><th>UserName</th><th>IP Address</th><th>Start Time</th><th>Stop Time</th><th>Time Used</th></tr>\n";
  my ($sql, $sumsth);
  
     if ($query->param('from') ne '' && $query->param('to') ne '') {


        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" AND AcctStopTime <= \"".$query->param('to')."\" AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     } elsif ($query->param('from') ne '') {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" AND UserName = \"".$query->param('username')."\"";

     } elsif ($query->param('to') ne '') {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE AcctStopTime <= \"".$query->param('to')."\" AND AcctStopTime != 0 AND UserName = \"".$query->param('username')."\"";

     } else {

        $sql = "SELECT UserName, RadacctID, AcctStartTime, AcctStopTime, FramedIPAddress, AcctSessionTime FROM radacct WHERE UserName = \"".$query->param('username')."\"";
     }

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $total = 0;
     my $printused;
     while (my @sessiondata = $sumsth->fetchrow_array) {
        $printused = formatseconds($sessiondata[5]);
        print "<tr align=center><td><a href=\"$cgi\?action=getrecord\&id=$sessiondata[1]\">$sessiondata[0]</a></td><td>$sessiondata[4]</td><td>$sessiondata[2]</td><td>$sessiondata[3]</td><td>$printused</td></tr>\n";
        $total += $sessiondata[5];
     }
  print "</table><br>\n";
  my $printtotal = formatseconds($total); 
  print "Total: $printtotal<br><br><br>\n";


} elsif ($query->param('utilgraph') ne '') {

  print "<html><head><title>InnerCite RADIUS Web Interface</title></head><body bgcolor=ffffff>\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Graph of nas usage at ".$query->param('time').":<br><br>\n" if $query->param('time') ne '';
  print "<br>Graph of current nas utilization<br><br>\n" if $query->param('time') eq '';
  
 
  print "<center><table>\n";
  print "<tr><th>Portmaster</th><th>Port Utilization</th></tr>\n";
  my $portsused;
  my $imagewidth = 0;

  my $sth1 = $dbh->prepare("SELECT id, ipaddr, shortname, ports FROM nas WHERE ports > 0 ORDER BY id");
  $sth1->execute;
  my ($junk, $rpercent, $percent, $totalports, $totalused, $diff, $displaydiff);
  while (my @pdata = $sth1->fetchrow_array) {

     if ($query->param('time') ne '') {
        $sth = $dbh->prepare("SELECT count\(*\) FROM radacct WHERE \(\(AcctStartTime <= \"".$query->param('time')."\" AND AcctStopTime >= \"".$query->param('time')."\"\) OR \(AcctStartTime <= \"".$query->param('time')."\" AND AcctStopTime = 0\)\) AND NASIPAddress = \"$pdata[1]\"");
     } else {
        $sth = $dbh->prepare("SELECT count\(*\) FROM radacct WHERE AcctStopTime = 0 AND NASIPAddress = \"$pdata[1]\" AND UserName != '' AND UserName != 'admin'");
     }
     $sth->execute || print "error was ". $dbh->errstr;
     $portsused = $sth->fetchrow_array;
     $imagewidth = $portsused * 7;
     $rpercent =  $portsused/$pdata[3] * 100;
     ($percent, $junk) = split(/\./, $rpercent);
     $diff = $pdata[3] - $portsused;
     $displaydiff = $diff * 7;
#     print "<tr><td>$pdata[2]</td><td><image src=\"/images/lside2.gif\" height=20><img src=\"/images/mid2.gif\" height=20 width=$imagewidth><img src=\"/images/rside2.gif\" height=20>  $portsused/$pdata[3]   ($percent\%)</td></tr>\n";
     print "<tr><td>$pdata[2]</td><td><image src=\"/images/l.gif\" height=20><img src=\"/images/lc.gif\" height=20 width=$imagewidth><img src=\"/images/rc.gif\" height=20><img src=\"/images/r.gif\" height=20 width=$displaydiff><img src=\"/images/rr.gif\" height=20>  $portsused/$pdata[3]   ($percent\%)</td></tr>\n";

    $totalports += $pdata[3];
    $totalused += $portsused;

  } 
  my $totalpercent = $totalused/$totalports * 100;
  ($percent, $junk) = split(/\./, $totalpercent);
  print "</table><br><br>\n";
  print "Available <img src=\"/images/yellow.gif\" width=20 height=20>   Used <img src=\"/images/red.gif\" width=20 height=20>\&nbsp\;\&nbsp\;\&nbsp\;\&nbsp\;\n";
  print "Total: $totalused/$totalports   ($percent\%)</center>\n";




} elsif ($query->param('summaryreport') ne '') {


  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>$body\n";
  print "<center><h2>InnerCite RADIUS Web Interface</h2>\n";
  print "<br>Summary of all users:<br><br>\n";
  print "<center><table border=1>\n";
  print "<tr><th>UserName</th><th>Hours Used</th></tr>\n";
  my $orderby = 'UserName';
  $orderby = $query->param('orderby') if $query->param('orderby');
  my $direction = $query->param('direction');
  my ($sql, $sumsth, $sum);
  
     if ($query->param('from') ne '' && $query->param('to') ne '') {


        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" and AcctStopTime <= \"".$query->param('to')."\" and AcctStopTime != 0 GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } elsif ($query->param('from') ne '') {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStartTime >= \"".$query->param('from')."\" GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } elsif ($query->param('to') ne '') {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct WHERE AcctStopTime <= \"".$query->param('to')."\" and AcctStopTime != 0 GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";

     } else {

        $sql = "SELECT UserName, SUM(AcctSessionTime) / 3600 as s FROM radacct GROUP BY UserName HAVING s != 0 ORDER BY $orderby $direction";
     }

     $sumsth = $dbh->prepare($sql);
     $sumsth->execute || print "error was ".$dbh->errstr;
     my $i = 0;
     my $totalsum = 0;
     while (my ($user, $sum) = $sumsth->fetchrow_array) {
        $i++;
        print "<tr align=center><td><a href=\"$cgi\?action=detailed\&username=$user\">$user</a></td><td>$sum</td></tr>\n";
        $totalsum += $sum;
     }
  print "</table><br>\n";
  print "Total number of users: $i<br>\n";
  print "Total number of hours: $totalsum<br>\n";


} elsif ($query->param('abusereport') ne '') {



  my $from = $query->param('year').'-'.$query->param('month').'-01 00:00:00';
  my $newmonth = $query->param('month') + 1;
  my $to = $query->param('year').'-'.$newmonth.'-01 00:00:00';
  my $limit = $query->param('hours');
  $sth = $dbh->prepare("SELECT UserName, SUM(AcctSessionTime) AS s FROM radacct WHERE AcctStartTime >= \"$from\" AND AcctStopTime <= \"$to\" GROUP BY UserName ORDER BY s DESC");
  $sth->execute;
  my %ABUSER;
  my %SUSPECT;
  my $hours;
  my $avgdaily;
  my $dailylimit;
  my @susdata;
  while (my @data = $sth->fetchrow_array) {

     $hours = $data[1] / 3600;
     if ($hours > $limit) {
        $ABUSER{$data[0]} = $hours;
     }
     next if $ABUSER{$data[0]};

     $avgdaily = $hours / getdayofmon();
     $dailylimit = $limit / $DAYSPERMON;
     if ($avgdaily > $dailylimit) {
        $SUSPECT{$data[0]} = newarry($avgdaily, $hours);
     }
     
  }
  print "Abusers over $limit hours<br><br>\n";
  print "<table border=1>\n";
  print "<tr><th>UserName</th><th>Hours Used</th></tr>\n";
  my ($printhours, $junk);
  foreach my $user (sort(keys %ABUSER)) {
    ($printhours, $junk) = split(/\./, $ABUSER{$user});
    print "<tr align=center><td>$user</td><td>$printhours</td></tr>\n";
  }
  print "</table>\n";


  print "<br><br>Users projected to go over $limit hours<br><br>\n";
  print "<table border=1>\n";
  print "<tr><th>UserName</th><th>Average Hours<br>Per Day</th><th>Projected Use<br>This Month</th><th>Hours Used<br>So Far</th></tr>\n";
  my ($printhours, $junk);
  my @suspects;
  foreach my $user (sort(keys %SUSPECT)) {
    @suspects = @{$SUSPECT{$user}};
    print "<tr align=center><td>$user</td><td>$suspects[0]</td><td>$suspects[1]</td><td>$suspects[2]</td></tr>\n";
  }
  print "</table>\n";

} elsif ($query->param('action') eq 'login') {

    printheader();
    print "<html>$body\n";
    print "<center><font size=4>Please login to access ICRADIUS</font></center>\n";
    print "<form action=\"$cgi\" method=post>\n";
    print "<center><input type=text name=\"username\">\n";
    print "<br><input type=password name=\"password\">\n";
    print "<br><input type=submit name=\"login\" value=\"Login\">\n";
    print "</form></center>\n";
    print "</body></html>\n";

} elsif ($printmainpage) {


  print "<html><head><title>InnerCite RADIUS Web Interface</title></head>\n";
  print "<FRAMESET cols=\"160,*\" BORDER=\"3\">\n";
  print "<FRAME NAME=\"navframe\" src=\"$cgi?action=navframe\">\n";
  print "<FRAME NAME=\"rightmainframe\" src=\"$cgi?action=rightmainframe\">\n";
  print "</FRAMESET>\n";
  print "</html>\n";


}

sub getdatetime {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);
  my @datemonths = ("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec");

  my $numidx = "01";
  my ($nummon);
  foreach my $mons (@datemonths) {
    if ($mon eq $mons) {
     $nummon = $numidx;
    }
    $numidx++;
  }

  return "$year-$nummon-$dayofmon $time";

}

sub formatseconds {

my $seconds = shift;
my $hours = 0;
my $minutes = 0;
my $ret = '';

while ($seconds >= 3600) {
 $seconds -= 3600;
 $hours += 1;
}

while ($seconds >= 60) {
 $seconds -= 60;
 $minutes += 1;
}
 $ret = "$hours"."h:" if $hours ne 0;

 $ret .= "$minutes"."m:".$seconds."s";
 return $ret;


}


sub error {

  my $error = shift;
  my $arg1 = shift;

   if ($error eq 'not_admin') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>Unauthorized attempt to access ICRADIUS administration.</font>\n";
     print "<br><font face=arial>Please login again if you think this is an error.</font>\n";
     print "<form><input type=button value=\"<<Back\" OnClick=\"history.back()\"></form>\n";
     print "</body></html>\n";
   } elsif ($error eq 'expired') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>Your session has timed out for security reasons.</font>\n";
     print "<br><font face=arial>Please login again <a href=\"$cgi\" target=\"_top\">HERE</a>\n";
     print "</font></body></html>\n";
   } elsif ($error eq 'exists') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>The user you are trying to enter already exists. Please go back and enter a different username</font>\n";
     print "</font></body></html>\n";
   } elsif ($error eq 'ingroup') {
     print "<html><head><title>Error!</title></head>\n";
     print "$body\n";
     print "<center><h1><font face=arial>Error!</font></h1></center>\n";
     print "<font face=arial>This user is already in the group <i>$arg1</i>. Please go back and deselect group <i>$arg1</i> from the list.</font>\n";
     print "<form><input type=button value=\"<<Back\" OnClick=\"history.back()\"></form>\n";
     print "</font></body></html>\n";
   }


   exit;

}


# Returns the day of the month
sub getdayofmon {
  my $today = localtime(time());
  my ($day,$mon,$dayofmon,$time,$year) = split(/\s+/,$today);

  return "$dayofmon";

}

sub newarry {

  my $avg = shift;
  my $used = shift;
  my @stuff;

  ($stuff[0]) = parsefloat($avg, 2);
  ($stuff[1]) = split(/\./, $avg * $DAYSPERMON);
  ($stuff[2]) = split(/\./,$used);

  return \@stuff;

}

# return number plus n decimal places
sub parsefloat {

 my $float = shift;
 my $places = shift;

 my ($printfloat, $junk) = split(/\./, $float);
 
 my $dec = substr($junk, 0, $places);
 $printfloat .= ".$dec";

 return $printfloat;

}

#print a html header if not printed yet
sub printheader {

  if ($printheader) {
     print "Content-Type: text/html\n\n";
     $printheader = 0;
  }

}


#verify user can access administration
sub checksession {

  my $username = $query->cookie(-name=>'username');
  my $password = $query->cookie(-name=>'password');
  if ($username eq '') {
     printheader();
     if ($query->param()) {
        print "<html>$body\n";
        print "<center><font size=4>Your session has expired.</font></center>\n";
        print "<br><br><center>Please login again <a href=\"$cgi\?action=login\" target=\"_top\"> HERE</a></center>\n";
        print "</body></html>\n";
        exit;
     } else {
      
        printlogin();
        exit;
    }
  }

  checkuserpass($username, $password);

  my $cookie1 = $query->cookie(-name=>'username',
				-value=>$username,
				-expires=>'+12h',
				-domain=>$cookiedomain);

  my $cookie2 = $query->cookie(-name=>'password',
				-value=>$password,
				-expires=>'+12h',
				-domain=>$cookiedomain);

  print $query->header(-COOKIE=>[$cookie1, $cookie2]);
  
  $printheader = 0;

  return 0;

}

# checks the username and pass against the database
sub checkuserpass {

  my $username = shift;
  my $password = shift;

  $sth = $dbh->prepare("SELECT id FROM radcheck WHERE UserName = \"$username\" AND Attribute = \"Radius-Operator\"");
  $sth->execute;
  my $check = $sth->fetchrow_array;
  if (!$check) {
    printheader();
    error('not_admin');
  }

  $sth = $dbh->prepare("SELECT id FROM radcheck WHERE UserName = \"$username\" AND Attribute = \"Password\" AND Value = \"$password\"");
  $sth->execute;
  my $check = $sth->fetchrow_array;
  if (!$check) {
    printheader();
    error('not_admin');
  }

  return 0;

}

#printlogin prints a login page
sub printlogin {

        print "<html>$body\n";
        print "<center><font size=4>Please login to access ICRADIUS</font></center>\n";
        print "<form action=\"$cgi\" method=post>\n";
        print "<center><input type=text name=\"username\">\n";
        print "<br><input type=password name=\"password\">\n";
        print "<br><input type=submit name=\"login\" value=\"Login\">\n";
        print "</form></center>\n";
        print "</body></html>\n";
}
