#include "cgi_c_macro.h"
#include "cgi_macro_env.h"
#include "cgi_die.h"
#include "cgi_stream_string.h"
#include "cgi_form.h"
#include "cgi_app.h"

CgiMacroEnv macro_env;
ofstream CgiCMacro::schema_s;


void CgiCMacro::write_c(ofstream& os)
 {
  os << "// CGI++ macro " << str << endl;

  if(str == "MAIN_START")
   {
    write_main_start(os);
   }
  else if(str == "HTTP_COOKIE_AUTH")
   {
    macro_env.http_cookie_auth = 1;
   }
  else if(str == "HTTP_COOKIE_MAKER")
   {
    assert_num_args(1);
    macro_env.http_cookie_maker = param_list[0];
   }
  else if(str == "HTTP_COOKIE_CLASS")
   {
    write_http_cookie_class(os);
   }
  else if(str == "MAIN_END")
   {
    os << " return 0;" << endl;
    os << "}" << endl;
   }
  else if(str == "SQL_DB_DRIVER")
   {
    switch(param_list.size())
     {
      case 0: die("%s macro requres an argument", str.c_str());
      case 1 : macro_env.sql_db_driver = param_list[0]; break;
      default: die("%s macro takes only 1  argument", str.c_str());
     }
    write_sql_driver_include(os);

   }
  else if(str == "SQL_ON_ERROR")
   {
    switch(param_list.size())
     {
      case 0: die("%s macro requres an argument", str.c_str());
      case 1 : macro_env.sql_on_error = param_list[0]; break;
      default: die("%s macro takes only 1  argument", str.c_str());
     }
   }
  else if(str == "MAIL_ON_ERROR")
   {
    switch(param_list.size())
     {
      case 0: die("%s macro requres an argument", str.c_str());
      case 1 : macro_env.mailer_on_error = param_list[0]; break;
      default: die("%s macro takes only 1  argument", str.c_str());
     }
   }
  else if(str == "SQL_DECL_DBH")
   {
    assert_num_args(1);
    write_sql_decl_dbh(os);
   }
  else if(str == "SQL_USE_DBH")
   {
    assert_num_args(1);
    macro_env.sql_dbh = param_list[0]; 
   }
  else if(str == "MAIL_APP")
   {
    assert_num_args(1);
    macro_env.mailer_app = param_list[0]; 
   }
  else if(str == "SQL_CLIENT_APP")
   {
    assert_num_args(1);
    macro_env.sql_client_app = param_list[0]; 
   }
  else if(str == "SQL_SCHEMA_FILE")
   {
    assert_num_args(1);
    macro_env.sql_schema_file = param_list[0]; 
    schema_s.open(macro_env.sql_schema_file.c_str());
    if(!schema_s)
     die("Could not open schema file %s", 
      macro_env.sql_schema_file.c_str());

    schema_s << "#!/bin/sh" << endl;
    schema_s << macro_env.sql_client_app << " <<EOT" << endl;
   }
  else if(str == "SQL_FORM_TO_TABLE")
   {
    write_sql_form_to_table();
   }

  else if(str == "SQL_CONNECT")
   {
    write_sql_connect(os);
    write_sql_check_error(os);
   }
  else if(str == "SQL_DISCONNECT")
   {
    write_sql_disconnect(os);
   }
  else if(str == "SQL_DO")
   {
    write_sql_do(os);
   }
  else if(str == "SQL_CURSOR_DO")
   {
    write_sql_cursor_do(os);
   }
  else if(str == "SQL_CURSOR_DONE")
   {
    write_sql_cursor_done(os);
   }
  else if(str == "MAIL_INIT")
   {
    write_mail_init(os);
   }
  else if(str == "MAIL_CLOSE")
   {
    write_mail_close(os);
   }
  else
   {
    cerr << "Warning: Unrecognized macro " << str << "(";
    unsigned int i;

    for(i = 0; i < param_list.size(); i++)
     cerr << ((i) ? "," : "") <<  param_list[i];
    cerr << ") "  << "has no effect" << endl;
   }

  os << "//CGI++ macro " << str << " end" << endl;
  os << "#line " << line_num  << " \"" << macro_env.source_file << "\"" <<
    endl;
 }
 
 void CgiCMacro::write_sql_driver_include(ofstream& os)
  {
   if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     os << "#include <mysql.h>" << endl;
    }
   else
    die("Unknown db driver %s", macro_env.sql_db_driver.c_str() );
  }

 void CgiCMacro::write_init_arg_buf(ofstream& os ,  int arg_num)
  {
   os << "memset(macro_arg_buf" << arg_num 
    << ", 0,MACRO_ARG_BUF_SIZE);" << endl;
   os << "ostrstream macro_arg_stream" << arg_num << 
    "(macro_arg_buf" << arg_num << ", MACRO_ARG_BUF_SIZE);"  
     << endl;
   os << "active_os = &macro_arg_stream" << arg_num << ";" << endl;

   CgiStreamString s(param_list[arg_num]);
   os << "macro_arg_stream" << arg_num << " << \"" <<
    s << "\";" << endl;
  }
 
 void CgiCMacro::write_http_cookie_class(ofstream& os)
  {
   assert_min_num_args(1);
   string class_name = "Cookie_";
    class_name += param_list[CLASS_NAME];
   os << "class  " << class_name << endl;
   os << " {" << endl;
   os << "  public: " << endl;
   os << "    int parse_status;" << endl;
   os << "    int life_time;" << endl;
   os << "    string domain;" << endl;
   os << "    string path;" << endl;

   unsigned int i;

   for(i = START_ARG; i < param_list.size(); i++)
    {
      os << "   string " << param_list[i] << ";" << endl;
    }
   os << "    " << class_name << "();" << endl;
   os << "      void reset(); " << endl;
   os << "      operator void*() { return (void*)parse_status;}" << endl;
   os << "      friend ostream& operator <<(ostream& os, " <<
    class_name << "& the_cookie);" << endl;
   os << " };" << endl;
   os << class_name << " " << param_list[CLASS_NAME] << ";" << endl;

   os << class_name << "::" << class_name << "() :" << endl;
  
   os << " parse_status(0)," << endl;
   os << " life_time(" << param_list[LIFE_TIME] << ")," << endl;
   os << " domain(\"" << param_list[DOMAIN] << "\")," << endl;
   os << " path(\"" << param_list[PATH] << "\")," << endl;
  
   for(i = START_ARG; i < param_list.size(); i++)
    {
      os << " " << param_list[i] << "(\"\")"  <<
       ((i == param_list.size() - 1) ? "": ",") << endl;
    }

   os << "{" << endl;
   write_http_cookie_constructor(os);
   os << "}" << endl;
 
   os << "void " << class_name << "::reset()" << endl;
   os << "{" << endl;
   write_http_cookie_reset(os);
   os << "}" << endl;
  
   os << " ostream& operator <<(ostream& os, " <<
    class_name << "& the_cookie)" << endl;
   os << "{" << endl;
   write_http_cookie_output(os);
   os << "}" << endl;
  }

 void CgiCMacro::write_http_cookie_constructor(ofstream& os)
  {
   //os << " return;" << endl;
   os << "char* cookie_str = getenv(\"HTTP_COOKIE\");" << endl;
   os << "if(!cookie_str)" << endl;
   os << " return;" << endl; 
   unsigned int i;
   os << "cookie_str = strstr(cookie_str, \"" 
    << param_list[CLASS_NAME] << "\");" << endl;
   os << "if(!cookie_str) return;" << endl;
   
   os << "cookie_str = strchr(cookie_str, '=');" << endl;
   os << "if(!cookie_str) return;" << endl;
   os << "int cookie_len = strlen(cookie_str);" << endl;
   os << "char cookie_buf[cookie_len + 1];" << endl;
   os << "memcpy(cookie_buf, cookie_str, cookie_len + 1); " << endl;
   os << "cookie_str = cookie_buf;" << endl;
   os << "char* cookie_end = strchr(cookie_str, ';');" << endl;
   os << "if(cookie_end)" << endl;
   os << "*cookie_end = 0;" << endl;

   os << " parse_status = 1; " << endl;

   os << "char* tok  = strtok(cookie_str + 1, \"&\");" << endl;
   os << "while(tok)" << endl;
   os << "{" << endl;
   os << " char* in_val = strchr(tok, '=');" << endl;
   os << " if(!in_val) return;" << endl;
   os << " *in_val++ = 0;" << endl;
   os << " char* in_name = tok;" << endl;
   os << endl;
   write_http_cookie_parse_assign(os, param_list[START_ARG]);
   for(i = START_ARG + 1; i < param_list.size(); i++)
   {
     os << "else " << endl;
     write_http_cookie_parse_assign(os, param_list[i]);

   }
 
   os << " tok = strtok(NULL, \"&\"); " << endl;
   os << "}" << endl;
  
  }
 
 void CgiCMacro::write_http_cookie_parse_assign(ofstream& os,
  string& param_name)
  {
  
   os << " if(!strcmp(in_name, \"" << param_name <<
    "\"))" << endl;
   os << "  {" << endl;
   //os << "   " << inputs[i].name << "= in_val;" << endl;
   os << "    int i, c, on_hex = 0, char_code = 0; " << endl;
   os << "    for(i = 0; c = in_val[i]; i++) " << endl;
   os << "      {" << endl;
   os << "       switch(c)" << endl;
   os << "        {" << endl;
   os << "         case '%': on_hex = 2; break;" << endl;
   os << "         case '+': " << param_name << " += ' '; break;"
    << endl;
   os << "         default:  " << endl;
   os << "          if(on_hex) " << endl;
   os << "           {" << endl;
   os << "            int lower_c = tolower(c);" << endl;
   os << "            char_code = (char_code << 4)  + \
    ((lower_c <= '9') ? lower_c - '0' : lower_c - 'a' + 10);" << endl;
   os << "            if(!(--on_hex)) " <<
    param_name << " += char_code; break;" << endl;
   os << "           }" << endl;
   os << "           else " << endl;
   os << "           " << param_name
    << " += c; break;" << endl;

   os << "        }" << endl;
   os << "      }" << endl;
   os << "  }" << endl;
  }

 void CgiCMacro::write_http_cookie_output(ofstream& os)
  {
   unsigned int i;
   os << "os << \"" << param_list[CLASS_NAME] << "=\";" << endl;
   for(i = START_ARG; i < param_list.size() - 1; i++)
   {
    os << "os << \"" << param_list[i] << "=\";";
    os << "write_cgi_encoded(os, the_cookie." 
     << param_list[i] << "); os << \"&\"; " << endl;
   }
  
   os << "os << \"" << param_list[i] << "=\";";
   os << "write_cgi_encoded(os, the_cookie." 
     << param_list[i] << "); os << \";\"; " << endl;
  
   os << "time_t tm;" << endl;
   os << "time(&tm);" << endl;
   os << "tm += the_cookie.life_time;" << endl;
   os << "char* time_str = asctime(gmtime(&tm));" << endl;
   os << "time_str[strlen(time_str) - 1] = 0;" << endl;
   os << "os << \"expires=\" << time_str << \"; \";" << endl;
   os << " if(the_cookie.domain.length())" <<
    "  os << \"domain=\" << the_cookie.domain << \";\"; " << endl;
   os << " if(the_cookie.path.length())" <<
    "  os << \"path=\" << the_cookie.path << \";\"; " << endl;

   os << " return os;" << endl;
  }

 void CgiCMacro::write_http_cookie_reset(ofstream& os)
  {
  }
 
 void CgiCMacro::write_main_start(ofstream& os)
  {
    os << "int main(int c, char** argv)" << endl;
    os << " {" << endl;
    os << "  signal(SIGSEGV, " << macro_env.seg_fault_handler <<
     ");" << endl;

    if(macro_env.http_cookie_maker.length())
     {
      os << "cgipp_in_cookie = 1;" << endl;
      os << " cout << \"Set-Cookie: \";";
      os <<  " " << macro_env.http_cookie_maker <<
        "();" << endl;
      os << "cgipp_in_cookie = 0;" << endl;
      os << " cout << endl;" << endl;
     }

    os << "  cgipp_wearehtml(); "
     << endl;
  
  }

 void CgiCMacro::write_init_arg_bufs(ofstream& os )
  {
   os << "{" << endl;
   unsigned int  i;

   for(i = 0; i < param_list.size(); i++)
    {
     write_init_arg_buf(os, i);
    }

   os << "}" << endl;
  }

 void CgiCMacro::write_sql_connect(ofstream& os)
  {
   if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     assert_num_args(4);
     write_init_arg_bufs(os);
     os << "mysql_connect(&" << macro_env.sql_dbh << 
     ", macro_arg_buf0, macro_arg_buf2, macro_arg_buf3);" << endl;
     write_sql_check_error(os);
     os << "mysql_select_db(&" << macro_env.sql_dbh <<
      ", macro_arg_buf1);" << endl;
    }
   else
    die("%s macro not supported for % sql_db_driver",
      str.c_str(), macro_env.sql_db_driver.c_str());
  }

 void CgiCMacro::write_sql_disconnect(ofstream& os)
  {
   if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     os << "mysql_close(&" << macro_env.sql_dbh << ");" << endl;
    }
   else
    die("%s macro not supported for % sql_db_driver",
      str.c_str(), macro_env.sql_db_driver.c_str());
  }
 void CgiCMacro::write_sql_cursor_do(ofstream& os)
  {
   if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     macro_env.cur_sql_cursor_depth++;
     assert_num_args(1);
     os << "{" << endl;
     write_init_arg_bufs(os);
     os << " mysql_query(&" << macro_env.sql_dbh << 
      ", macro_arg_buf0);" << endl;
     write_sql_check_error(os);
     os << " MYSQL_RES* " << macro_env.sql_cursor_res_var_name;
     macro_env.write_sql_cursor_var_sub(os);
     os << 
      " = mysql_store_result(&" << macro_env.sql_dbh << ");" << endl;
     write_sql_check_error(os);
    os << "while(1) " << endl;
    os << "{" << endl;
    os << " char** " << macro_env.sql_row_var_name; 
    macro_env.write_sql_cursor_var_sub(os);
    
    os << 
     " = mysql_fetch_row(" << macro_env.sql_cursor_res_var_name;
    macro_env.write_sql_cursor_var_sub(os);
  
    os <<
     ");" << endl;
    os << " if(!" << macro_env.sql_row_var_name;
    macro_env.write_sql_cursor_var_sub(os);
    
    os << ") break;"
      << endl;  
    
    }
   else
    die("%s macro not supported for % sql_db_driver",
      str.c_str(), macro_env.sql_db_driver.c_str());
  }
 
 void CgiCMacro::write_sql_form_to_table()
  {
   assert_num_args(1);
   const CgiForm* form =  macro_env.cgi_app->get_form(param_list[0]);
  
   form->write_sql_drop_table(schema_s);
   form->write_sql_create_table(schema_s);
  }

 void CgiCMacro::write_sql_do(ofstream& os)
  {
   if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     assert_num_args(1);
     os << "{" << endl;
     write_init_arg_bufs(os);
     os << " mysql_query(&" << macro_env.sql_dbh << 
      ", macro_arg_buf0);" << endl;
     write_sql_check_error(os);
     os << "}" << endl;
    }
   else
    die("%s macro not supported for % sql_db_driver",
      str.c_str(), macro_env.sql_db_driver.c_str());
  }
 void CgiCMacro::write_sql_cursor_done(ofstream& os)
  {
    if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     os << " }" << endl;
     os << "mysql_free_result(" << macro_env.sql_cursor_res_var_name;
     macro_env.write_sql_cursor_var_sub(os);
      
     os << ");" << endl;
 
     os << "}" << endl;
     if(!macro_env.cur_sql_cursor_depth)
      die("Syntax error: SQL_CURSOR_DONE without matching SQL_CURSOR_DO");

     macro_env.cur_sql_cursor_depth--;
    }
    else
     die("%s macro not supported for %s sql_db_driver",
       str.c_str(), macro_env.sql_db_driver.c_str());
  }
 
 void CgiCMacro::write_sql_decl_dbh(ofstream& os)
   {
    if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     os << "MYSQL "  << param_list[0] << " ;" << endl;
     macro_env.sql_dbh = param_list[0];
    }
    else
     die("%s macro not supported for %s sql_db_driver",
       str.c_str(), macro_env.sql_db_driver.c_str());
   }
 
 void CgiCMacro::write_sql_check_error(ofstream& os)
   {
    if(macro_env.sql_on_error.length() == 0)
     return;
  
    if(!strcasecmp(macro_env.sql_db_driver.c_str(), "mysql"))
    {
     os << "if(mysql_error(&" << macro_env.sql_dbh <<")[0])" <<
      " " << macro_env.sql_on_error << "();" << endl;
    }
    else
     die("%s macro not supported for %s sql_db_driver",
       str.c_str(), macro_env.sql_db_driver.c_str());
   }

 void CgiCMacro::write_mail_init(ofstream& os)
  {
   assert_num_args(4);
   enum {FROM = 0, TO = 1, REPLY_TO = 2, SUBJECT = 3};

   os << "mailer_pipe = popen(\""<< macro_env.mailer_app << 
     "\", \"w\");" << endl;
   if(macro_env.mailer_on_error.length())
    {
     os << "if(!mailer_pipe) " << macro_env.mailer_on_error <<
      "();" << endl;
    }
    os << "mailer_ostream .attach(fileno(mailer_pipe));" << endl;
   if(macro_env.mailer_on_error.length())
    {
     os << "if(!mailer_ostream)" << macro_env.mailer_on_error <<
      "();" << endl;
    }

    CgiStreamString from(param_list[FROM]);
    CgiStreamString to(param_list[TO]);
    CgiStreamString reply_to(param_list[REPLY_TO]);
    CgiStreamString subject(param_list[SUBJECT]);
    os << "mailer_ostream << \"From: \" << " << from << " << endl;" << endl;
    os << "mailer_ostream << \"To: \" << " << to << " << endl;" << endl;
   
    if(reply_to.length())
     os << "mailer_ostream << \"Reply-To: \" << " << reply_to << " << endl;" << endl;
   
    os << "mailer_ostream << \"Subject: \" << " << subject << " << endl << endl;" << endl;
  }

 void CgiCMacro::write_mail_close(ofstream& os)
  {
   if(macro_env.mailer_on_error.length())
    os << "if(pclose(mailer_pipe)) " << macro_env.mailer_on_error << "() ;" << endl;
   else
    os << "pclose(mailer_pipe);" << endl;
    
  }


