%{
 #include <stdio.h>
 #include <stdlib.h>
 #include <string>
 #include "parse.h"
 #include "cgi++.h"
 

 static string cgi_input_val;
 static string str;
 static string q_str;
 static vector <CgiForm> cgi_form_list;
 static CgiInput cgi_input;
 extern CgiMacroEnv macro_env;
 CgiForm cgi_form;
%}

%option yylineno

%x SQL
%x HTML
%x CONFIG
%x FORM_TAG
%x FORM_INPUT
%x FORM_NAME
%x FORM_METHOD
%x FORM
%x INPUT_NAME
%x INPUT_TYPE
%x INPUT_STORAGE
%x INPUT_VALUE
%x MACRO_PARAMS
%x MACRO_PARAMS_FIND_FIRST
%x MACRO_PARAMS_Q_STR
%x MACRO_PARAMS_Q_STR_ESC
%x INPUT_STORAGE_Q_STR
%x INPUT_STORAGE_Q_STR_ESC
%x INPUT_VALUE_Q_STR
%x INPUT_VALUE_Q_STR_ESC
%x OPTION_VALUE_Q_STR
%x OPTION_VALUE_Q_STR_ESC
%x FORM_OPTION
%x OPTION_VALUE

%x MAIL

WHITE	[ \n\t]
LETTER	[a-zA-Z]
IDENT_CHAR [a-zA-Z0-9_]
%%

<INITIAL>"CONFIG_START" { BEGIN CONFIG;  return CONFIG_START; }
<INITIAL>"HTML_START" {BEGIN HTML; 
 str =""; 
 cgi_form_list = vector<CgiForm>();
 return HTML_START; 
 }

<INITIAL>"MAIL_START" {BEGIN MAIL; 
 str =""; 
 return MAIL_START; 
 }

<CONFIG>"CONFIG_END" {BEGIN 0; return CONFIG_END;}
<HTML>"<form"|"<FORM" { 
   BEGIN FORM_TAG;
   cgi_form = CgiForm(); 
   str += yytext;  
   }
<FORM_TAG>"name="|"NAME=" {str += yytext; 
 BEGIN FORM_NAME;}

<FORM_TAG>"method="|"METHOD=" {
 str += yytext; 
 BEGIN FORM_METHOD;
 }

<FORM_NAME>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_form.name = yytext;
 BEGIN FORM_TAG; }
<FORM_NAME,FORM_METHOD,FORM_TAG,INPUT_NAME,INPUT_TYPE>\" {
 str += yytext; 
}

<FORM_METHOD>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_form.set_method(yytext);
 BEGIN FORM_TAG; }

<FORM_TAG>">" {str += yytext; BEGIN FORM;}

<FORM>"<textarea"|"<TEXTAREA"  {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.type = "textarea";
  str += yytext;
 }

<FORM>"<select"|"<SELECT"  {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.type = "select";
  str += yytext;
 }

<FORM>"<input"|"<INPUT" {
  BEGIN FORM_INPUT;
  cgi_input = CgiInput();
  cgi_input.type = "text";
  str += yytext;
 }


<FORM_INPUT>">" {
 str += yytext; 
 if(cgi_input.name.length())
  cgi_form.add_input(cgi_input, cgi_input_val.c_str());
 BEGIN FORM;
 }

<FORM>"<option"|"<OPTION" {
  BEGIN FORM_OPTION;
  cgi_input_val = "";
  // here we are re-using the last value of cgi_input
  str += yytext;
 }


<FORM_OPTION>">" {
 str += yytext; 
 //cerr << "CgiInput name = " << cgi_input.name 
 // << " val = " << cgi_input_val << endl;
 if(cgi_input.name.length())
  cgi_form.add_input(cgi_input, cgi_input_val.c_str());
 BEGIN FORM;
 }

<FORM_INPUT>"name="|"NAME="  {
  BEGIN INPUT_NAME;
  str += yytext;
  cgi_input_val = "";
 }

<FORM_INPUT>"type="|"TYPE="  {
  BEGIN INPUT_TYPE;
  str += yytext;
 }

<FORM_INPUT>"storage="|"STORAGE="  {
  BEGIN INPUT_STORAGE;
 }

<INPUT_STORAGE>\" {
 q_str = "";
 BEGIN INPUT_STORAGE_Q_STR;
}
<INPUT_STORAGE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<INPUT_STORAGE_Q_STR>\\ {
 BEGIN INPUT_STORAGE_Q_STR_ESC;
}
<INPUT_STORAGE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN INPUT_STORAGE_Q_STR;
}

<INPUT_STORAGE_Q_STR>\" {
 cgi_input.storage = q_str;
 BEGIN FORM_INPUT;
}

 

<FORM_INPUT>"value="|"VALUE="  {
  str += yytext;
  BEGIN INPUT_VALUE;
 }
<INPUT_VALUE>\" {
 q_str = "";
 BEGIN INPUT_VALUE_Q_STR;
}
<INPUT_VALUE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<INPUT_VALUE_Q_STR>\\ {
 BEGIN INPUT_VALUE_Q_STR_ESC;
}
<INPUT_VALUE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN INPUT_VALUE_Q_STR;
}

<INPUT_VALUE_Q_STR>\" {
 cgi_input_val = q_str;
 str += "\"" + q_str + "\"";
 BEGIN FORM_INPUT;
}
<INPUT_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_INPUT;
  }

<FORM_OPTION>"value="|"VALUE="  {
  str += yytext;
  BEGIN OPTION_VALUE;
 }

<OPTION_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_OPTION;
  }

<OPTION_VALUE>\" {
 q_str = "";
 BEGIN OPTION_VALUE_Q_STR;
}
<OPTION_VALUE_Q_STR>[^\\\"] {
 q_str += yytext;
}
<OPTION_VALUE_Q_STR>\\ {
 BEGIN OPTION_VALUE_Q_STR_ESC;
}
<OPTION_VALUE_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN OPTION_VALUE_Q_STR;
}

<OPTION_VALUE_Q_STR>\" {
 cgi_input_val = q_str;
 str += "\"" + q_str + "\"";
 BEGIN FORM_OPTION;
}

  

<INPUT_NAME>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input.name = yytext;
 BEGIN FORM_INPUT; }
<INPUT_TYPE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input.type = yytext;
 BEGIN FORM_INPUT;
  }

<OPTION_VALUE>{IDENT_CHAR}+ { 
 str += yytext; 
 //printf("%s\n", yytext);
 cgi_input_val = yytext;
 BEGIN FORM_INPUT;
  }

<FORM>"</form"|"</FORM" { BEGIN HTML;
   str += yytext;  
   if(cgi_form.name.length())
    cgi_form_list.insert(cgi_form_list.end(), cgi_form);
   }

<HTML,FORM_TAG,FORM_INPUT,FORM>"HTML_END" {BEGIN 0; yylval.cgi_form_list = &cgi_form_list;
 return HTML_END;}
<MAIL>"MAIL_END" {BEGIN 0; 
 return MAIL_END;}

<HTML,FORM_TAG,FORM_INPUT,FORM_OPTION,FORM,INITIAL,MAIL>. { str += yytext;  }

<HTML,FORM_TAG,FORM_INPUT,FORM_OPTION,FORM,INITIAL,MAIL>\n { yylval.str = &str; return STRING;}

<INITIAL>HTTP_COOKIE_AUTH|MAIL_CLOSE |
<INITIAL>MAIN_START|MAIN_END|SQL_DISCONNECT|SQL_CURSOR_DONE {
  str = yytext; 

  yylval.cgi_c_macro = new CgiCMacro(str); 
  yylval.cgi_c_macro->set_line_num (yylineno);
  str = "";
  return MACRO;
 }

<INITIAL>MAIL_INIT|MAIL_ON_ERROR|MAIL_APP |
<INITIAL>SQL_CLIENT_APP|SQL_SCHEMA_FILE|SQL_FORM_TO_TABLE |
<INITIAL>SQL_CURSOR_DO|SQL_DECL_DBH|SQL_USE_DBH|HTTP_COOKIE_MAKER |
<INITIAL>HTTP_COOKIE_CLASS |

<INITIAL>SQL_DB_DRIVER|SQL_ON_ERROR|SQL_CONNECT|SQL_DO  {// cerr << "Found macro" << endl;
  str = yytext; 
  if(str == "MAIL_INIT")
   {
    macro_env.has_mailer = 1;
   }
  yylval.cgi_c_macro = new CgiCMacro(str); 
  yylval.cgi_c_macro->set_line_num (yylineno);
  str = "";
  BEGIN MACRO_PARAMS_FIND_FIRST;
}

<MACRO_PARAMS_FIND_FIRST>\( {
// cerr << "looking for (" << " matched '" <<
 // yytext << "'" << endl;
 BEGIN MACRO_PARAMS;
}
<MACRO_PARAMS>\" {
 q_str = "";
 BEGIN MACRO_PARAMS_Q_STR;
}
<MACRO_PARAMS_Q_STR>[^\\\"] {
 q_str += yytext;
}
<MACRO_PARAMS_Q_STR>\\ {
 BEGIN MACRO_PARAMS_Q_STR_ESC;
}
<MACRO_PARAMS_Q_STR_ESC>. {
 q_str += yytext;
 BEGIN MACRO_PARAMS_Q_STR;
}

<MACRO_PARAMS_Q_STR>\" {
 yylval.cgi_c_macro->add_param(q_str.c_str());
 BEGIN MACRO_PARAMS;
}

<MACRO_PARAMS>{IDENT_CHAR}+ {
 yylval.cgi_c_macro->add_param(yytext);
}
<MACRO_PARAMS>\) {
  BEGIN INITIAL;
  return MACRO;
}

<MACRO_PARAMS>\n {}


  /* <INITIAL>[^\n]+ { str = yytext; yylval.str = &str; return STRING; } */
\n 	{}
<*>.	{}

%%

int yywrap(void) 
 {
    return 1;
 }


