#include "cgi_html_input.h"
#include "cgi_stream_string.h"
#include "cgi_die.h"

CgiHtmlInput::CgiHtmlInput(const char* init_str, 
  const CgiInput& init_cgi_input)
 {
  str = init_str;
  cgi_input = init_cgi_input;
 }

CgiHtmlInput::~CgiHtmlInput()
 {
 }

void CgiHtmlInput::write_c(ofstream& os)
 {
  CgiStreamString s(str);

  if(s.length() == 0)
   return;

  if(cgi_input.type == "date")
   {
    if(cgi_input.form_name.length() == 0)
     die("When using CGI++ extended input types you must define the form name ");

    os <<  cgi_input.form_name << "." 
     << cgi_input.name << ".write_html_input(cout);" << endl;
     
   }
  else if(cgi_input.type == "sql-fill-options")
   {
    string query = cgi_input.param_hash["query"];
    if(query.length() == 0)
     die("You cannot have an empty query in sql-fill-options tag");

   }
  else if(cgi_input.type == "pragma")
   {
    // do nothing, it is just a pragme
   }
  else if(cgi_input.type == "auto_id")
   {
    os << "if(!" << cgi_input.form_name << "." << 
     cgi_input.name << ".length()) " 
     << cgi_input.form_name << "." << 
     cgi_input.name << " = \"NULL\";" << endl;
    
    os << "cout << \"";
    os << "<input type=hidden name=" << cgi_input.name << 
     " value=\"" << "<<" << cgi_input.form_name << "." << 
     cgi_input.name << " << \">";
    os << "\" << endl ;" << endl;
   }
  
  else if(cgi_input.type == "checkbox")
   {
    os << "cout << \"";
    string tmp_str; 
    tmp_str = tmp_str + "<input type=" + cgi_input.type + " name=" + cgi_input.name + 
     " $((" + cgi_input.form_name + "." + 
     cgi_input.name + " == \"Y\") ? \"checked\":\"\" )$";
   
    map<string, string, less<string> >::iterator i = cgi_input.param_hash.begin();
    while(i != cgi_input.param_hash.end())
     {
       if(strcasecmp((*i).first.c_str(), "value"))
         tmp_str = tmp_str + " " + (*i).first + "=\"" +
           (*i).second + "\"";
       i++;
     }
    CgiStreamString ss(tmp_str);
    os << ss;

    os << ">";
    os << "\" << endl ;" << endl;
   }
  else if(cgi_input.type == "text" || cgi_input.type == "password")
   {
    os << "cout << \"";
    string tmp_str; 
    tmp_str = tmp_str + "<input type=" + cgi_input.type + " name=" + cgi_input.name + 
     " value=\"$" + cgi_input.form_name + "." + 
     cgi_input.name + "$\"";
   
    map<string, string, less<string> >::iterator i = cgi_input.param_hash.begin();
    while(i != cgi_input.param_hash.end())
     {
       if(strcasecmp((*i).first.c_str(), "value"))
         tmp_str = tmp_str + " " + (*i).first + "=\"" +
           (*i).second + "\"";
       i++;
     }
    CgiStreamString ss(tmp_str);
    os << ss;

    os << ">";
    os << "\" << endl ;" << endl;
   }
   
  else
   { 
    os << "cout << \"";
    os << s;
    os << "\" << endl ;" << endl;
   }

 }
