#ifndef CGI_C_MACRO_H
#define CGI_C_MACRO_H

#include <fstream.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <string>
#include <vector>

#include "cgi_c_line.h"
#include "cgi_die.h"

class CgiCMacro : public CgiCLine
 {
  protected:
   vector <string> param_list;
   enum {CLASS_NAME = 0, LIFE_TIME = 1,
    DOMAIN = 2, PATH=3, START_ARG = 4};
   int line_num;


  public:
   static ofstream schema_s;

   CgiCMacro(const string& init_str) : CgiCLine(init_str)
    {
    }
 
   CgiCMacro() : CgiCLine("")
    {
    }

   ~CgiCMacro() {}
  void write_c(ofstream& os);
  void write_sql_connect(ofstream& os);
  void write_sql_disconnect(ofstream& os);
  void write_sql_cursor_do(ofstream& os);
  void write_sql_do(ofstream& os);
  void write_sql_cursor_done(ofstream& os);
  void write_sql(ofstream& os);
  void write_sql_decl_dbh(ofstream& os);
  void write_sql_check_error(ofstream& os);
  void write_sql_driver_include(ofstream& os);
  void write_sql_form_db_write(ofstream& os);
  void write_sql_form_to_table();
  void write_sql_table_export(ofstream& os);
  void write_sql_form_db_read(ofstream& os);
 

  void write_main_start(ofstream& os);
  void write_http_cookie_class(ofstream& os);
  void write_http_cookie_constructor(ofstream& os);
  void write_http_cookie_output(ofstream& os);
  void write_http_cookie_reset(ofstream& os);
  void write_http_cookie_parse_assign(ofstream& os, string& param_name);
  void write_mail_init(ofstream& os);
  void write_mail_close(ofstream& os);

  void write_init_arg_buf(ofstream& os ,  int arg_num);
  void write_init_arg_bufs(ofstream& os);

  void assert_num_args(unsigned int n)
   {
    if(param_list.size() != n)
     die("%s macro requires %d  arguments, you have %d", str.c_str(), 
      n, param_list.size());
   }
  
  void assert_min_num_args(unsigned int n)
   {
    if(param_list.size() < n)
     die("%s macro requires at least %d  arguments", str.c_str(), n);
   }

  void add_param(const char* param)
   {
    string s(param);
    param_list.insert(param_list.end(), s);
   }

  void set_line_num(int init_line_num) { line_num = init_line_num;}
 };

#endif
