/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.NullPrintWriter;
import com.mysql.management.util.Platform;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;

public class PlatformTest
extends TestCase {
    private static final String EOL = System.getProperty("line.separator");

    public void testGetKeys() {
        Platform platform = new Platform(new NullPrintWriter());
        List keys = platform.platformProps();
        PlatformTest.assertTrue((boolean)keys.contains("os.name"));
        PlatformTest.assertTrue((boolean)keys.contains("os.arch"));
    }

    public void testReport() {
        System.setProperty("foo", "bar");
        System.setProperty("baz", "wiz");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Platform platform = new Platform(new PrintWriter(baos));
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add("baz");
        platform.report(list);
        String expected = "foo=bar" + EOL + "baz=wiz" + EOL;
        PlatformTest.assertEquals((String)expected, (String)new String(baos.toByteArray()));
    }

    public void testPrintAllProperties() {
        StringWriter out = new StringWriter();
        Platform platform = new Platform(new PrintWriter(out));
        Set<Object> keys = System.getProperties().keySet();
        platform.report(keys);
    }

    public void testPlatformMain() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        System.setOut(new PrintStream(baos));
        ArrayList<String> propKeys = new ArrayList<String>();
        propKeys.add("java.vm.vendor");
        propKeys.add("java.vm.version");
        propKeys.add("os.name");
        propKeys.add("os.arch");
        propKeys.add("os.version");
        LinkedHashMap<String, String> pairs = new LinkedHashMap<String, String>();
        for (int i = 0; i < propKeys.size(); ++i) {
            String propertyKey = (String)propKeys.get(i);
            pairs.put(propertyKey, System.getProperty(propertyKey));
        }
        Platform.main(new String[0]);
        String output = new String(baos.toByteArray());
        Iterator it = pairs.entrySet().iterator();
        while (it.hasNext()) {
            String propEqVal = it.next().toString();
            PlatformTest.assertTrue((output.indexOf(propEqVal) >= 0 ? 1 : 0) != 0);
        }
    }
}

