/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.management.util;

import com.mysql.management.util.DefaultsMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

public class DefaultsMapTest
extends TestCase {
    DefaultsMap map;

    protected void setUp() {
        this.map = new DefaultsMap();
        this.map.put("foo", "bar");
        this.map.put("stay", "unchanged");
        this.map.put("foo", "baz");
    }

    public void testGetChanged() throws Exception {
        DefaultsMapTest.assertEquals((int)1, (int)this.map.getChanged().size());
        DefaultsMapTest.assertEquals((Object)"baz", this.map.getChanged().get("foo"));
        this.map.put("foo", "bar");
        DefaultsMapTest.assertFalse((boolean)this.map.getChanged().containsKey("foo"));
    }

    public void testContainsValue() throws Exception {
        DefaultsMapTest.assertTrue((boolean)this.map.containsValue("baz"));
        DefaultsMapTest.assertFalse((boolean)this.map.containsValue("bar"));
        DefaultsMapTest.assertFalse((boolean)this.map.containsValue(null));
        this.map.put("null", (Object)null);
        DefaultsMapTest.assertTrue((boolean)this.map.containsValue(null));
    }

    public void testGetAndGetDefault() throws Exception {
        DefaultsMapTest.assertEquals((Object)"bar", (Object)this.map.getDefault("foo"));
        DefaultsMapTest.assertEquals((Object)"baz", (Object)this.map.get("foo"));
        DefaultsMapTest.assertEquals((Object)"unchanged", (Object)this.map.get("stay"));
    }

    public void testContainsKey() throws Exception {
        DefaultsMapTest.assertTrue((boolean)this.map.containsKey("foo"));
        DefaultsMapTest.assertFalse((boolean)this.map.containsKey("bogus"));
    }

    public void testClearAndIsEmpty() {
        DefaultsMapTest.assertFalse((boolean)this.map.isEmpty());
        this.map.clear();
        DefaultsMapTest.assertTrue((boolean)this.map.isEmpty());
        DefaultsMapTest.assertEquals((int)0, (int)this.map.getChanged().size());
        DefaultsMapTest.assertEquals((int)0, (int)this.map.size());
    }

    public void testEntrySet() throws Exception {
        Set entrySet = this.map.entrySet();
        DefaultsMapTest.assertEquals((int)2, (int)entrySet.size());
        ArrayList entries = new ArrayList(entrySet);
        Map.Entry one = (Map.Entry)entries.get(0);
        DefaultsMapTest.assertEquals((Object)"foo", one.getKey());
        DefaultsMapTest.assertEquals((Object)"baz", one.getValue());
        Map.Entry two = (Map.Entry)entries.get(1);
        DefaultsMapTest.assertEquals((Object)"stay", two.getKey());
        DefaultsMapTest.assertEquals((Object)"unchanged", two.getValue());
    }

    public void testPutAll() {
        HashMap<String, String> other = new HashMap<String, String>();
        other.put("foo", "wiz");
        other.put("new", "val");
        this.map.putAll(other);
        DefaultsMapTest.assertEquals((Object)"wiz", (Object)this.map.get("foo"));
        DefaultsMapTest.assertEquals((Object)"val", (Object)this.map.get("new"));
    }

    public void testRemove() {
        DefaultsMapTest.assertEquals((int)1, (int)this.map.getChanged().size());
        this.map.remove("foo");
        DefaultsMapTest.assertEquals((int)0, (int)this.map.getChanged().size());
        DefaultsMapTest.assertFalse((boolean)this.map.containsKey("foo"));
        this.map.put("foo", "two");
        DefaultsMapTest.assertEquals((int)0, (int)this.map.getChanged().size());
        this.map.remove("foo");
        DefaultsMapTest.assertFalse((boolean)this.map.containsKey("foo"));
    }

    public void testValues() {
        Collection values = this.map.values();
        DefaultsMapTest.assertEquals((int)2, (int)values.size());
        DefaultsMapTest.assertTrue((boolean)this.map.containsValue("baz"));
        DefaultsMapTest.assertTrue((boolean)this.map.containsValue("unchanged"));
    }

    public void testPutUnchangedOriginal() {
        DefaultsMapTest.assertEquals((int)1, (int)this.map.getChanged().size());
        this.map.put("stay", "unchanged");
        DefaultsMapTest.assertEquals((int)1, (int)this.map.getChanged().size());
    }
}

