/*
 * Decompiled with CFR 0.152.
 */
import com.mysql.management.util.QueryUtil;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TestDb {
    private String driver;
    private String url;
    private String user;
    private String password;

    public TestDb(String driver, String url, String user, String password) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public Connection connection() {
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            return DriverManager.getConnection(this.url, this.user, this.password);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void printResults(String query, PrintStream out, boolean printMetaData) {
        this.executeSql(query, out, false, printMetaData);
    }

    public void printUpdateResults(String query, PrintStream out, boolean printMetaData) {
        this.executeSql(query, out, true, printMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeSql(String query, PrintStream out, boolean update, boolean printMetaData) {
        this.display(query, out);
        Connection conn = this.connection();
        try {
            if (update) {
                out.println(new QueryUtil(conn).executeUpdate(query));
            } else {
                List results = new QueryUtil(conn).executeQuery(query);
                this.printResults(out, results, printMetaData);
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void printResults(PrintStream out, List results, boolean printMetaData) {
        Iterator it = results.iterator();
        while (it.hasNext()) {
            Map row = (Map)it.next();
            Iterator it2 = row.entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry entry = it2.next();
                if (printMetaData) {
                    out.print(entry.getKey() + ": ");
                }
                out.println(entry.getValue());
            }
            if (!it.hasNext()) continue;
            out.println();
        }
    }

    private void display(String query, PrintStream out) {
        out.println("driver: " + this.driver);
        out.println("url: " + this.url);
        out.println("user: " + this.user);
        out.println("password: " + this.password);
        out.println("query: " + query);
        out.println();
    }

    public static void main(String[] args) throws Exception {
        String driver = args.length > 0 ? args[0] : "com.mysql.jdbc.Driver";
        String url = args.length > 1 ? args[1] : "jdbc:mysql:///test";
        String user = args.length > 2 ? args[2] : "root";
        String password = args.length > 3 ? args[3] : "";
        String query = args.length > 4 ? args[4] : "SELECT VERSION()";
        boolean printMetaData = args.length > 5 ? Boolean.valueOf(args[5]) : false;
        TestDb testDb = new TestDb(driver, url, user, password);
        testDb.printResults(query, System.out, printMetaData);
    }
}

