/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.NotImplemented;
import com.mysql.jdbc.ResultSet;
import com.mysql.jdbc.SQLError;
import com.mysql.jdbc.trace.Tracer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class BlobFromLocator
implements Blob {
    private List primaryKeyColumns = null;
    private List primaryKeyValues = null;
    private ResultSet creatorResultSet;
    private String blobColumnName = null;
    private String tableName = null;
    private int numColsInResultSet = 0;
    private int numPrimaryKeys = 0;
    private String quotedId;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;
    private static final JoinPoint.StaticPart ajc$tjp_6;
    private static final JoinPoint.StaticPart ajc$tjp_7;
    private static final JoinPoint.StaticPart ajc$tjp_8;
    private static final JoinPoint.StaticPart ajc$tjp_9;
    private static final JoinPoint.StaticPart ajc$tjp_10;
    private static final JoinPoint.StaticPart ajc$tjp_11;

    BlobFromLocator(ResultSet creatorResultSetToSet, int blobColumnIndex) throws SQLException {
        this.creatorResultSet = creatorResultSetToSet;
        this.numColsInResultSet = this.creatorResultSet.fields.length;
        this.quotedId = this.creatorResultSet.connection.getMetaData().getIdentifierQuoteString();
        if (this.numColsInResultSet > 1) {
            this.primaryKeyColumns = new ArrayList();
            this.primaryKeyValues = new ArrayList();
            int i = 0;
            while (i < this.numColsInResultSet) {
                if (this.creatorResultSet.fields[i].isPrimaryKey()) {
                    StringBuffer keyName = new StringBuffer();
                    keyName.append(this.quotedId);
                    String originalColumnName = this.creatorResultSet.fields[i].getOriginalName();
                    if (originalColumnName != null && originalColumnName.length() > 0) {
                        keyName.append(originalColumnName);
                    } else {
                        keyName.append(this.creatorResultSet.fields[i].getName());
                    }
                    keyName.append(this.quotedId);
                    this.primaryKeyColumns.add(keyName.toString());
                    this.primaryKeyValues.add(this.creatorResultSet.getString(i + 1));
                }
                ++i;
            }
        } else {
            this.notEnoughInformationInQuery();
        }
        this.numPrimaryKeys = this.primaryKeyColumns.size();
        if (this.numPrimaryKeys == 0) {
            this.notEnoughInformationInQuery();
        }
        if (this.creatorResultSet.fields[0].getOriginalTableName() != null) {
            StringBuffer tableNameBuffer = new StringBuffer();
            String databaseName = this.creatorResultSet.fields[0].getDatabaseName();
            if (databaseName != null && databaseName.length() > 0) {
                tableNameBuffer.append(this.quotedId);
                tableNameBuffer.append(databaseName);
                tableNameBuffer.append(this.quotedId);
                tableNameBuffer.append('.');
            }
            tableNameBuffer.append(this.quotedId);
            tableNameBuffer.append(this.creatorResultSet.fields[0].getOriginalTableName());
            tableNameBuffer.append(this.quotedId);
            this.tableName = tableNameBuffer.toString();
        } else {
            StringBuffer tableNameBuffer = new StringBuffer();
            tableNameBuffer.append(this.quotedId);
            tableNameBuffer.append(this.creatorResultSet.fields[0].getTableName());
            tableNameBuffer.append(this.quotedId);
            this.tableName = tableNameBuffer.toString();
        }
        this.blobColumnName = String.valueOf(this.quotedId) + this.creatorResultSet.getString(blobColumnIndex) + this.quotedId;
    }

    private void notEnoughInformationInQuery() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw SQLError.createSQLException("Emulated BLOB locators must come from a ResultSet with only one table selected, and all primary keys selected", "S1000");
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        throw new NotImplemented();
    }

    public InputStream getBinaryStream() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new LocatorInputStream(), this.creatorResultSet.connection.getLocatorFetchBufferSize());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(bufferedInputStream, joinPoint);
        return bufferedInputStream;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        JoinPoint joinPoint;
        block11: {
            void writeAt;
            void bytes;
            int length;
            void offset;
            long l2 = l;
            byte[] byArray2 = byArray;
            int n3 = n;
            int n4 = n2;
            Object[] objectArray = new Object[]{Conversions.longObject((long)l2), byArray2, Conversions.intObject((int)n3), Conversions.intObject((int)n4)};
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            PreparedStatement pStmt = null;
            if (offset + length > ((void)bytes).length) {
                length = ((void)bytes).length - offset;
            }
            byte[] bytesToWrite = new byte[length];
            System.arraycopy(bytes, (int)offset, bytesToWrite, 0, length);
            StringBuffer query = new StringBuffer("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append(this.blobColumnName);
            query.append(" = INSERT(");
            query.append(this.blobColumnName);
            query.append(", ");
            query.append((long)writeAt);
            query.append(", ");
            query.append(length);
            query.append(", ?) WHERE ");
            query.append((String)this.primaryKeyColumns.get(0));
            query.append(" = ?");
            int i = 1;
            while (i < this.numPrimaryKeys) {
                query.append(" AND ");
                query.append((String)this.primaryKeyColumns.get(i));
                query.append(" = ?");
                ++i;
            }
            try {
                pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                pStmt.setBytes(1, bytesToWrite);
                i = 0;
                while (i < this.numPrimaryKeys) {
                    pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                    ++i;
                }
                int rowsUpdated = pStmt.executeUpdate();
                if (rowsUpdated != 1) {
                    throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000");
                }
                Object var10_17 = null;
                if (pStmt == null) break block11;
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            pStmt.close();
            pStmt = null;
        }
        int n5 = (int)this.length();
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n5), joinPoint);
        return n5;
    }

    /*
     * WARNING - void declaration
     */
    public int setBytes(long l, byte[] byArray) throws SQLException {
        void bytes;
        void writeAt;
        long l2 = l;
        byte[] byArray2 = byArray;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)byArray2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int n = this.setBytes((long)writeAt, (byte[])bytes, 0, ((void)bytes).length);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n), joinPoint);
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getBytes(long l, int n) throws SQLException {
        byte[] byArray;
        JoinPoint joinPoint;
        block6: {
            long l2 = l;
            int n2 = n;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2), (Object)Conversions.intObject((int)n2));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            PreparedStatement pStmt = null;
            try {
                void length;
                void pos;
                pStmt = this.createGetBytesStatement();
                byArray = this.getBytesInternal(pStmt, (long)pos, (int)length);
                Object var5_8 = null;
                if (pStmt == null) break block6;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                throw throwable;
            }
            try {
                pStmt.close();
            }
            catch (SQLException sQLException) {}
            pStmt = null;
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    public long length() throws SQLException {
        long l;
        JoinPoint joinPoint;
        block18: {
            block14: {
                PreparedStatement pStmt;
                block15: {
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
                    Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                    java.sql.ResultSet blobRs = null;
                    pStmt = null;
                    StringBuffer query = new StringBuffer("SELECT LENGTH(");
                    query.append(this.blobColumnName);
                    query.append(") FROM ");
                    query.append(this.tableName);
                    query.append(" WHERE ");
                    query.append((String)this.primaryKeyColumns.get(0));
                    query.append(" = ?");
                    int i = 1;
                    while (i < this.numPrimaryKeys) {
                        query.append(" AND ");
                        query.append((String)this.primaryKeyColumns.get(i));
                        query.append(" = ?");
                        ++i;
                    }
                    try {
                        pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                        i = 0;
                        while (i < this.numPrimaryKeys) {
                            pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                            ++i;
                        }
                        blobRs = pStmt.executeQuery();
                        if (!blobRs.next()) break block14;
                        l = blobRs.getLong(1);
                        Object var5_7 = null;
                        if (blobRs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (blobRs != null) {
                            try {
                                blobRs.close();
                            }
                            catch (SQLException sQLException) {}
                            blobRs = null;
                        }
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (SQLException sQLException) {}
                            pStmt = null;
                        }
                        throw throwable;
                    }
                    try {
                        blobRs.close();
                    }
                    catch (SQLException sQLException) {}
                    blobRs = null;
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                break block18;
            }
            throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000");
        }
        long l2 = l;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l2), joinPoint);
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    public long position(Blob blob, long l) throws SQLException {
        void start;
        void pattern;
        Blob blob2 = blob;
        long l2 = l;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)blob2, (Object)Conversions.longObject((long)l2));
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        long l3 = this.position(pattern.getBytes(0L, (int)pattern.length()), (long)start);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l3), joinPoint);
        return l3;
    }

    /*
     * WARNING - void declaration
     */
    public long position(byte[] byArray, long l) throws SQLException {
        long l2;
        JoinPoint joinPoint;
        block18: {
            block14: {
                PreparedStatement pStmt;
                block15: {
                    void start;
                    byte[] byArray2 = byArray;
                    long l3 = l;
                    joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)byArray2, (Object)Conversions.longObject((long)l3));
                    Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                    java.sql.ResultSet blobRs = null;
                    pStmt = null;
                    StringBuffer query = new StringBuffer("SELECT LOCATE(");
                    query.append("?, ");
                    query.append(this.blobColumnName);
                    query.append(", ");
                    query.append((long)start);
                    query.append(") FROM ");
                    query.append(this.tableName);
                    query.append(" WHERE ");
                    query.append((String)this.primaryKeyColumns.get(0));
                    query.append(" = ?");
                    int i = 1;
                    while (i < this.numPrimaryKeys) {
                        query.append(" AND ");
                        query.append((String)this.primaryKeyColumns.get(i));
                        query.append(" = ?");
                        ++i;
                    }
                    try {
                        void pattern;
                        pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                        pStmt.setBytes(1, (byte[])pattern);
                        i = 0;
                        while (i < this.numPrimaryKeys) {
                            pStmt.setString(i + 2, (String)this.primaryKeyValues.get(i));
                            ++i;
                        }
                        blobRs = pStmt.executeQuery();
                        if (!blobRs.next()) break block14;
                        l2 = blobRs.getLong(1);
                        Object var8_11 = null;
                        if (blobRs == null) break block15;
                    }
                    catch (Throwable throwable) {
                        Object var8_12 = null;
                        if (blobRs != null) {
                            try {
                                blobRs.close();
                            }
                            catch (SQLException sQLException) {}
                            blobRs = null;
                        }
                        if (pStmt != null) {
                            try {
                                pStmt.close();
                            }
                            catch (SQLException sQLException) {}
                            pStmt = null;
                        }
                        throw throwable;
                    }
                    try {
                        blobRs.close();
                    }
                    catch (SQLException sQLException) {}
                    blobRs = null;
                }
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                break block18;
            }
            throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000");
        }
        long l4 = l2;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.longObject((long)l4), joinPoint);
        return l4;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void truncate(long l) throws SQLException {
        JoinPoint joinPoint;
        block10: {
            void length;
            long l2 = l;
            joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)Conversions.longObject((long)l2));
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            PreparedStatement pStmt = null;
            StringBuffer query = new StringBuffer("UPDATE ");
            query.append(this.tableName);
            query.append(" SET ");
            query.append(this.blobColumnName);
            query.append(" = LEFT(");
            query.append(this.blobColumnName);
            query.append(", ");
            query.append((long)length);
            query.append(") WHERE ");
            query.append((String)this.primaryKeyColumns.get(0));
            query.append(" = ?");
            int i = 1;
            while (i < this.numPrimaryKeys) {
                query.append(" AND ");
                query.append((String)this.primaryKeyColumns.get(i));
                query.append(" = ?");
                ++i;
            }
            try {
                pStmt = this.creatorResultSet.connection.prepareStatement(query.toString());
                i = 0;
                while (i < this.numPrimaryKeys) {
                    pStmt.setString(i + 1, (String)this.primaryKeyValues.get(i));
                    ++i;
                }
                int rowsUpdated = pStmt.executeUpdate();
                if (rowsUpdated != 1) {
                    throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000");
                }
                Object var6_9 = null;
                if (pStmt == null) break block10;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (pStmt != null) {
                    try {
                        pStmt.close();
                    }
                    catch (SQLException sQLException) {}
                    pStmt = null;
                }
                throw throwable;
            }
            try {}
            catch (SQLException sQLException) {}
            pStmt.close();
            pStmt = null;
        }
        Object var11_10 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var11_10, joinPoint);
    }

    PreparedStatement createGetBytesStatement() throws SQLException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        StringBuffer query = new StringBuffer("SELECT SUBSTRING(");
        query.append(this.blobColumnName);
        query.append(", ");
        query.append("?");
        query.append(", ");
        query.append("?");
        query.append(") FROM ");
        query.append(this.tableName);
        query.append(" WHERE ");
        query.append((String)this.primaryKeyColumns.get(0));
        query.append(" = ?");
        int i = 1;
        while (i < this.numPrimaryKeys) {
            query.append(" AND ");
            query.append((String)this.primaryKeyColumns.get(i));
            query.append(" = ?");
            ++i;
        }
        PreparedStatement preparedStatement = this.creatorResultSet.connection.prepareStatement(query.toString());
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(preparedStatement, joinPoint);
        return preparedStatement;
    }

    /*
     * WARNING - void declaration
     */
    byte[] getBytesInternal(PreparedStatement preparedStatement, long l, int n) throws SQLException {
        byte[] byArray;
        JoinPoint joinPoint;
        block9: {
            block8: {
                PreparedStatement preparedStatement2 = preparedStatement;
                long l2 = l;
                int n2 = n;
                Object[] objectArray = new Object[]{preparedStatement2, Conversions.longObject((long)l2), Conversions.intObject((int)n2)};
                joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object[])objectArray);
                Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
                java.sql.ResultSet blobRs = null;
                try {
                    void length;
                    void pos;
                    void pStmt;
                    pStmt.setLong(1, (long)pos);
                    pStmt.setInt(2, (int)length);
                    int i = 0;
                    while (i < this.numPrimaryKeys) {
                        pStmt.setString(i + 3, (String)this.primaryKeyValues.get(i));
                        ++i;
                    }
                    blobRs = pStmt.executeQuery();
                    if (!blobRs.next()) break block8;
                    byArray = ((ResultSet)blobRs).getBytes(1, true);
                    Object var7_12 = null;
                    if (blobRs == null) break block9;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    if (blobRs != null) {
                        try {
                            blobRs.close();
                        }
                        catch (SQLException sQLException) {}
                        blobRs = null;
                    }
                    throw throwable;
                }
                try {
                    blobRs.close();
                }
                catch (SQLException sQLException) {}
                blobRs = null;
                break block9;
            }
            throw SQLError.createSQLException("BLOB data not found! Did primary keys change?", "S1000");
        }
        byte[] byArray2 = byArray;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(byArray2, joinPoint);
        return byArray;
    }

    static {
        Factory factory = new Factory("BlobFromLocator.java", Class.forName("com.mysql.jdbc.BlobFromLocator"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-notEnoughInformationInQuery-com.mysql.jdbc.BlobFromLocator---java.sql.SQLException:-void-"), 155);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBinaryStream-com.mysql.jdbc.BlobFromLocator-long:-indexToWriteAt:-java.sql.SQLException:-java.io.OutputStream-"), 165);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-createGetBytesStatement-com.mysql.jdbc.BlobFromLocator---java.sql.SQLException:-java.sql.PreparedStatement-"), 506);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0-getBytesInternal-com.mysql.jdbc.BlobFromLocator-java.sql.PreparedStatement:long:int:-pStmt:pos:length:-java.sql.SQLException:-[B-"), 533);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getBinaryStream-com.mysql.jdbc.BlobFromLocator---java.sql.SQLException:-java.io.InputStream-"), 178);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBytes-com.mysql.jdbc.BlobFromLocator-long:[B:int:int:-writeAt:bytes:offset:length:-java.sql.SQLException:-int-"), 187);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-setBytes-com.mysql.jdbc.BlobFromLocator-long:[B:-writeAt:bytes:-java.sql.SQLException:-int-"), 255);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-getBytes-com.mysql.jdbc.BlobFromLocator-long:int:-pos:length:-java.sql.SQLException:-[B-"), 274);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-length-com.mysql.jdbc.BlobFromLocator---java.sql.SQLException:-long-"), 304);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-position-com.mysql.jdbc.BlobFromLocator-java.sql.Blob:long:-pattern:start:-java.sql.SQLException:-long-"), 379);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-position-com.mysql.jdbc.BlobFromLocator-[B:long:-pattern:start:-java.sql.SQLException:-long-"), 386);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-truncate-com.mysql.jdbc.BlobFromLocator-long:-length:-java.sql.SQLException:-void-"), 454);
    }

    class LocatorInputStream
    extends InputStream {
        long currentPositionInBlob = 0L;
        long length = 0L;
        PreparedStatement pStmt = null;
        private static final JoinPoint.StaticPart ajc$tjp_0;
        private static final JoinPoint.StaticPart ajc$tjp_1;
        private static final JoinPoint.StaticPart ajc$tjp_2;
        private static final JoinPoint.StaticPart ajc$tjp_3;

        LocatorInputStream() throws SQLException {
            this.length = BlobFromLocator.this.length();
            this.pStmt = BlobFromLocator.this.createGetBytesStatement();
        }

        public int read() throws IOException {
            int n;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.currentPositionInBlob + 1L > this.length) {
                n = -1;
            } else {
                try {
                    byte[] asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob++ + 1L, 1);
                    n = asBytes == null ? -1 : asBytes[0];
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            int n2 = n;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
            return n;
        }

        /*
         * WARNING - void declaration
         */
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            byte[] byArray2 = byArray;
            int n4 = n;
            int n5 = n2;
            Object[] objectArray = new Object[]{byArray2, Conversions.intObject((int)n4), Conversions.intObject((int)n5)};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.currentPositionInBlob + 1L > this.length) {
                n3 = -1;
            } else {
                try {
                    void len;
                    byte[] asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob + 1L, (int)len);
                    if (asBytes == null) {
                        n3 = -1;
                    } else {
                        void off;
                        void b;
                        System.arraycopy(asBytes, 0, b, (int)off, asBytes.length);
                        this.currentPositionInBlob += (long)asBytes.length;
                        n3 = asBytes.length;
                    }
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            int n6 = n3;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n6), joinPoint);
            return n3;
        }

        /*
         * WARNING - void declaration
         */
        public int read(byte[] byArray) throws IOException {
            int n;
            byte[] byArray2 = byArray;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)byArray2);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.currentPositionInBlob + 1L > this.length) {
                n = -1;
            } else {
                try {
                    void b;
                    byte[] asBytes = BlobFromLocator.this.getBytesInternal(this.pStmt, this.currentPositionInBlob + 1L, ((void)b).length);
                    if (asBytes == null) {
                        n = -1;
                    } else {
                        System.arraycopy(asBytes, 0, b, 0, asBytes.length);
                        this.currentPositionInBlob += (long)asBytes.length;
                        n = asBytes.length;
                    }
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            int n2 = n;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.intObject((int)n2), joinPoint);
            return n;
        }

        public void close() throws IOException {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
            Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
            if (this.pStmt != null) {
                try {
                    this.pStmt.close();
                }
                catch (SQLException sqlEx) {
                    throw new IOException(sqlEx.toString());
                }
            }
            super.close();
            Object var3_3 = null;
            Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var3_3, joinPoint);
        }

        static {
            Factory factory = new Factory("BlobFromLocator.java", Class.forName("com.mysql.jdbc.BlobFromLocator$LocatorInputStream"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.BlobFromLocator$LocatorInputStream---java.io.IOException:-int-"), 579);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.BlobFromLocator$LocatorInputStream-[B:int:int:-b:off:len:-java.io.IOException:-int-"), 603);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-read-com.mysql.jdbc.BlobFromLocator$LocatorInputStream-[B:-b:-java.io.IOException:-int-"), 631);
            ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-close-com.mysql.jdbc.BlobFromLocator$LocatorInputStream---java.io.IOException:-void-"), 659);
        }
    }
}

