/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.SocketFactory;
import com.mysql.jdbc.trace.Tracer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Properties;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class StandardSocketFactory
implements SocketFactory {
    public static final String TCP_NO_DELAY_PROPERTY_NAME = "tcpNoDelay";
    public static final String TCP_KEEP_ALIVE_DEFAULT_VALUE = "true";
    public static final String TCP_KEEP_ALIVE_PROPERTY_NAME = "tcpKeepAlive";
    public static final String TCP_RCV_BUF_PROPERTY_NAME = "tcpRcvBuf";
    public static final String TCP_SND_BUF_PROPERTY_NAME = "tcpSndBuf";
    public static final String TCP_TRAFFIC_CLASS_PROPERTY_NAME = "tcpTrafficClass";
    public static final String TCP_RCV_BUF_DEFAULT_VALUE = "0";
    public static final String TCP_SND_BUF_DEFAULT_VALUE = "0";
    public static final String TCP_TRAFFIC_CLASS_DEFAULT_VALUE = "0";
    public static final String TCP_NO_DELAY_DEFAULT_VALUE = "true";
    private static Method setTraficClassMethod;
    protected String host = null;
    protected int port = 3306;
    protected Socket rawSocket = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    private static final JoinPoint.StaticPart ajc$tjp_0;
    private static final JoinPoint.StaticPart ajc$tjp_1;
    private static final JoinPoint.StaticPart ajc$tjp_2;
    private static final JoinPoint.StaticPart ajc$tjp_3;
    private static final JoinPoint.StaticPart ajc$tjp_4;
    private static final JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("StandardSocketFactory.java", Class.forName("com.mysql.jdbc.StandardSocketFactory"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-afterHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 102);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-beforeHandshake-com.mysql.jdbc.StandardSocketFactory---java.net.SocketException:java.io.IOException:-java.net.Socket-"), 117);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-configureSocket-com.mysql.jdbc.StandardSocketFactory-java.net.Socket:java.util.Properties:-sock:props:-java.net.SocketException:java.io.IOException:-void-"), 131);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1-connect-com.mysql.jdbc.StandardSocketFactory-java.lang.String:int:java.util.Properties:-hostname:portNumber:props:-java.net.SocketException:java.io.IOException:-java.net.Socket-"), 176);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-socketNeedsConfigurationBeforeConnect-com.mysql.jdbc.StandardSocketFactory-java.util.Properties:-props:--boolean-"), 363);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2-unwrapExceptionToProperClassAndThrowIt-com.mysql.jdbc.StandardSocketFactory-java.lang.Throwable:-caughtWhileConnecting:-java.net.SocketException:java.io.IOException:-void-"), 391);
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.net.Socket");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            setTraficClassMethod = clazz.getMethod("setTrafficClass", Integer.TYPE);
        }
        catch (SecurityException securityException) {
            setTraficClassMethod = null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            setTraficClassMethod = null;
        }
    }

    public Socket afterHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    public Socket beforeHandshake() throws SocketException, IOException {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        Socket socket = this.rawSocket;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
        return socket;
    }

    /*
     * WARNING - void declaration
     */
    private void configureSocket(Socket socket, Properties properties) throws SocketException, IOException {
        Socket socket2 = socket;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)socket2, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        try {
            int trafficClass;
            int sendBufferSize;
            int receiveBufferSize;
            void props;
            void sock;
            sock.setTcpNoDelay(Boolean.valueOf(props.getProperty(TCP_NO_DELAY_PROPERTY_NAME, "true")));
            String keepAlive = props.getProperty(TCP_KEEP_ALIVE_PROPERTY_NAME, "true");
            if (keepAlive != null && keepAlive.length() > 0) {
                sock.setKeepAlive(Boolean.valueOf(keepAlive));
            }
            if ((receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"))) > 0) {
                sock.setReceiveBufferSize(receiveBufferSize);
            }
            if ((sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"))) > 0) {
                sock.setSendBufferSize(sendBufferSize);
            }
            if ((trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"))) > 0 && setTraficClassMethod != null) {
                setTraficClassMethod.invoke((Object)sock, new Integer(trafficClass));
            }
        }
        catch (Throwable t) {
            this.unwrapExceptionToProperClassAndThrowIt(t);
        }
        Object var10_11 = null;
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(var10_11, joinPoint);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket connect(String string, int n, Properties properties) throws SocketException, IOException {
        void props;
        String string2 = string;
        int n2 = n;
        Properties properties2 = properties;
        Object[] objectArray = new Object[]{string2, Conversions.intObject((int)n2), properties2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (props != null) {
            void portNumber;
            void hostname;
            this.host = hostname;
            this.port = portNumber;
            Method connectWithTimeoutMethod = null;
            Method socketBindMethod = null;
            Class<?> socketAddressClass = null;
            String localSocketHostname = props.getProperty("localSocketAddress");
            String connectTimeoutStr = props.getProperty("connectTimeout");
            int connectTimeout = 0;
            boolean wantsTimeout = connectTimeoutStr != null && connectTimeoutStr.length() > 0 && !connectTimeoutStr.equals("0");
            boolean wantsLocalBind = localSocketHostname != null && localSocketHostname.length() > 0;
            boolean needsConfigurationBeforeConnect = this.socketNeedsConfigurationBeforeConnect((Properties)props);
            if (wantsTimeout || wantsLocalBind || needsConfigurationBeforeConnect) {
                if (connectTimeoutStr != null) {
                    try {
                        connectTimeout = Integer.parseInt(connectTimeoutStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SocketException("Illegal value '" + connectTimeoutStr + "' for connectTimeout");
                    }
                }
                try {
                    socketAddressClass = Class.forName("java.net.SocketAddress");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("java.net.Socket");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    connectWithTimeoutMethod = clazz.getMethod("connect", socketAddressClass, Integer.TYPE);
                    Class<?> clazz3 = class$0;
                    if (clazz3 == null) {
                        Class<?> clazz4;
                        try {
                            clazz4 = Class.forName("java.net.Socket");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz3 = class$0 = clazz4;
                    }
                    socketBindMethod = clazz3.getMethod("bind", socketAddressClass);
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (Throwable throwable) {}
                if (wantsLocalBind && socketBindMethod == null) {
                    throw new SocketException("Can't specify \"localSocketAddress\" on JVMs older than 1.4");
                }
                if (wantsTimeout && connectWithTimeoutMethod == null) {
                    throw new SocketException("Can't specify \"connectTimeout\" on JVMs older than 1.4");
                }
            }
            if (this.host != null) {
                if (!(wantsLocalBind || wantsTimeout || needsConfigurationBeforeConnect)) {
                    InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                    Exception caughtWhileConnecting = null;
                    int i = 0;
                    while (i < possibleAddresses.length) {
                        try {
                            this.rawSocket = new Socket(possibleAddresses[i], this.port);
                            this.configureSocket(this.rawSocket, (Properties)props);
                            break;
                        }
                        catch (Exception ex) {
                            caughtWhileConnecting = ex;
                            ++i;
                        }
                    }
                    if (this.rawSocket == null) {
                        this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                    }
                } else {
                    try {
                        InetAddress[] possibleAddresses = InetAddress.getAllByName(this.host);
                        Exception caughtWhileConnecting = null;
                        Object localSockAddr = null;
                        Class<?> inetSocketAddressClass = null;
                        Constructor<?> addrConstructor = null;
                        try {
                            inetSocketAddressClass = Class.forName("java.net.InetSocketAddress");
                            Class[] classArray = new Class[2];
                            Class<?> clazz = class$1;
                            if (clazz == null) {
                                Class<?> clazz5;
                                try {
                                    clazz5 = Class.forName("java.net.InetAddress");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$1 = clazz5;
                            }
                            classArray[0] = clazz;
                            classArray[1] = Integer.TYPE;
                            addrConstructor = inetSocketAddressClass.getConstructor(classArray);
                            if (wantsLocalBind) {
                                localSockAddr = addrConstructor.newInstance(InetAddress.getByName(localSocketHostname), new Integer(0));
                            }
                        }
                        catch (Throwable ex) {
                            this.unwrapExceptionToProperClassAndThrowIt(ex);
                        }
                        int i = 0;
                        while (i < possibleAddresses.length) {
                            try {
                                this.rawSocket = new Socket();
                                this.configureSocket(this.rawSocket, (Properties)props);
                                Object sockAddr = addrConstructor.newInstance(possibleAddresses[i], new Integer(this.port));
                                socketBindMethod.invoke((Object)this.rawSocket, localSockAddr);
                                connectWithTimeoutMethod.invoke((Object)this.rawSocket, sockAddr, new Integer(connectTimeout));
                                break;
                            }
                            catch (Exception ex) {
                                this.rawSocket = null;
                                caughtWhileConnecting = ex;
                                ++i;
                            }
                        }
                        if (this.rawSocket == null) {
                            this.unwrapExceptionToProperClassAndThrowIt(caughtWhileConnecting);
                        }
                    }
                    catch (Throwable t) {
                        this.unwrapExceptionToProperClassAndThrowIt(t);
                    }
                }
                Socket socket = this.rawSocket;
                Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(socket, joinPoint);
                return socket;
            }
        }
        throw new SocketException("Unable to create socket");
    }

    /*
     * WARNING - void declaration
     */
    private boolean socketNeedsConfigurationBeforeConnect(Properties properties) {
        int trafficClass;
        int sendBufferSize;
        void props;
        Properties properties2 = properties;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)properties2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        int receiveBufferSize = Integer.parseInt(props.getProperty(TCP_RCV_BUF_PROPERTY_NAME, "0"));
        boolean bl = receiveBufferSize > 0 ? true : ((sendBufferSize = Integer.parseInt(props.getProperty(TCP_SND_BUF_PROPERTY_NAME, "0"))) > 0 ? true : (trafficClass = Integer.parseInt(props.getProperty(TCP_TRAFFIC_CLASS_PROPERTY_NAME, "0"))) > 0 && setTraficClassMethod != null);
        Tracer.aspectOf().ajc$afterReturning$com_mysql_jdbc_trace_Tracer$2$f51c62b8(Conversions.booleanObject((boolean)bl), joinPoint);
        return bl;
    }

    private void unwrapExceptionToProperClassAndThrowIt(Throwable throwable) throws SocketException, IOException {
        Throwable caughtWhileConnecting;
        Throwable throwable2 = throwable;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)throwable2);
        Tracer.aspectOf().ajc$before$com_mysql_jdbc_trace_Tracer$1$f51c62b8(joinPoint);
        if (caughtWhileConnecting instanceof InvocationTargetException) {
            caughtWhileConnecting = ((InvocationTargetException)caughtWhileConnecting).getTargetException();
        }
        if (caughtWhileConnecting instanceof SocketException) {
            throw (SocketException)caughtWhileConnecting;
        }
        if (caughtWhileConnecting instanceof IOException) {
            throw (IOException)caughtWhileConnecting;
        }
        throw new SocketException(caughtWhileConnecting.toString());
    }
}

