/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.crypto.eddsa.spec;

import java.util.HashMap;
import java.util.Locale;
import net.i2p.crypto.eddsa.Utils;
import net.i2p.crypto.eddsa.math.Curve;
import net.i2p.crypto.eddsa.math.Field;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519LittleEndianEncoding;
import net.i2p.crypto.eddsa.math.ed25519.Ed25519ScalarOps;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;

public class EdDSANamedCurveTable {
    public static final String ED_25519 = "Ed25519";
    public static final String CURVE_ED25519_SHA512 = "ed25519-sha-512";
    private static final Field ed25519field = new Field(256, Utils.hexToBytes("edffffffffffffffffffffffffffffffffffffffffffffffffffffffffffff7f"), new Ed25519LittleEndianEncoding());
    private static final Curve ed25519curve = new Curve(ed25519field, Utils.hexToBytes("a3785913ca4deb75abd841414d0a700098e879777940c78c73fe6f2bee6c0352"), ed25519field.fromByteArray(Utils.hexToBytes("b0a00e4a271beec478e42fad0618432fa7d7fb3d99004d2b0bdfc14f8024832b")));
    public static final EdDSANamedCurveSpec ED_25519_CURVE_SPEC = new EdDSANamedCurveSpec("Ed25519", ed25519curve, "SHA-512", new Ed25519ScalarOps(), ed25519curve.createPoint(Utils.hexToBytes("5866666666666666666666666666666666666666666666666666666666666666"), true));
    private static volatile HashMap<String, EdDSANamedCurveSpec> curves = new HashMap();

    private static synchronized void putCurve(String name, EdDSANamedCurveSpec curve) {
        HashMap<String, EdDSANamedCurveSpec> newCurves = new HashMap<String, EdDSANamedCurveSpec>(curves);
        newCurves.put(name, curve);
        curves = newCurves;
    }

    public static void defineCurve(EdDSANamedCurveSpec curve) {
        EdDSANamedCurveTable.putCurve(curve.getName().toLowerCase(Locale.ENGLISH), curve);
    }

    static void defineCurveAlias(String name, String alias) {
        EdDSANamedCurveSpec curve = curves.get(name.toLowerCase(Locale.ENGLISH));
        if (curve == null) {
            throw new IllegalStateException();
        }
        EdDSANamedCurveTable.putCurve(alias.toLowerCase(Locale.ENGLISH), curve);
    }

    public static EdDSANamedCurveSpec getByName(String name) {
        return curves.get(name.toLowerCase(Locale.ENGLISH));
    }

    static {
        EdDSANamedCurveTable.defineCurve(ED_25519_CURVE_SPEC);
        EdDSANamedCurveTable.defineCurveAlias(ED_25519, CURVE_ED25519_SHA512);
    }
}

