/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.css.sheet;

import com.openhtmltopdf.css.constants.MarginBoxName;
import com.openhtmltopdf.css.sheet.PropertyDeclaration;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.RulesetContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageRule
implements RulesetContainer {
    private String _name;
    private String _pseudoPage;
    private Ruleset _ruleset;
    private int _origin;
    private final Map<MarginBoxName, List<PropertyDeclaration>> _marginBoxes = new HashMap<MarginBoxName, List<PropertyDeclaration>>();
    private List<PropertyDeclaration> _footnoteArea = null;
    private int _pos;
    private int _specificityF;
    private int _specificityG;
    private int _specificityH;

    public PageRule(int origin) {
        this._origin = origin;
    }

    public String getPseudoPage() {
        return this._pseudoPage;
    }

    public void setPseudoPage(String pseudoPage) {
        this._pseudoPage = pseudoPage;
        if (pseudoPage.equals("first")) {
            this._specificityG = 1;
        } else {
            this._specificityH = 1;
        }
    }

    public Ruleset getRuleset() {
        return this._ruleset;
    }

    public void setRuleset(Ruleset ruleset) {
        this._ruleset = ruleset;
    }

    @Override
    public void addContent(Ruleset ruleset) {
        if (this._ruleset != null) {
            throw new IllegalStateException("Ruleset has already been set");
        }
        this._ruleset = ruleset;
    }

    @Override
    public int getOrigin() {
        return this._origin;
    }

    public void setOrigin(int origin) {
        this._origin = origin;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
        this._specificityF = 1;
    }

    public List<PropertyDeclaration> getMarginBoxProperties(MarginBoxName name) {
        return this._marginBoxes.get(name);
    }

    public void addMarginBoxProperties(MarginBoxName name, List<PropertyDeclaration> props) {
        this._marginBoxes.put(name, props);
    }

    public Map<MarginBoxName, List<PropertyDeclaration>> getMarginBoxes() {
        return this._marginBoxes;
    }

    public long getOrder() {
        long result2 = 0L;
        result2 |= (long)this._specificityF << 32;
        result2 |= (long)this._specificityG << 24;
        result2 |= (long)this._specificityH << 16;
        return result2 |= (long)this._pos;
    }

    public boolean applies(String pageName, String pseudoPage) {
        if (this._name == null && this._pseudoPage == null) {
            return true;
        }
        if (this._name == null && this._pseudoPage != null && (this._pseudoPage.equals(pseudoPage) || this._pseudoPage.equals("right") && pseudoPage != null && pseudoPage.equals("first"))) {
            return true;
        }
        if (this._name != null && this._name.equals(pageName) && this._pseudoPage == null) {
            return true;
        }
        return this._name != null && this._name.equals(pageName) && this._pseudoPage != null && this._pseudoPage.equals(pseudoPage);
    }

    public int getPos() {
        return this._pos;
    }

    public void setPos(int pos) {
        this._pos = pos;
    }

    public void addFootnoteAreaProperties(List<PropertyDeclaration> propertyDeclarations) {
        this._footnoteArea = propertyDeclarations;
    }

    public List<PropertyDeclaration> getFootnoteAreaProperties() {
        return this._footnoteArea;
    }
}

