/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.Binder;
import org.jetbrains.sqlite.NativeDB;
import org.jetbrains.sqlite.SqliteConnection;
import org.jetbrains.sqlite.SqlitePreparedStatement;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B)\b\u0000\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\n\u0010\u000bJO\u0010\u0013\u001a\u0002H\u0014\"\u0004\b\u0001\u0010\u00142<\u0010\u0015\u001a8\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u000f\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u0019\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0017\u0012\b\b\u0018\u0012\u0004\b\b(\u001a\u0012\u0004\u0012\u0002H\u00140\u0016\u00a2\u0006\u0002\u0010\u001bJ\"\u0010\u001c\u001a\u00020\u001d2\u0018\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00028\u00000\u000eH\u0002J\u0015\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0000\u00a2\u0006\u0002\b\"R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/sqlite/SqlStatementPool;", "T", "Lorg/jetbrains/sqlite/Binder;", "", "sql", "", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "binderProducer", "Lkotlin/Function0;", "<init>", "(Ljava/lang/String;Lorg/jetbrains/sqlite/SqliteConnection;Lkotlin/jvm/functions/Function0;)V", "pool", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "Lorg/jetbrains/sqlite/SqlitePreparedStatement;", "", "size", "Ljava/util/concurrent/atomic/AtomicInteger;", "use", "R", "task", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "statement", "binder", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "release", "", "item", "close", "db", "Lorg/jetbrains/sqlite/NativeDB;", "close$intellij_platform_sqlite", "intellij.platform.sqlite"})
public final class SqlStatementPool<T extends Binder> {
    @NotNull
    private final SqliteConnection connection;
    @NotNull
    private final Function0<T> binderProducer;
    @NotNull
    private final ConcurrentLinkedQueue<Pair<SqlitePreparedStatement<T>, T>> pool;
    @NotNull
    private final byte[] sql;
    @NotNull
    private final AtomicInteger size;

    public SqlStatementPool(@Language(value="SQLite") @NotNull String sql2, @NotNull SqliteConnection connection, @NotNull Function0<? extends T> binderProducer) {
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(binderProducer, (String)"binderProducer");
        this.connection = connection;
        this.binderProducer = binderProducer;
        this.pool = new ConcurrentLinkedQueue();
        this.sql = StringsKt.encodeToByteArray((String)sql2);
        this.size = new AtomicInteger();
    }

    public final <R> R use(@NotNull Function2<? super SqlitePreparedStatement<T>, ? super T, ? extends R> task) {
        Object object;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        Pair item = this.pool.poll();
        if (item == null) {
            Binder binder = (Binder)this.binderProducer.invoke();
            SqlitePreparedStatement<Binder> statement = this.connection.prepareStatement(this.sql, binder);
            item = TuplesKt.to(statement, (Object)binder);
        } else {
            this.size.decrementAndGet();
        }
        SqlitePreparedStatement statement = (SqlitePreparedStatement)item.getFirst();
        try {
            object = task.invoke((Object)statement, item.getSecond());
        }
        catch (Throwable e) {
            try {
                statement.close();
            }
            catch (Throwable closeError) {
                ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closeError);
            }
            throw e;
        }
        Object result2 = object;
        this.release(item);
        return (R)result2;
    }

    private final void release(Pair<SqlitePreparedStatement<T>, ? extends T> item) {
        if (this.size.get() < 16) {
            this.pool.add(item);
            this.size.incrementAndGet();
        } else {
            ((SqlitePreparedStatement)item.getFirst()).close();
        }
    }

    public final void close$intellij_platform_sqlite(@NotNull NativeDB db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.size.set(Integer.MAX_VALUE);
        while (this.pool.poll() != null) {
            Pair<SqlitePreparedStatement<T>, T> item;
            ((SqlitePreparedStatement)item.getFirst()).close$intellij_platform_sqlite(db);
        }
    }
}

