/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.template.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.ReadOnlyBlock;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.template.formatter.CompositeTemplateBlock;
import com.intellij.xml.template.formatter.FragmentedTemplateException;
import com.intellij.xml.template.formatter.TemplateFormatUtil;
import com.intellij.xml.template.formatter.TemplateSyntheticBlock;
import com.intellij.xml.template.formatter.TemplateXmlBlock;
import com.intellij.xml.template.formatter.TemplateXmlTagBlock;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractXmlTemplateFormattingModelBuilder
extends SimpleTemplateLanguageFormattingModelBuilder {
    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        block12: {
            if (formattingContext == null) {
                AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(0);
            }
            PsiFile psiFile = formattingContext.getContainingFile();
            CodeStyleSettings settings = formattingContext.getCodeStyleSettings();
            PsiElement element = formattingContext.getPsiElement();
            FileViewProvider fileViewProvider = psiFile.getViewProvider();
            if (fileViewProvider instanceof TemplateLanguageFileViewProvider) {
                TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)fileViewProvider;
                if (this.isTemplateFile(psiFile)) {
                    Language templateDataLanguage = viewProvider.getTemplateDataLanguage();
                    if (templateDataLanguage != psiFile.getLanguage()) {
                        FormattingModel formattingModel = this.createDataLanguageFormattingModel((PsiElement)viewProvider.getPsi(templateDataLanguage), templateDataLanguage, settings, psiFile, Indent.getNoneIndent());
                        if (formattingModel == null) {
                            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(1);
                        }
                        return formattingModel;
                    }
                } else if (element instanceof OuterLanguageElement && this.isOuterLanguageElement(element)) {
                    FormattingModel formattingModel;
                    try {
                        FormattingModel model2 = this.createTemplateFormattingModel(psiFile, viewProvider, (OuterLanguageElement)element, settings, Indent.getNoneIndent());
                        if (model2 == null) break block12;
                        formattingModel = model2;
                    }
                    catch (FragmentedTemplateException ie) {
                        DocumentBasedFormattingModel documentBasedFormattingModel = this.createDummyModel((Block)new ReadOnlyBlock(element.getNode()), settings, psiFile);
                        if (documentBasedFormattingModel == null) {
                            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(3);
                        }
                        return documentBasedFormattingModel;
                    }
                    if (formattingModel == null) {
                        AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(2);
                    }
                    return formattingModel;
                }
            }
        }
        FormattingModel formattingModel = super.createModel(formattingContext);
        if (formattingModel == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(4);
        }
        return formattingModel;
    }

    @NotNull
    protected DocumentBasedFormattingModel createDummyModel(Block rootBlock, CodeStyleSettings settings, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(5);
        }
        return new DocumentBasedFormattingModel(rootBlock, psiFile.getProject(), settings, psiFile.getFileType(), psiFile);
    }

    @Nullable
    FormattingModel createTemplateFormattingModel(@NotNull PsiFile psiFile, @NotNull TemplateLanguageFileViewProvider viewProvider, @NotNull OuterLanguageElement outerTemplateElement, @NotNull CodeStyleSettings settings, @Nullable Indent indent) throws FragmentedTemplateException {
        if (psiFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(6);
        }
        if (viewProvider == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(7);
        }
        if (outerTemplateElement == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(8);
        }
        if (settings == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(9);
        }
        List<PsiElement> templateElements = this.getTreeElementsInsideOuterFragment(viewProvider, outerTemplateElement);
        return this.createTemplateFormattingModelInternal(psiFile, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), templateElements, indent);
    }

    @NotNull
    protected List<PsiElement> getTreeElementsInsideOuterFragment(@NotNull TemplateLanguageFileViewProvider viewProvider, @NotNull OuterLanguageElement outerTemplateElement) {
        if (viewProvider == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(10);
        }
        if (outerTemplateElement == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(11);
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllTemplateLanguageElementsInside((PsiElement)outerTemplateElement, viewProvider);
        if (list2 == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(12);
        }
        return list2;
    }

    public FormattingModel createTemplateFormattingModel(PsiFile file, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, List<? extends PsiElement> elements, Indent indent) {
        try {
            return this.createTemplateFormattingModelInternal(file, settings, xmlFormattingPolicy, elements, indent);
        }
        catch (FragmentedTemplateException fte) {
            assert (elements.size() > 0);
            int start2 = Integer.MAX_VALUE;
            int end = -1;
            for (PsiElement psiElement : elements) {
                TextRange range = psiElement.getTextRange();
                if (range.getStartOffset() < start2) {
                    start2 = range.getStartOffset();
                }
                if (range.getEndOffset() <= end) continue;
                end = range.getEndOffset();
            }
            return this.createDummyModel(new CompositeTemplateBlock(new TextRange(start2, end)), settings, file);
        }
    }

    @Nullable
    private FormattingModel createTemplateFormattingModelInternal(@NotNull PsiFile file, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, List<? extends PsiElement> elements, Indent indent) throws FragmentedTemplateException {
        if (file == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(13);
        }
        if (elements.size() == 0) {
            return null;
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        for (PsiElement psiElement : elements) {
            if (psiElement instanceof PsiErrorElement) {
                throw new FragmentedTemplateException((PsiErrorElement)psiElement);
            }
            if (this.isMarkupLanguageElement(psiElement) || FormatterUtil.containsWhiteSpacesOnly((ASTNode)psiElement.getNode())) continue;
            templateBlocks.add(this.createTemplateLanguageBlock(psiElement.getNode(), settings, xmlFormattingPolicy, indent, null, null));
        }
        if (templateBlocks.size() == 0) {
            return null;
        }
        Block topBlock = templateBlocks.size() == 1 ? (Block)templateBlocks.get(0) : this.createCompositeTemplateBlock(templateBlocks, xmlFormattingPolicy);
        return new DocumentBasedFormattingModel(topBlock, file.getProject(), settings, file.getFileType(), file);
    }

    @NotNull
    protected Block createCompositeTemplateBlock(@NotNull List<Block> templateBlocks, XmlFormattingPolicy xmlFormattingPolicy) {
        if (templateBlocks == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(14);
        }
        return new CompositeTemplateBlock(templateBlocks);
    }

    protected abstract boolean isTemplateFile(PsiFile var1);

    public abstract boolean isOuterLanguageElement(PsiElement var1);

    public abstract boolean isMarkupLanguageElement(PsiElement var1);

    private FormattingModel createDataLanguageFormattingModel(PsiElement dataElement, Language language, CodeStyleSettings settings, @NotNull PsiFile psiFile, @Nullable Indent indent) {
        if (psiFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(15);
        }
        Block block = this.createDataLanguageRootBlock(dataElement, language, settings, AbstractXmlTemplateFormattingModelBuilder.getPolicy(settings, psiFile), psiFile, indent);
        return new DocumentBasedFormattingModel(block, psiFile.getProject(), settings, psiFile.getFileType(), psiFile);
    }

    public Block createDataLanguageRootBlock(PsiElement dataElement, Language language, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, @NotNull PsiFile psiFile, Indent indent) {
        AbstractBlock block;
        if (psiFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(16);
        }
        if (dataElement instanceof XmlTag) {
            block = this.createXmlTagBlock(dataElement.getNode(), null, null, xmlFormattingPolicy, indent);
        } else if (language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            block = this.createXmlBlock(dataElement.getNode(), null, Alignment.createAlignment(), xmlFormattingPolicy, indent, dataElement.getTextRange());
        } else {
            FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext(language, dataElement);
            if (builder2 != null && !AbstractXmlTemplateFormattingModelBuilder.isInsideXmlAttributeValue(dataElement)) {
                FormattingModel otherLanguageModel = builder2.createModel(FormattingContext.create((PsiElement)dataElement, (CodeStyleSettings)settings));
                block = otherLanguageModel.getRootBlock();
            } else {
                block = new ReadOnlyBlock(dataElement.getNode());
            }
        }
        return block;
    }

    protected abstract Block createTemplateLanguageBlock(ASTNode var1, CodeStyleSettings var2, XmlFormattingPolicy var3, Indent var4, @Nullable Alignment var5, @Nullable Wrap var6);

    protected XmlTagBlock createXmlTagBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent) {
        return new TemplateXmlTagBlock(this, node, wrap, alignment, policy, indent);
    }

    protected XmlBlock createXmlBlock(ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, XmlFormattingPolicy policy, @Nullable Indent indent, @Nullable TextRange textRange) {
        return new TemplateXmlBlock(this, node, wrap, alignment, policy, indent, textRange);
    }

    protected SyntheticBlock createSyntheticBlock(List<Block> subBlocks, Block parent, Indent indent, XmlFormattingPolicy policy, Indent childIndent) {
        return new TemplateSyntheticBlock(subBlocks, parent, indent, policy, childIndent);
    }

    public List<Block> mergeWithTemplateBlocks(List<Block> markupBlocks, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        int templateLangRangeStart = Integer.MAX_VALUE;
        int templateLangRangeEnd = -1;
        int rangeStart = Integer.MAX_VALUE;
        int rangeEnd = -1;
        PsiFile templateFile = null;
        ArrayList<Block> pureMarkupBlocks = new ArrayList<Block>();
        for (Block block : markupBlocks) {
            AnotherLanguageBlockWrapper wrapper;
            PsiElement otherLangElement;
            TextRange currRange = block.getTextRange();
            rangeStart = Math.min(currRange.getStartOffset(), rangeStart);
            rangeEnd = Math.max(currRange.getEndOffset(), rangeEnd);
            boolean isMarkupBlock = true;
            if (block instanceof AnotherLanguageBlockWrapper && this.isOuterLanguageElement(otherLangElement = (wrapper = (AnotherLanguageBlockWrapper)block).getNode().getPsi())) {
                isMarkupBlock = false;
                if (templateFile == null) {
                    FileViewProvider provider = otherLangElement.getContainingFile().getViewProvider();
                    templateFile = provider.getPsi(provider.getBaseLanguage());
                }
                templateLangRangeStart = Math.min(currRange.getStartOffset(), templateLangRangeStart);
                templateLangRangeEnd = Math.max(currRange.getEndOffset(), templateLangRangeEnd);
            }
            if (!isMarkupBlock) continue;
            pureMarkupBlocks.add(block);
        }
        if (templateLangRangeEnd > templateLangRangeStart && templateFile != null) {
            List<Block> templateBlocks = this.buildTemplateLanguageBlocksInside(templateFile, new TextRange(templateLangRangeStart, templateLangRangeEnd), settings, xmlFormattingPolicy, childrenIndent);
            if (pureMarkupBlocks.isEmpty()) {
                return this.afterMerge(templateBlocks, true, settings, xmlFormattingPolicy);
            }
            return this.afterMerge(TemplateFormatUtil.mergeBlocks(pureMarkupBlocks, templateBlocks, new TextRange(rangeStart, rangeEnd)), false, settings, xmlFormattingPolicy);
        }
        return markupBlocks;
    }

    protected List<Block> buildTemplateLanguageBlocksInside(@NotNull PsiFile templateFile, @NotNull TextRange range, CodeStyleSettings settings, XmlFormattingPolicy xmlFormattingPolicy, Indent childrenIndent) throws FragmentedTemplateException {
        if (templateFile == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(17);
        }
        if (range == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(18);
        }
        ArrayList<Block> templateBlocks = new ArrayList<Block>();
        TemplateLanguageFileViewProvider viewProvider = (TemplateLanguageFileViewProvider)templateFile.getViewProvider();
        List<PsiElement> templateElements = this.getTemplateElements(range, viewProvider);
        FormattingModel localModel = this.createTemplateFormattingModelInternal(templateFile, settings, xmlFormattingPolicy, templateElements, childrenIndent);
        if (localModel != null) {
            Block rootBlock = localModel.getRootBlock();
            if (rootBlock instanceof CompositeTemplateBlock) {
                templateBlocks.addAll(rootBlock.getSubBlocks());
            } else {
                templateBlocks.add(rootBlock);
            }
        }
        return templateBlocks;
    }

    @NotNull
    protected List<PsiElement> getTemplateElements(@NotNull TextRange range, @NotNull TemplateLanguageFileViewProvider viewProvider) {
        if (range == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(19);
        }
        if (viewProvider == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(20);
        }
        List<PsiElement> list2 = TemplateFormatUtil.findAllElementsInside(range, viewProvider, true);
        if (list2 == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(21);
        }
        return list2;
    }

    protected List<Block> afterMerge(List<Block> originalBlocks, boolean templateOnly, CodeStyleSettings settings, @NotNull XmlFormattingPolicy xmlFormattingPolicy) {
        if (xmlFormattingPolicy == null) {
            AbstractXmlTemplateFormattingModelBuilder.$$$reportNull$$$0(22);
        }
        return originalBlocks;
    }

    protected static XmlFormattingPolicy getPolicy(CodeStyleSettings settings, PsiFile psiFile) {
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)psiFile);
        return new HtmlPolicy(settings, (FormattingDocumentModel)documentModel);
    }

    private static boolean isInsideXmlAttributeValue(PsiElement element) {
        XmlAttributeValue value = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttributeValue.class, (boolean)true);
        return value != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 12, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder";
                break;
            }
            case 5: 
            case 6: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: 
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outerTemplateElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateBlocks";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFormattingPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/template/formatter/AbstractXmlTemplateFormattingModelBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeElementsInsideOuterFragment";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 12: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDummyModel";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFormattingModel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTreeElementsInsideOuterFragment";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateFormattingModelInternal";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createCompositeTemplateBlock";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDataLanguageFormattingModel";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createDataLanguageRootBlock";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildTemplateLanguageBlocksInside";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateElements";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "afterMerge";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 12, 21 -> new IllegalStateException(string);
        };
    }
}

