/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.BranchInfo;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.Comment;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.timeTracking.model.WorkItem;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import icons.TasksIcons;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="task")
public class LocalTaskImpl
extends LocalTask {
    @NonNls
    public static final String DEFAULT_TASK_ID = "Default";
    private String myId;
    @Nls
    private String mySummary;
    @Nls
    private String myDescription;
    private Comment[] myComments;
    private boolean myClosed;
    private Date myCreated;
    private Date myUpdated;
    private TaskType myType;
    private @NlsContexts.Label String myPresentableName;
    private String myCustomIcon;
    private String myProject;
    private String myNumber;
    private String myPresentableId;
    private boolean myIssue;
    private TaskRepository myRepository;
    private String myIssueUrl;
    private boolean myActive;
    private List<ChangeListInfo> myChangeLists;
    private String myShelfName;
    private boolean myRunning;
    private List<WorkItem> myWorkItems;
    private Date myLastPost;
    private List<BranchInfo> myBranches;

    public LocalTaskImpl() {
        this.myId = "";
        this.mySummary = "";
        this.myDescription = null;
        this.myComments = Comment.EMPTY_ARRAY;
        this.myClosed = false;
        this.myType = TaskType.OTHER;
        this.myCustomIcon = null;
        this.myProject = null;
        this.myNumber = "";
        this.myPresentableId = "";
        this.myIssue = false;
        this.myRepository = null;
        this.myIssueUrl = null;
        this.myChangeLists = new ArrayList<ChangeListInfo>();
        this.myRunning = false;
        this.myWorkItems = new ArrayList<WorkItem>();
        this.myBranches = new ArrayList<BranchInfo>();
    }

    public LocalTaskImpl(@NotNull String id, @NotNull @Nls String summary) {
        if (id == null) {
            LocalTaskImpl.$$$reportNull$$$0(0);
        }
        if (summary == null) {
            LocalTaskImpl.$$$reportNull$$$0(1);
        }
        this.myId = "";
        this.mySummary = "";
        this.myDescription = null;
        this.myComments = Comment.EMPTY_ARRAY;
        this.myClosed = false;
        this.myType = TaskType.OTHER;
        this.myCustomIcon = null;
        this.myProject = null;
        this.myNumber = "";
        this.myPresentableId = "";
        this.myIssue = false;
        this.myRepository = null;
        this.myIssueUrl = null;
        this.myChangeLists = new ArrayList<ChangeListInfo>();
        this.myRunning = false;
        this.myWorkItems = new ArrayList<WorkItem>();
        this.myBranches = new ArrayList<BranchInfo>();
        this.myId = id;
        this.mySummary = summary;
    }

    public LocalTaskImpl(Task origin) {
        this.myId = "";
        this.mySummary = "";
        this.myDescription = null;
        this.myComments = Comment.EMPTY_ARRAY;
        this.myClosed = false;
        this.myType = TaskType.OTHER;
        this.myCustomIcon = null;
        this.myProject = null;
        this.myNumber = "";
        this.myPresentableId = "";
        this.myIssue = false;
        this.myRepository = null;
        this.myIssueUrl = null;
        this.myChangeLists = new ArrayList<ChangeListInfo>();
        this.myRunning = false;
        this.myWorkItems = new ArrayList<WorkItem>();
        this.myBranches = new ArrayList<BranchInfo>();
        this.myId = origin.getId();
        this.myIssue = origin.isIssue();
        this.myRepository = origin.getRepository();
        this.copy(origin);
        if (origin instanceof LocalTaskImpl) {
            this.myChangeLists = ((LocalTaskImpl)origin).getChangeLists();
            this.myBranches = ((LocalTaskImpl)origin).getBranches();
            this.myActive = ((LocalTaskImpl)origin).isActive();
            this.myWorkItems = ((LocalTaskImpl)origin).getWorkItems();
            this.myRunning = ((LocalTaskImpl)origin).isRunning();
            this.myLastPost = ((LocalTaskImpl)origin).getLastPost();
            this.myPresentableName = ((LocalTaskImpl)origin).myPresentableName;
        }
    }

    @Override
    @Attribute(value="id")
    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            LocalTaskImpl.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Attribute(value="summary")
    @NotNull
    public String getSummary() {
        String string = this.mySummary;
        if (string == null) {
            LocalTaskImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    public Comment @NotNull [] getComments() {
        if (this.myComments == null) {
            LocalTaskImpl.$$$reportNull$$$0(4);
        }
        return this.myComments;
    }

    @Override
    @Tag(value="updated")
    public Date getUpdated() {
        return this.myUpdated == null ? this.getCreated() : this.myUpdated;
    }

    @Override
    @Tag(value="created")
    public Date getCreated() {
        if (this.myCreated == null) {
            this.myCreated = new Date();
        }
        return this.myCreated;
    }

    @Override
    @Attribute(value="active")
    public boolean isActive() {
        return this.myActive;
    }

    @Override
    public void updateFromIssue(Task issue) {
        this.copy(issue);
        this.myIssue = true;
    }

    private void copy(Task issue) {
        this.mySummary = issue.getSummary();
        this.myDescription = issue.getDescription();
        this.myComments = issue.getComments();
        this.myClosed = issue.isClosed();
        this.myCreated = issue.getCreated();
        if (Comparing.compare((Comparable)this.myUpdated, (Comparable)issue.getUpdated()) < 0) {
            this.myUpdated = issue.getUpdated();
        }
        this.myType = issue.getType();
        this.myPresentableName = issue.getPresentableName();
        this.myCustomIcon = issue.getCustomIcon();
        this.myIssueUrl = issue.getIssueUrl();
        this.myRepository = issue.getRepository();
        this.myProject = issue.getProject();
        this.myNumber = issue.getNumber();
        this.myPresentableId = issue.getPresentableId();
    }

    public void setId(String id) {
        this.myId = id;
    }

    public void setSummary(@Nls String summary) {
        this.mySummary = summary;
    }

    @Override
    public void setActive(boolean active) {
        this.myActive = active;
    }

    @Override
    public boolean isIssue() {
        return this.myIssue;
    }

    @Override
    @Tag(value="url")
    public String getIssueUrl() {
        return this.myIssueUrl;
    }

    public String setIssueUrl(String url) {
        this.myIssueUrl = url;
        return this.myIssueUrl;
    }

    public void setIssue(boolean issue) {
        this.myIssue = issue;
    }

    @Override
    @Transient
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    public void setRepository(TaskRepository repository) {
        this.myRepository = repository;
    }

    public void setCreated(Date created) {
        this.myCreated = created;
    }

    @Override
    public void setUpdated(Date updated) {
        this.myUpdated = updated;
    }

    @Override
    @Property(surroundWithTag=false)
    @XCollection(elementName="changelist")
    @NotNull
    public List<ChangeListInfo> getChangeLists() {
        List<ChangeListInfo> list2 = this.myChangeLists;
        if (list2 == null) {
            LocalTaskImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public void setChangeLists(List<ChangeListInfo> changeLists) {
        this.myChangeLists = changeLists;
    }

    @Override
    public void addChangelist(ChangeListInfo info) {
        if (!this.myChangeLists.contains(info)) {
            this.myChangeLists.add(info);
        }
    }

    @Override
    public void removeChangelist(ChangeListInfo info) {
        this.myChangeLists.remove(info);
    }

    @Override
    @Property(surroundWithTag=false)
    @XCollection(elementName="branch")
    @NotNull
    public List<BranchInfo> getBranches() {
        List<BranchInfo> list2 = this.myBranches;
        if (list2 == null) {
            LocalTaskImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public void setBranches(List<BranchInfo> branches) {
        this.myBranches = branches;
    }

    @Override
    public void addBranch(BranchInfo info) {
        this.myBranches.add(info);
    }

    @Override
    public void removeBranch(BranchInfo info) {
        this.myBranches.add(info);
    }

    @Override
    public String getShelfName() {
        return this.myShelfName;
    }

    @Override
    public void setShelfName(String shelfName) {
        this.myShelfName = shelfName;
    }

    @Override
    public boolean isClosed() {
        return this.myClosed;
    }

    public void setClosed(boolean closed) {
        this.myClosed = closed;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        String customIcon = this.getCustomIcon();
        if (customIcon != null && this.myRepository != null) {
            Icon icon = IconLoader.getIcon((String)customIcon, (ClassLoader)this.myRepository.getClass().getClassLoader());
            if (icon == null) {
                LocalTaskImpl.$$$reportNull$$$0(7);
            }
            return icon;
        }
        Icon icon = LocalTaskImpl.getIconFromType(this.myType, this.isIssue());
        if (icon == null) {
            LocalTaskImpl.$$$reportNull$$$0(8);
        }
        return icon;
    }

    public static Icon getIconFromType(TaskType type, boolean issue) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case TaskType.BUG -> TasksIcons.Bug;
            case TaskType.EXCEPTION -> TasksIcons.Exception;
            case TaskType.FEATURE -> AllIcons.Nodes.Favorite;
            case TaskType.OTHER -> issue ? AllIcons.FileTypes.Any_type : EmptyIcon.ICON_0;
        };
    }

    @Override
    @NotNull
    public TaskType getType() {
        TaskType taskType = this.myType;
        if (taskType == null) {
            LocalTaskImpl.$$$reportNull$$$0(9);
        }
        return taskType;
    }

    public void setType(TaskType type) {
        this.myType = type == null ? TaskType.OTHER : type;
    }

    @Override
    public boolean isDefault() {
        return this.myId.equals(DEFAULT_TASK_ID);
    }

    @Override
    public String getPresentableName() {
        return this.myPresentableName != null ? this.myPresentableName : this.toString();
    }

    @Override
    public String getCustomIcon() {
        return this.myCustomIcon;
    }

    @Override
    public long getTotalTimeSpent() {
        long timeSpent = 0L;
        for (WorkItem item : this.myWorkItems) {
            timeSpent += item.duration;
        }
        return timeSpent;
    }

    @Override
    @Tag(value="running")
    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    public void setRunning(boolean running) {
        this.myRunning = running;
    }

    @Override
    public void setWorkItems(List<WorkItem> workItems) {
        this.myWorkItems = workItems;
    }

    @Override
    @Property(surroundWithTag=false)
    @XCollection(elementName="workItem")
    @NotNull
    public List<WorkItem> getWorkItems() {
        List<WorkItem> list2 = this.myWorkItems;
        if (list2 == null) {
            LocalTaskImpl.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Override
    public void addWorkItem(WorkItem workItem) {
        this.myWorkItems.add(workItem);
    }

    @Override
    @Tag(value="lastPost")
    public Date getLastPost() {
        return this.myLastPost;
    }

    @Override
    public void setLastPost(Date date) {
        this.myLastPost = date;
        this.addWorkItem(new WorkItem(date));
    }

    @Override
    public long getTimeSpentFromLastPost() {
        long timeSpent = 0L;
        if (this.myLastPost != null) {
            for (WorkItem item : this.myWorkItems) {
                if (item.from.getTime() < this.myLastPost.getTime()) {
                    if (item.from.getTime() + item.duration <= this.myLastPost.getTime()) continue;
                    timeSpent += item.from.getTime() + item.duration - this.myLastPost.getTime();
                    continue;
                }
                timeSpent += item.duration;
            }
        } else {
            for (WorkItem item : this.myWorkItems) {
                timeSpent += item.duration;
            }
        }
        return timeSpent;
    }

    @Override
    @NotNull
    public String getNumber() {
        String string = StringUtil.isEmpty((String)this.myNumber) ? LocalTaskImpl.extractNumberFromId(this.myId) : this.myNumber;
        if (string == null) {
            LocalTaskImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void setNumber(@NotNull String number) {
        if (number == null) {
            LocalTaskImpl.$$$reportNull$$$0(12);
        }
        this.myNumber = number;
    }

    @Override
    @Nullable
    public String getProject() {
        return StringUtil.isEmpty((String)this.myProject) ? LocalTaskImpl.extractProjectFromId(this.myId) : this.myProject;
    }

    public void setProject(@Nullable String project2) {
        this.myProject = project2;
    }

    public void setPresentableId(@NotNull String presentableId) {
        if (presentableId == null) {
            LocalTaskImpl.$$$reportNull$$$0(13);
        }
        this.myPresentableId = presentableId;
    }

    @Override
    @NotNull
    public String getPresentableId() {
        String string = StringUtil.isEmpty((String)this.myPresentableId) ? this.getId() : this.myPresentableId;
        if (string == null) {
            LocalTaskImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "summary";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/impl/LocalTaskImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/impl/LocalTaskImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkItems";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setNumber";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPresentableId";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 14 -> new IllegalStateException(string);
        };
    }
}

