/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.ide.CopyPasteManager;
import com.jediterm.terminal.TerminalOutputStream;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.SimpleTerminalController;
import org.jetbrains.plugins.terminal.block.TerminalFocusModel;
import org.jetbrains.plugins.terminal.block.TerminalPromotedDumbAwareAction;
import org.jetbrains.plugins.terminal.block.output.TerminalOutputController;
import org.jetbrains.plugins.terminal.block.output.TerminalSelectionController;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptController;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;
import org.jetbrains.plugins.terminal.block.util.TerminalDataContextUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001a\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/action/TerminalPasteAction;", "Lorg/jetbrains/plugins/terminal/block/TerminalPromotedDumbAwareAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Disabled;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "pasteIntoPrompt", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "pasteIntoTerminalSession", "doPasteIntoTerminalSession", "output", "Lcom/jediterm/terminal/TerminalOutputStream;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalPasteAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalPasteAction.kt\norg/jetbrains/plugins/terminal/action/TerminalPasteAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,83:1\n24#2:84\n*S KotlinDebug\n*F\n+ 1 TerminalPasteAction.kt\norg/jetbrains/plugins/terminal/action/TerminalPasteAction\n*L\n73#1:84\n*E\n"})
public final class TerminalPasteAction
extends TerminalPromotedDumbAwareAction
implements ActionRemoteBehaviorSpecification.Disabled {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        if (editorEx == null) {
            return;
        }
        EditorEx editor2 = editorEx;
        if (TerminalDataContextUtils.INSTANCE.isPromptEditor((Editor)editor2)) {
            this.pasteIntoPrompt(e, e.getDataContext());
        } else if (TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor((Editor)editor2)) {
            this.pasteIntoTerminalSession(e);
        } else if (TerminalDataContextUtils.INSTANCE.isOutputEditor((Editor)editor2)) {
            Object object = TerminalDataContextUtils.INSTANCE.getTerminalSession$intellij_terminal(e);
            boolean bl = object != null && (object = ((BlockTerminalSession)object).getModel()) != null ? ((TerminalModel)object).isCommandRunning() : false;
            if (bl) {
                this.pasteIntoTerminalSession(e);
            } else {
                this.pasteIntoPrompt(e, null);
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = TerminalDataContextUtils.INSTANCE.getEditor(e);
        e.getPresentation().setEnabledAndVisible(editor != null && (TerminalDataContextUtils.INSTANCE.isPromptEditor(editor) || TerminalDataContextUtils.INSTANCE.isOutputEditor(editor) || TerminalDataContextUtils.INSTANCE.isAlternateBufferEditor(editor)));
    }

    private final void pasteIntoPrompt(AnActionEvent e, DataContext dataContext) {
        TerminalPromptController terminalPromptController = TerminalDataContextUtils.INSTANCE.getPromptController$intellij_terminal(e);
        if (terminalPromptController == null) {
            return;
        }
        TerminalPromptController promptController = terminalPromptController;
        TerminalFocusModel terminalFocusModel = TerminalDataContextUtils.INSTANCE.getTerminalFocusModel$intellij_terminal(e);
        if (terminalFocusModel != null) {
            terminalFocusModel.focusPrompt();
        }
        promptController.performPaste(dataContext);
    }

    private final void pasteIntoTerminalSession(AnActionEvent e) {
        BlockTerminalSession blockTerminalSession = TerminalDataContextUtils.INSTANCE.getTerminalSession$intellij_terminal(e);
        if (blockTerminalSession == null) {
            throw new IllegalStateException("No TerminalSession in the data context".toString());
        }
        BlockTerminalSession session2 = blockTerminalSession;
        TerminalSelectionController terminalSelectionController = TerminalDataContextUtils.INSTANCE.getSelectionController$intellij_terminal(e);
        if (terminalSelectionController != null) {
            terminalSelectionController.clearSelection();
        }
        SimpleTerminalController simpleTerminalController = TerminalDataContextUtils.INSTANCE.getSimpleTerminalController$intellij_terminal(e);
        if (simpleTerminalController != null) {
            simpleTerminalController.clearTextSelection();
        }
        TerminalOutputController terminalOutputController = TerminalDataContextUtils.INSTANCE.getOutputController$intellij_terminal(e);
        if (terminalOutputController != null) {
            terminalOutputController.scrollToBottom();
        }
        this.doPasteIntoTerminalSession(session2.getTerminalOutputStream$intellij_terminal());
    }

    private final void doPasteIntoTerminalSession(TerminalOutputStream output) {
        String string;
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        if (transferable == null) {
            return;
        }
        Transferable content = transferable;
        try {
            Object object = content.getTransferData(DataFlavor.stringFlavor);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            string = (String)object;
        }
        catch (Throwable t) {
            TerminalPasteAction $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(TerminalPasteAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Failed to get text from clipboard", t);
            return;
        }
        String text = string;
        if (((CharSequence)text).length() > 0) {
            output.sendString(text, false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }
}

