/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.DynamicBundle;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextComponentAccessors;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalUiSettingsManager;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.block.BlockTerminalOptions;
import org.jetbrains.plugins.terminal.block.TerminalUsageLocalStorage;
import org.jetbrains.plugins.terminal.block.feedback.BlockTerminalFeedbackSurveyKt;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptStyle;
import org.jetbrains.plugins.terminal.fus.BlockTerminalSwitchPlace;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;

public final class TerminalSettingsPanel {
    private JPanel myWholePanel;
    private TextFieldWithHistoryWithBrowseButton myShellPathField;
    private JBCheckBox mySoundBellCheckBox;
    private JBCheckBox myCloseSessionCheckBox;
    private JBCheckBox myMouseReportCheckBox;
    private JTextField myTabNameTextField;
    private JBCheckBox myPasteOnMiddleButtonCheckBox;
    private JBCheckBox myCopyOnSelectionCheckBox;
    private JBCheckBox myOverrideIdeShortcuts;
    private JBCheckBox myShellIntegration;
    private TextFieldWithBrowseButton myStartDirectoryField;
    private JPanel myProjectSettingsPanel;
    private JPanel myGlobalSettingsPanel;
    private JPanel myConfigurablesPanel;
    private JBCheckBox myHighlightHyperlinks;
    private EnvironmentVariablesTextFieldWithBrowseButton myEnvVarField;
    private ActionLink myConfigureTerminalKeybindingsActionLink;
    private ComboBox<TerminalUiSettingsManager.CursorShape> myCursorShape;
    private JBCheckBox myUseOptionAsMetaKey;
    private JPanel myNewUiSettingsPanel;
    private JBCheckBox myNewUiCheckbox;
    private JBLabel myBetaLabel;
    private JPanel myNewUiChildSettingsPanel;
    private JPanel myPromptStyleButtonsPanel;
    private JBRadioButton mySingleLineButton;
    private JBRadioButton myDoubleLineButton;
    private JBRadioButton myShellPromptButton;
    private JPanel myShellPromptButtonPanel;
    private JPanel myNewUiConfigurablesPanel;
    private Project myProject;
    private TerminalOptionsProvider myOptionsProvider;
    private TerminalProjectOptionsProvider myProjectOptionsProvider;
    private BlockTerminalOptions myBlockTerminalOptions;
    private final List<UnnamedConfigurable> myConfigurables;
    private final List<UnnamedConfigurable> myNewUiConfigurables;

    public TerminalSettingsPanel() {
        this.$$$setupUI$$$();
        this.myConfigurables = new ArrayList<UnnamedConfigurable>();
        this.myNewUiConfigurables = new ArrayList<UnnamedConfigurable>();
    }

    public JComponent createPanel(@NotNull Project project, @NotNull TerminalOptionsProvider provider, @NotNull TerminalProjectOptionsProvider projectOptionsProvider, @NotNull BlockTerminalOptions blockTerminalOptions) {
        if (project == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(0);
        }
        if (provider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(1);
        }
        if (projectOptionsProvider == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(2);
        }
        if (blockTerminalOptions == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myOptionsProvider = provider;
        this.myProjectOptionsProvider = projectOptionsProvider;
        this.myBlockTerminalOptions = blockTerminalOptions;
        this.myNewUiSettingsPanel.setVisible(ExperimentalUI.isNewUI());
        this.myBetaLabel.setIcon(AllIcons.General.Beta);
        this.myNewUiChildSettingsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)28));
        this.myNewUiCheckbox.setSelected(Registry.is((String)"terminal.new.ui"));
        this.myNewUiCheckbox.addChangeListener(__ -> this.updateNewUiPanelState());
        this.myPromptStyleButtonsPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)20, (int)0, (int)0));
        ContextHelpLabel shellPromptDescription = ContextHelpLabel.create((String)TerminalBundle.message("settings.shell.prompt.description", new Object[0]));
        shellPromptDescription.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.myShellPromptButtonPanel.add((Component)shellPromptDescription);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.mySingleLineButton);
        buttonGroup.add((AbstractButton)this.myDoubleLineButton);
        buttonGroup.add((AbstractButton)this.myShellPromptButton);
        this.myProjectSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.project.settings", new Object[0])));
        this.myGlobalSettingsPanel.setBorder(IdeBorderFactory.createTitledBorder((String)TerminalBundle.message("settings.terminal.application.settings", new Object[0])));
        this.configureShellPathField();
        this.configureStartDirectoryField();
        for (LocalTerminalCustomizer c : LocalTerminalCustomizer.EP_NAME.getExtensionList()) {
            UnnamedConfigurable newUiConfigurable;
            UnnamedConfigurable configurable = c.getConfigurable(projectOptionsProvider.getProject());
            if (configurable != null) {
                this.myConfigurables.add(configurable);
            }
            if ((newUiConfigurable = c.getBlockTerminalConfigurable(projectOptionsProvider.getProject())) == null) continue;
            this.myNewUiConfigurables.add(newUiConfigurable);
        }
        TerminalSettingsPanel.addCustomConfigurablesToPanel(this.myConfigurablesPanel, this.myConfigurables);
        TerminalSettingsPanel.addCustomConfigurablesToPanel(this.myNewUiConfigurablesPanel, this.myNewUiConfigurables);
        this.updateNewUiPanelState();
        this.myUseOptionAsMetaKey.getParent().setVisible(SystemInfo.isMac);
        return this.myWholePanel;
    }

    private void configureStartDirectoryField() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withDescription(TerminalBundle.message("settings.start.directory.browseFolder.description", new Object[0]));
        this.myStartDirectoryField.addBrowseFolderListener(null, descriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(this.myStartDirectoryField.getTextField(), () -> this.myProjectOptionsProvider.getDefaultStartingDirectory());
    }

    private void configureShellPathField() {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withDescription(TerminalBundle.message("settings.terminal.shell.executable.path.browseFolder.description", new Object[0]));
        this.myShellPathField.addBrowseFolderListener(null, descriptor, TextComponentAccessors.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.setupTextFieldDefaultValue(((TextFieldWithHistory)this.myShellPathField.getChildComponent()).getTextEditor(), () -> this.myProjectOptionsProvider.defaultShellPath());
    }

    private void setupTextFieldDefaultValue(final @NotNull JTextField textField2, @NotNull Supplier<@NlsSafe String> defaultValueSupplier) {
        String defaultShellPath;
        if (textField2 == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(4);
        }
        if (defaultValueSupplier == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(defaultShellPath = defaultValueSupplier.get()))) {
            return;
        }
        textField2.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                textField2.setForeground(defaultShellPath.equals(textField2.getText()) ? TerminalSettingsPanel.this.getDefaultValueColor() : TerminalSettingsPanel.this.getChangedValueColor());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/terminal/TerminalSettingsPanel$1", "textChanged"));
            }
        });
        if (textField2 instanceof JBTextField) {
            ((JBTextField)textField2).getEmptyText().setText(defaultShellPath);
        }
    }

    private void updateNewUiPanelState() {
        UIUtil.uiTraverser((Component)this.myNewUiChildSettingsPanel).forEach(c -> c.setEnabled(this.myNewUiCheckbox.isSelected()));
    }

    public boolean isModified() {
        return this.myNewUiCheckbox.isSelected() != Registry.is((String)"terminal.new.ui") || this.myBlockTerminalOptions.getPromptStyle() != this.getSelectedPromptStyle() || !Objects.equals(this.myShellPathField.getText(), this.myProjectOptionsProvider.getShellPath()) || !Objects.equals(this.myStartDirectoryField.getText(), StringUtil.notNullize((String)this.myProjectOptionsProvider.getStartingDirectory())) || !Objects.equals(this.myTabNameTextField.getText(), this.myOptionsProvider.getTabName()) || this.myCloseSessionCheckBox.isSelected() != this.myOptionsProvider.getCloseSessionOnLogout() || this.myMouseReportCheckBox.isSelected() != this.myOptionsProvider.getMouseReporting() || this.mySoundBellCheckBox.isSelected() != this.myOptionsProvider.getAudibleBell() || this.myCopyOnSelectionCheckBox.isSelected() != this.myOptionsProvider.getCopyOnSelection() || this.myPasteOnMiddleButtonCheckBox.isSelected() != this.myOptionsProvider.getPasteOnMiddleMouseButton() || this.myOverrideIdeShortcuts.isSelected() != this.myOptionsProvider.getOverrideIdeShortcuts() || this.myShellIntegration.isSelected() != this.myOptionsProvider.getShellIntegration() || this.myHighlightHyperlinks.isSelected() != this.myOptionsProvider.getHighlightHyperlinks() || this.myUseOptionAsMetaKey.isSelected() != this.myOptionsProvider.getUseOptionAsMetaKey() || ContainerUtil.exists(this.myConfigurables, c -> c.isModified()) || ContainerUtil.exists(this.myNewUiConfigurables, c -> c.isModified()) || !Comparing.equal((Object)this.myEnvVarField.getData(), (Object)this.myProjectOptionsProvider.getEnvData()) || this.myCursorShape.getItem() != this.myOptionsProvider.getCursorShape();
    }

    public void apply() {
        RegistryValue blockTerminalSetting = Registry.get((String)"terminal.new.ui");
        if (blockTerminalSetting.asBoolean() != this.myNewUiCheckbox.isSelected()) {
            blockTerminalSetting.setValue(this.myNewUiCheckbox.isSelected());
            TerminalUsageTriggerCollector.triggerBlockTerminalSwitched$intellij_terminal(this.myProject, this.myNewUiCheckbox.isSelected(), BlockTerminalSwitchPlace.SETTINGS);
            if (!this.myNewUiCheckbox.isSelected()) {
                TerminalUsageLocalStorage.getInstance().recordBlockTerminalDisabled();
                ApplicationManager.getApplication().invokeLater(() -> BlockTerminalFeedbackSurveyKt.showBlockTerminalFeedbackNotification(this.myProject), ModalityState.nonModal());
            }
        }
        this.myBlockTerminalOptions.setPromptStyle(this.getSelectedPromptStyle());
        this.myProjectOptionsProvider.setStartingDirectory(this.myStartDirectoryField.getText());
        this.myProjectOptionsProvider.setShellPath(this.myShellPathField.getText());
        this.myOptionsProvider.setTabName(this.myTabNameTextField.getText());
        this.myOptionsProvider.setCloseSessionOnLogout(this.myCloseSessionCheckBox.isSelected());
        this.myOptionsProvider.setMouseReporting(this.myMouseReportCheckBox.isSelected());
        this.myOptionsProvider.setAudibleBell(this.mySoundBellCheckBox.isSelected());
        this.myOptionsProvider.setCopyOnSelection(this.myCopyOnSelectionCheckBox.isSelected());
        this.myOptionsProvider.setPasteOnMiddleMouseButton(this.myPasteOnMiddleButtonCheckBox.isSelected());
        this.myOptionsProvider.setOverrideIdeShortcuts(this.myOverrideIdeShortcuts.isSelected());
        this.myOptionsProvider.setShellIntegration(this.myShellIntegration.isSelected());
        this.myOptionsProvider.setHighlightHyperlinks(this.myHighlightHyperlinks.isSelected());
        this.myOptionsProvider.setUseOptionAsMetaKey(this.myUseOptionAsMetaKey.isSelected());
        this.myConfigurables.forEach(c -> TerminalSettingsPanel.applyIgnoringConfigurationException(c));
        this.myNewUiConfigurables.forEach(c -> TerminalSettingsPanel.applyIgnoringConfigurationException(c));
        this.myProjectOptionsProvider.setEnvData(this.myEnvVarField.getData());
        this.myOptionsProvider.setCursorShape((TerminalUiSettingsManager.CursorShape)ObjectUtils.notNull((Object)((TerminalUiSettingsManager.CursorShape)this.myCursorShape.getItem()), (Object)TerminalUiSettingsManager.CursorShape.BLOCK));
    }

    private static void applyIgnoringConfigurationException(@NotNull UnnamedConfigurable configurable) {
        if (configurable == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(6);
        }
        try {
            configurable.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    public void reset() {
        this.myNewUiCheckbox.setSelected(Registry.is((String)"terminal.new.ui"));
        TerminalPromptStyle promptStyle = this.myBlockTerminalOptions.getPromptStyle();
        this.mySingleLineButton.setSelected(promptStyle == TerminalPromptStyle.SINGLE_LINE);
        this.myDoubleLineButton.setSelected(promptStyle == TerminalPromptStyle.DOUBLE_LINE);
        this.myShellPromptButton.setSelected(promptStyle == TerminalPromptStyle.SHELL);
        this.myShellPathField.setText(this.myProjectOptionsProvider.getShellPath());
        this.myStartDirectoryField.setText(this.myProjectOptionsProvider.getStartingDirectory());
        this.myTabNameTextField.setText(this.myOptionsProvider.getTabName());
        this.myCloseSessionCheckBox.setSelected(this.myOptionsProvider.getCloseSessionOnLogout());
        this.myMouseReportCheckBox.setSelected(this.myOptionsProvider.getMouseReporting());
        this.mySoundBellCheckBox.setSelected(this.myOptionsProvider.getAudibleBell());
        this.myCopyOnSelectionCheckBox.setSelected(this.myOptionsProvider.getCopyOnSelection());
        this.myPasteOnMiddleButtonCheckBox.setSelected(this.myOptionsProvider.getPasteOnMiddleMouseButton());
        this.myOverrideIdeShortcuts.setSelected(this.myOptionsProvider.getOverrideIdeShortcuts());
        this.myShellIntegration.setSelected(this.myOptionsProvider.getShellIntegration());
        this.myHighlightHyperlinks.setSelected(this.myOptionsProvider.getHighlightHyperlinks());
        this.myUseOptionAsMetaKey.setSelected(this.myOptionsProvider.getUseOptionAsMetaKey());
        this.myConfigurables.forEach(c -> c.reset());
        this.myNewUiConfigurables.forEach(c -> c.reset());
        this.myEnvVarField.setData(this.myProjectOptionsProvider.getEnvData());
        this.myCursorShape.setItem((Object)this.myOptionsProvider.getCursorShape());
        this.myEnvVarField.setEnabled(TrustedProjects.isTrusted((Project)this.myProject));
    }

    private TerminalPromptStyle getSelectedPromptStyle() {
        if (this.mySingleLineButton.isSelected()) {
            return TerminalPromptStyle.SINGLE_LINE;
        }
        if (this.myDoubleLineButton.isSelected()) {
            return TerminalPromptStyle.DOUBLE_LINE;
        }
        if (this.myShellPromptButton.isSelected()) {
            return TerminalPromptStyle.SHELL;
        }
        throw new IllegalStateException("None of prompt style radio buttons are selected");
    }

    public Color getDefaultValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.inactiveForeground", "nimbusDisabledText");
    }

    private void createUIComponents() {
        this.myConfigureTerminalKeybindingsActionLink = new ActionLink("", e -> {
            Settings settings = (Settings)DataManager.getInstance().getDataContext((Component)((ActionLink)e.getSource())).getData(Settings.KEY);
            if (settings != null) {
                Configurable configurable = settings.find("preferences.keymap");
                settings.select(configurable, "Terminal").doWhenDone(() -> EdtExecutorService.getScheduledExecutorInstance().schedule(() -> settings.select(configurable, "Terminal"), 100L, TimeUnit.MILLISECONDS));
            }
        });
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.SMALL, (Component)this.myConfigureTerminalKeybindingsActionLink);
        this.myCursorShape = new ComboBox((Object[])TerminalUiSettingsManager.CursorShape.values());
        this.myCursorShape.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> label.setText(value.getText())));
        this.myShellPathField = this.createShellPath();
    }

    private static void addCustomConfigurablesToPanel(@NotNull JPanel panel, @NotNull List<UnnamedConfigurable> configurables) {
        List components;
        if (panel == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(7);
        }
        if (configurables == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(8);
        }
        if ((components = ContainerUtil.map(configurables, it -> it.createComponent())).isEmpty()) {
            return;
        }
        panel.setLayout((LayoutManager)new GridLayoutManager(components.size(), 1));
        for (int i = 0; i < components.size(); ++i) {
            JComponent component2 = (JComponent)components.get(i);
            panel.add((Component)component2, new GridConstraints(i, 0, 1, 1, 8, 0, 0, 0, new Dimension(-1, -1), new Dimension(-1, -1), new Dimension(-1, -1), 0, false));
        }
    }

    @NotNull
    private TextFieldWithHistoryWithBrowseButton createShellPath() {
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                return new JBTextField();
            }
        });
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> this.detectShells());
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(9);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @NotNull
    private List<String> detectShells() {
        ArrayList<String> shells = new ArrayList<String>();
        if (SystemInfo.isUnix) {
            TerminalSettingsPanel.addIfExists(shells, "/bin/bash");
            TerminalSettingsPanel.addIfExists(shells, "/usr/bin/bash");
            TerminalSettingsPanel.addIfExists(shells, "/usr/local/bin/bash");
            TerminalSettingsPanel.addIfExists(shells, "/opt/homebrew/bin/bash");
            TerminalSettingsPanel.addIfExists(shells, "/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/usr/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/usr/local/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/opt/homebrew/bin/zsh");
            TerminalSettingsPanel.addIfExists(shells, "/bin/fish");
            TerminalSettingsPanel.addIfExists(shells, "/usr/bin/fish");
            TerminalSettingsPanel.addIfExists(shells, "/usr/local/bin/fish");
            TerminalSettingsPanel.addIfExists(shells, "/opt/homebrew/bin/fish");
            TerminalSettingsPanel.addIfExists(shells, "/opt/homebrew/bin/pwsh");
        } else if (SystemInfo.isWindows) {
            String cmderRoot;
            File gitBash;
            File pwsh;
            File cmd;
            File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
            if (powershell != null && StringUtil.startsWithIgnoreCase((String)powershell.getAbsolutePath(), (String)"C:\\Windows\\System32\\WindowsPowerShell\\")) {
                shells.add(powershell.getAbsolutePath());
            }
            if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                shells.add(cmd.getAbsolutePath());
            }
            if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null && StringUtil.startsWithIgnoreCase((String)pwsh.getAbsolutePath(), (String)"C:\\Program Files\\PowerShell\\")) {
                shells.add(pwsh.getAbsolutePath());
            }
            if ((gitBash = new File("C:\\Program Files\\Git\\bin\\bash.exe")).isFile()) {
                shells.add(gitBash.getAbsolutePath());
            }
            if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) == null) {
                cmderRoot = (String)this.myEnvVarField.getEnvs().get("CMDER_ROOT");
            }
            if (cmderRoot != null && cmd != null && StringUtil.startsWithIgnoreCase((String)cmd.getAbsolutePath(), (String)"C:\\Windows\\System32\\")) {
                shells.add("cmd.exe /k \"%CMDER_ROOT%\\vendor\\init.bat\"");
            }
        }
        ArrayList<String> arrayList = shells;
        if (arrayList == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static void addIfExists(@NotNull List<String> shells, @NotNull String filePath) {
        if (shells == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(11);
        }
        if (filePath == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(12);
        }
        if (Files.exists(Path.of(filePath, new String[0]), new LinkOption[0])) {
            shells.add(filePath);
        }
    }

    @NotNull
    private static Color findColorByKey(String ... colorKeys) {
        String key;
        Color c = null;
        String[] stringArray = colorKeys;
        int n = stringArray.length;
        for (int i = 0; i < n && (c = UIManager.getColor(key = stringArray[i])) == null; ++i) {
        }
        assert (c != null) : "Can't find color for keys " + Arrays.toString(colorKeys);
        Color color = c;
        if (color == null) {
            TerminalSettingsPanel.$$$reportNull$$$0(13);
        }
        return color;
    }

    public Color getChangedValueColor() {
        return TerminalSettingsPanel.findColorByKey("TextField.foreground");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBRadioButton jBRadioButton;
        JPanel jPanel2;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JPanel jPanel3;
        JPanel jPanel4;
        JBCheckBox jBCheckBox;
        JBLabel jBLabel;
        JPanel jPanel5;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel6;
        JBCheckBox jBCheckBox4;
        JBCheckBox jBCheckBox5;
        JBCheckBox jBCheckBox6;
        JBCheckBox jBCheckBox7;
        JBCheckBox jBCheckBox8;
        JBCheckBox jBCheckBox9;
        JBCheckBox jBCheckBox10;
        JTextField jTextField;
        JPanel jPanel7;
        EnvironmentVariablesTextFieldWithBrowseButton environmentVariablesTextFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel8;
        JPanel jPanel9;
        this.createUIComponents();
        this.myWholePanel = jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(10, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        Spacer spacer = new Spacer();
        jPanel10.add((Component)spacer, new GridConstraints(3, 0, 7, 4, 0, 2, 1, 6, null, null, null));
        this.myProjectSettingsPanel = jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel8, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.start.directory"));
        jPanel8.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStartDirectoryField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.environment.variables"));
        jPanel8.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnvVarField = environmentVariablesTextFieldWithBrowseButton = new EnvironmentVariablesTextFieldWithBrowseButton();
        environmentVariablesTextFieldWithBrowseButton.setText("");
        jPanel8.add((Component)environmentVariablesTextFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myGlobalSettingsPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(12, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel7, new GridConstraints(2, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.tab.name"));
        jPanel11.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTabNameTextField = jTextField = new JTextField();
        jPanel11.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalTextPosition(2);
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.path"));
        jPanel11.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = this.myShellPathField;
        jPanel11.add((Component)textFieldWithHistoryWithBrowseButton, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel12, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySoundBellCheckBox = jBCheckBox10 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox10, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.audible.bell"));
        jPanel12.add((Component)jBCheckBox10, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel12.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel13, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCloseSessionCheckBox = jBCheckBox9 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox9, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.close.session.when.it.ends"));
        jPanel13.add((Component)jBCheckBox9, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel13.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel14, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myMouseReportCheckBox = jBCheckBox8 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox8, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.mouse.reporting"));
        jPanel14.add((Component)jBCheckBox8, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel14.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel15, new GridConstraints(4, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCopyOnSelectionCheckBox = jBCheckBox7 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox7, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.copy.to.clipboard.on.selection"));
        jPanel15.add((Component)jBCheckBox7, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel15.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel16, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPasteOnMiddleButtonCheckBox = jBCheckBox6 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.paste.on.middle.mouse.button.click"));
        jPanel16.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel16.add((Component)spacer6, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel17, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOverrideIdeShortcuts = jBCheckBox5 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.override.ide.shortcuts"));
        jPanel17.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel17.add((Component)spacer7, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ActionLink actionLink = this.myConfigureTerminalKeybindingsActionLink;
        this.$$$loadButtonText$$$((AbstractButton)actionLink, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.configure.terminal.keybindings"));
        actionLink.setToolTipText(DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.keymap.plugins.terminal"));
        jPanel17.add((Component)actionLink, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel18, new GridConstraints(7, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShellIntegration = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.integration"));
        jPanel18.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel18.add((Component)spacer8, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myConfigurablesPanel = jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel6, new GridConstraints(10, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel19, new GridConstraints(8, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHighlightHyperlinks = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.highlight.hyperlinks"));
        jPanel19.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel19.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel20, new GridConstraints(11, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.cursor.shape.label"));
        jPanel20.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel20.add((Component)spacer10, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        ComboBox<TerminalUiSettingsManager.CursorShape> comboBox = this.myCursorShape;
        jPanel20.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 0, 2, 0, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel21, new GridConstraints(9, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseOptionAsMetaKey = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.use.option.as.meta.key.label"));
        jPanel21.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer11 = new Spacer();
        jPanel21.add((Component)spacer11, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNewUiSettingsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel5, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel22, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myBetaLabel = jBLabel = new JBLabel();
        jPanel22.add((Component)jBLabel, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        Spacer spacer12 = new Spacer();
        jPanel22.add((Component)spacer12, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myNewUiCheckbox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.enable.new.ui"));
        jPanel22.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 0, 0, 0, 0, null, null, null));
        this.myNewUiChildSettingsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel4.add((Component)jPanel23, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.prompt.style"));
        jPanel23.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPromptStyleButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel23.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel24, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.mySingleLineButton = jBRadioButton3 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton3, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.singleLine.prompt"));
        jPanel24.add((Component)jBRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel25, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDoubleLineButton = jBRadioButton2 = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton2, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.doubleLine.prompt"));
        jPanel25.add((Component)jBRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myShellPromptButtonPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShellPromptButton = jBRadioButton = new JBRadioButton();
        this.$$$loadButtonText$$$((AbstractButton)jBRadioButton, DynamicBundle.getBundle((String)"messages/TerminalBundle", TerminalSettingsPanel.class).getString("settings.shell.prompt"));
        Component component2 = jPanel2.add((Component)jBRadioButton);
        this.myNewUiConfigurablesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
        jLabel2.setLabelFor((Component)environmentVariablesTextFieldWithBrowseButton);
        jLabel3.setLabelFor(jTextField);
        jLabel4.setLabelFor((Component)textFieldWithHistoryWithBrowseButton);
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectOptionsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockTerminalOptions";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueSupplier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurables";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shells";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalSettingsPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createShellPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "detectShells";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findColorByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createPanel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupTextFieldDefaultValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyIgnoringConfigurationException";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCustomConfigurablesToPanel";
                break;
            }
            case 9: 
            case 10: 
            case 13: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addIfExists";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10, 13 -> new IllegalStateException(string);
        };
    }
}

