/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext.python;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.restructuredtext.python.PythonRestBundle;
import com.intellij.restructuredtext.python.SphinxDirectivesHandlerKt;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"toHtml", "Lkotlin/Pair;", "", "text", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.restructuredtext.python"})
public final class RestPythonPreviewProviderKt {
    @Nullable
    public static final Pair<String, String> toHtml(@NotNull String text, @NotNull VirtualFile virtualFile, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Module module = (Module)ApplicationManager.getApplication().runReadAction(() -> RestPythonPreviewProviderKt.toHtml$lambda$0(project, virtualFile));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Sdk sdk = PythonSdkUtil.findPythonSdk((Module)module2);
        if (sdk == null) {
            return new Pair((Object)"", (Object)PyBundle.message((String)"python.sdk.no.interpreter.configured.warning", (Object[])new Object[0]));
        }
        Sdk sdk2 = sdk;
        GeneralCommandLine generalCommandLine = PythonHelper.REST_RUNNER.newCommandLine(sdk2, CollectionsKt.listOf((Object)"rst2html"));
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"newCommandLine(...)");
        GeneralCommandLine commandLine = generalCommandLine;
        String string = virtualFile.getParent().getPath();
        byte[] byArray = text.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ProcessOutput output = PySdkUtil.getProcessOutput((GeneralCommandLine)commandLine, (String)string, null, (int)5000, (byte[])byArray, (boolean)false);
        if (!output.isCancelled() && !output.isTimeout()) {
            String string2 = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            return new Pair((Object)SphinxDirectivesHandlerKt.applySphinx(string2), (Object)("<h3>" + PythonRestBundle.message("python.rest.error.output", new Object[0]) + "</h3>" + output.getStderr()));
        }
        return new Pair((Object)"", (Object)PythonRestBundle.message("python.rest.failed.to.generate.html", new Object[0]));
    }

    private static final Module toHtml$lambda$0(Project $project, VirtualFile $virtualFile) {
        return ProjectFileIndex.getInstance((Project)$project).getModuleForFile($virtualFile);
    }
}

