/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitSelectRootDialog;
import git4idea.repo.GitRepository;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H&J\u0018\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J*\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\b\u0010\u001d\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lgit4idea/actions/GitOperationActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "repositoryState", "Lcom/intellij/dvcs/repo/Repository$State;", "<init>", "(Lcom/intellij/dvcs/repo/Repository$State;)V", "operationName", "", "Lorg/jetbrains/annotations/Nls;", "getOperationName", "()Ljava/lang/String;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMainToolbarIcon", "Ljavax/swing/Icon;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "performInBackground", "repository", "Lgit4idea/repo/GitRepository;", "getAffectedRepositories", "", "project", "Lcom/intellij/openapi/project/Project;", "chooseRepository", "repositories", "defaultRepo", "intellij.vcs.git"})
public abstract class GitOperationActionBase
extends DumbAwareAction {
    @NotNull
    private final Repository.State repositoryState;

    public GitOperationActionBase(@NotNull Repository.State repositoryState) {
        Intrinsics.checkNotNullParameter((Object)repositoryState, (String)"repositoryState");
        this.repositoryState = repositoryState;
    }

    @NotNull
    protected abstract String getOperationName();

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(!this.getAffectedRepositories(e.getProject()).isEmpty());
        if (e.getPresentation().isVisible() && Intrinsics.areEqual((Object)e.getPlace(), (Object)"GitMergeRebaseWidgetPlace")) {
            e.getPresentation().setIcon(this.getMainToolbarIcon());
        }
    }

    @Nullable
    public Icon getMainToolbarIcon() {
        return null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Project project2 = project;
        Collection<GitRepository> affectedRepositories = this.getAffectedRepositories(project2);
        if (affectedRepositories.isEmpty()) {
            return;
        }
        GitRepository defaultRepo = GitBranchUtil.guessRepositoryForOperation(project2, e.getDataContext());
        GitRepository repository = this.chooseRepository(project2, affectedRepositories, defaultRepo);
        if (repository != null) {
            this.performInBackground(repository);
        }
    }

    public abstract void performInBackground(@NotNull GitRepository var1);

    private final Collection<GitRepository> getAffectedRepositories(Project project) {
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Repository.State[] stateArray = new Repository.State[]{this.repositoryState};
        Collection<GitRepository> collection = GitUtil.getRepositoriesInStates(project, stateArray);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositoriesInStates(...)");
        return collection;
    }

    private final GitRepository chooseRepository(Project project, Collection<? extends GitRepository> repositories, GitRepository defaultRepo) {
        if (repositories.size() == 1) {
            return (GitRepository)CollectionsKt.single((Iterable)repositories);
        }
        String string = this.getTemplatePresentation().getText();
        Intrinsics.checkNotNull((Object)string);
        Object[] objectArray = new Object[]{this.getOperationName()};
        String string2 = GitBundle.message("operation.action.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return new GitSelectRootDialog(project, string, string2, repositories, defaultRepo).selectRoot();
    }
}

