'''OpenGL extension NVX.gpu_multicast2

This module customises the behaviour of the 
OpenGL.raw.GL.NVX.gpu_multicast2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension provides additional mechanisms that influence multicast rendering which is
	simultaneous rendering to multiple GPUs.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NVX/gpu_multicast2.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NVX.gpu_multicast2 import *
from OpenGL.raw.GL.NVX.gpu_multicast2 import _EXTENSION_NAME

def glInitGpuMulticast2NVX():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

# INPUT glMulticastViewportArrayvNVX.v size not checked against 'count'
glMulticastViewportArrayvNVX=wrapper.wrapper(glMulticastViewportArrayvNVX).setInputArraySize(
    'v', None
)
# INPUT glMulticastScissorArrayvNVX.v size not checked against 'count'
glMulticastScissorArrayvNVX=wrapper.wrapper(glMulticastScissorArrayvNVX).setInputArraySize(
    'v', None
)
# INPUT glAsyncCopyBufferSubDataNVX.fenceValueArray size not checked against waitSemaphoreCount
# INPUT glAsyncCopyBufferSubDataNVX.signalSemaphoreArray size not checked against signalSemaphoreCount
# INPUT glAsyncCopyBufferSubDataNVX.signalValueArray size not checked against signalSemaphoreCount
# INPUT glAsyncCopyBufferSubDataNVX.waitSemaphoreArray size not checked against waitSemaphoreCount
glAsyncCopyBufferSubDataNVX=wrapper.wrapper(glAsyncCopyBufferSubDataNVX).setInputArraySize(
    'fenceValueArray', None
).setInputArraySize(
    'signalSemaphoreArray', None
).setInputArraySize(
    'signalValueArray', None
).setInputArraySize(
    'waitSemaphoreArray', None
)
# INPUT glAsyncCopyImageSubDataNVX.signalSemaphoreArray size not checked against signalSemaphoreCount
# INPUT glAsyncCopyImageSubDataNVX.signalValueArray size not checked against signalSemaphoreCount
# INPUT glAsyncCopyImageSubDataNVX.waitSemaphoreArray size not checked against waitSemaphoreCount
# INPUT glAsyncCopyImageSubDataNVX.waitValueArray size not checked against waitSemaphoreCount
glAsyncCopyImageSubDataNVX=wrapper.wrapper(glAsyncCopyImageSubDataNVX).setInputArraySize(
    'signalSemaphoreArray', None
).setInputArraySize(
    'signalValueArray', None
).setInputArraySize(
    'waitSemaphoreArray', None
).setInputArraySize(
    'waitValueArray', None
)
### END AUTOGENERATED SECTION