/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.securityanalytics.mapper.MappingsTraverser;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class MapperUtils {
    public static final String PROPERTIES = "properties";
    public static final String PATH = "path";
    public static final String TYPE = "type";
    public static final String ALIAS = "alias";
    public static final String NESTED = "nested";

    public static List<String> getAllAliases(String aliasMappingsJson) throws IOException {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJson, Set.of());
        final ArrayList<String> aliasFields = new ArrayList<String>();
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                if (!node.getProperties().containsKey(MapperUtils.PATH) || !node.getProperties().get(MapperUtils.TYPE).equals(MapperUtils.ALIAS)) {
                    return;
                }
                aliasFields.add(node.currentPath);
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        mappingsTraverser.traverse();
        return aliasFields;
    }

    public static List<Pair<String, String>> getAllAliasPathPairs(String aliasMappingsJson) throws IOException {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJson, Set.of());
        return MapperUtils.getAllAliasPathPairs(mappingsTraverser);
    }

    public static List<Pair<String, String>> getAllAliasPathPairs(MappingMetadata mappingMetadata) throws IOException {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
        return MapperUtils.getAllAliasPathPairs(mappingsTraverser);
    }

    public static List<Pair<String, String>> getAllAliasPathPairs(MappingsTraverser mappingsTraverser) throws IOException {
        final ArrayList<Pair<String, String>> aliasPathPairs = new ArrayList<Pair<String, String>>();
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                if (!node.getProperties().containsKey(MapperUtils.PATH) || !node.getProperties().get(MapperUtils.TYPE).equals(MapperUtils.ALIAS)) {
                    return;
                }
                aliasPathPairs.add(Pair.of((Object)node.currentPath, (Object)((String)node.getProperties().get(MapperUtils.PATH))));
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        mappingsTraverser.traverse();
        return aliasPathPairs;
    }

    public static List<String> getAllPathsFromAliasMappings(String aliasMappingsJson) throws IOException {
        final ArrayList<String> paths = new ArrayList<String>();
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJson, Set.of());
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                if (!node.getProperties().containsKey(MapperUtils.PATH)) {
                    throw new IllegalArgumentException("Alias mappings are missing path for alias: [" + node.getNodeName() + "]");
                }
                if (!node.getProperties().get(MapperUtils.TYPE).equals(MapperUtils.ALIAS)) {
                    throw new IllegalArgumentException("Alias mappings contains property of type: [" + String.valueOf(node.node.get(MapperUtils.TYPE)) + "]");
                }
                paths.add((String)node.getProperties().get(MapperUtils.PATH));
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        mappingsTraverser.traverse();
        return paths;
    }

    public static Pair<List<String>, List<String>> validateIndexMappings(String indexName, MappingMetadata mappingMetadata, String aliasMappingsJSON) throws IOException {
        if (MapperUtils.isIndexMappingsEmpty(mappingMetadata)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Mappings for index [%s] are empty", indexName));
        }
        List<String> paths = MapperUtils.getAllPathsFromAliasMappings(aliasMappingsJSON);
        List<String> flatFields = MapperUtils.getAllNonAliasFieldsFromIndex(mappingMetadata);
        ArrayList missingPaths = new ArrayList();
        ArrayList presentPaths = new ArrayList();
        paths.stream().forEach(e -> {
            if (flatFields.contains(e)) {
                presentPaths.add(e);
            } else {
                missingPaths.add(e);
            }
        });
        return Pair.of(missingPaths, presentPaths);
    }

    public static List<String> extractAllFieldsFlat(MappingMetadata mappingMetadata) {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
        final ArrayList<String> flatProperties = new ArrayList<String>();
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                flatProperties.add(node.currentPath);
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        mappingsTraverser.traverse();
        return flatProperties;
    }

    public static List<String> extractAllFieldsFlat(Map<String, Object> mappingsMap) {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingsMap, Set.of());
        final ArrayList<String> flatProperties = new ArrayList<String>();
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                flatProperties.add(node.currentPath);
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException(error);
            }
        });
        mappingsTraverser.traverse();
        return flatProperties;
    }

    public static List<String> getAllNonAliasFieldsFromIndex(MappingMetadata mappingMetadata) {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
        return mappingsTraverser.extractFlatNonAliasFields();
    }

    public static boolean isIndexMappingsEmpty(MappingMetadata mappingMetadata) {
        return mappingMetadata.getSourceAsMap().size() == 0;
    }

    public static Map<String, Object> getAliasMappingsWithFilter(String aliasMappingsJson, final List<String> aliasesToInclude) throws IOException {
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJson, Set.of());
        final HashMap filteredProperties = new HashMap();
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                if (!aliasesToInclude.contains(node.currentPath)) {
                    return;
                }
                MappingsTraverser.Node n = node;
                while (n.parent != null) {
                    n = n.parent;
                }
                if (n == null) {
                    n = node;
                }
                filteredProperties.put(n.getNodeName(), n.getProperties());
            }

            @Override
            public void onError(String error) {
                throw new IllegalArgumentException("");
            }
        });
        mappingsTraverser.traverse();
        return Map.of(PROPERTIES, filteredProperties);
    }

    public static Map<String, Object> getFieldMappingsFlat(MappingMetadata mappingMetadata, final List<String> fieldPaths) {
        final HashMap<String, Object> presentPathsMappings = new HashMap<String, Object>();
        MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
        mappingsTraverser.addListener(new MappingsTraverser.MappingsTraverserListener(){

            @Override
            public void onLeafVisited(MappingsTraverser.Node node) {
                if (fieldPaths.contains(node.currentPath)) {
                    presentPathsMappings.put(node.currentPath, node.getProperties());
                }
            }

            @Override
            public void onError(String error) {
                throw SecurityAnalyticsException.wrap(new IllegalArgumentException("Failed traversing index mappings: [" + error + "]"));
            }
        });
        mappingsTraverser.traverse();
        return presentPathsMappings;
    }
}

