/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.securityanalytics.commons.connector.model.S3ConnectorConfig;
import org.opensearch.securityanalytics.threatIntel.model.S3Source;

public class TestS3ConnectionRequest
extends ActionRequest
implements ToXContentObject {
    private final S3Source s3Source;

    public TestS3ConnectionRequest(S3Source s3Source) {
        this.s3Source = s3Source;
    }

    public TestS3ConnectionRequest(String bucketName, String objectKey, String region, String roleArn) {
        this(new S3Source(bucketName, objectKey, region, roleArn));
    }

    public TestS3ConnectionRequest(StreamInput sin) throws IOException {
        this(new S3Source(sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.s3Source.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.s3Source.getBucketName() == null || this.s3Source.getBucketName().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Must provide bucket name.", validationException);
        }
        if (this.s3Source.getObjectKey() == null || this.s3Source.getObjectKey().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Must provide object key.", (ActionRequestValidationException)validationException);
        }
        if (this.s3Source.getObjectKey() == null || this.s3Source.getObjectKey().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Must provide region.", (ActionRequestValidationException)validationException);
        }
        if (this.s3Source.getRoleArn() == null || this.s3Source.getRoleArn().isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Must provide role ARN.", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public static TestS3ConnectionRequest parse(XContentParser xcp) throws IOException {
        return new TestS3ConnectionRequest(S3Source.parse(xcp));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.s3Source.toXContent(builder, params);
    }

    public S3ConnectorConfig constructS3ConnectorConfig() {
        return new S3ConnectorConfig(this.s3Source.getBucketName(), this.s3Source.getObjectKey(), this.s3Source.getRegion(), this.s3Source.getRoleArn());
    }

    public S3Source getS3Source() {
        return this.s3Source;
    }
}

