/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport.handler;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.util.ParseUtils;
import org.opensearch.timeseries.util.RestHandlerUtils;

public class SearchHandler {
    private final Logger logger = LogManager.getLogger(SearchHandler.class);
    private final Client client;
    private volatile Boolean filterEnabled;

    public SearchHandler(Settings settings, ClusterService clusterService, Client client, Setting<Boolean> filterByBackendRoleSetting) {
        this.client = client;
        this.filterEnabled = (Boolean)filterByBackendRoleSetting.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(filterByBackendRoleSetting, it -> {
            this.filterEnabled = it;
        });
    }

    public void search(SearchRequest request, ActionListener<SearchResponse> actionListener) {
        User user = ParseUtils.getUserContext(this.client);
        ActionListener listener = RestHandlerUtils.wrapRestActionListener(actionListener, CommonMessages.FAIL_TO_SEARCH);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.validateRole(request, user, (ActionListener<SearchResponse>)listener);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            listener.onFailure(e);
        }
    }

    private void validateRole(SearchRequest request, User user, ActionListener<SearchResponse> listener) {
        if (user == null || !this.filterEnabled.booleanValue() || ParseUtils.isAdmin(user)) {
            this.client.search(request, listener);
        } else {
            try {
                ParseUtils.addUserBackendRolesFilter(user, request.source());
                this.logger.debug("Filtering result by " + String.valueOf(user.getBackendRoles()));
                this.client.search(request, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }
    }
}

