/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries;

import com.amazon.randomcutforest.parkservices.state.RCFCasterMapper;
import com.amazon.randomcutforest.parkservices.state.RCFCasterState;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestMapper;
import com.amazon.randomcutforest.parkservices.state.ThresholdedRandomCutForestState;
import com.amazon.randomcutforest.serialize.json.v1.V1JsonToV3StateConverter;
import com.amazon.randomcutforest.state.RandomCutForestMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.protostuff.LinkedBuffer;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.SpecialPermission;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.ADJobProcessor;
import org.opensearch.ad.ADTaskProfileRunner;
import org.opensearch.ad.AnomalyDetectorRunner;
import org.opensearch.ad.ExecuteADResultResponseRecorder;
import org.opensearch.ad.caching.ADCacheProvider;
import org.opensearch.ad.caching.ADPriorityCache;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.indices.ADIndexManagement;
import org.opensearch.ad.ml.ADCheckpointDao;
import org.opensearch.ad.ml.ADColdStart;
import org.opensearch.ad.ml.ADModelManager;
import org.opensearch.ad.ml.ADRealTimeInferencer;
import org.opensearch.ad.ml.HybridThresholdingModel;
import org.opensearch.ad.model.AnomalyDetector;
import org.opensearch.ad.model.AnomalyResult;
import org.opensearch.ad.model.DetectorInternalState;
import org.opensearch.ad.ratelimit.ADCheckpointMaintainWorker;
import org.opensearch.ad.ratelimit.ADCheckpointReadWorker;
import org.opensearch.ad.ratelimit.ADCheckpointWriteWorker;
import org.opensearch.ad.ratelimit.ADColdEntityWorker;
import org.opensearch.ad.ratelimit.ADColdStartWorker;
import org.opensearch.ad.ratelimit.ADResultWriteWorker;
import org.opensearch.ad.ratelimit.ADSaveResultStrategy;
import org.opensearch.ad.rest.RestAnomalyDetectorJobAction;
import org.opensearch.ad.rest.RestDeleteAnomalyDetectorAction;
import org.opensearch.ad.rest.RestDeleteAnomalyResultsAction;
import org.opensearch.ad.rest.RestExecuteAnomalyDetectorAction;
import org.opensearch.ad.rest.RestGetAnomalyDetectorAction;
import org.opensearch.ad.rest.RestIndexAnomalyDetectorAction;
import org.opensearch.ad.rest.RestPreviewAnomalyDetectorAction;
import org.opensearch.ad.rest.RestSearchADTasksAction;
import org.opensearch.ad.rest.RestSearchAnomalyDetectorAction;
import org.opensearch.ad.rest.RestSearchAnomalyDetectorInfoAction;
import org.opensearch.ad.rest.RestSearchAnomalyResultAction;
import org.opensearch.ad.rest.RestSearchTopAnomalyResultAction;
import org.opensearch.ad.rest.RestStatsAnomalyDetectorAction;
import org.opensearch.ad.rest.RestValidateAnomalyDetectorAction;
import org.opensearch.ad.rest.handler.ADIndexJobActionHandler;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.settings.ADNumericSetting;
import org.opensearch.ad.settings.AnomalyDetectorSettings;
import org.opensearch.ad.settings.LegacyOpenDistroAnomalyDetectorSettings;
import org.opensearch.ad.stats.ADStats;
import org.opensearch.ad.stats.suppliers.ADModelsOnNodeCountSupplier;
import org.opensearch.ad.stats.suppliers.ADModelsOnNodeSupplier;
import org.opensearch.ad.task.ADBatchTaskRunner;
import org.opensearch.ad.task.ADTaskCacheManager;
import org.opensearch.ad.task.ADTaskManager;
import org.opensearch.ad.transport.ADBatchAnomalyResultAction;
import org.opensearch.ad.transport.ADBatchAnomalyResultTransportAction;
import org.opensearch.ad.transport.ADBatchTaskRemoteExecutionAction;
import org.opensearch.ad.transport.ADBatchTaskRemoteExecutionTransportAction;
import org.opensearch.ad.transport.ADCancelTaskAction;
import org.opensearch.ad.transport.ADCancelTaskTransportAction;
import org.opensearch.ad.transport.ADEntityProfileAction;
import org.opensearch.ad.transport.ADEntityProfileTransportAction;
import org.opensearch.ad.transport.ADHCImputeAction;
import org.opensearch.ad.transport.ADHCImputeTransportAction;
import org.opensearch.ad.transport.ADProfileAction;
import org.opensearch.ad.transport.ADProfileTransportAction;
import org.opensearch.ad.transport.ADResultBulkAction;
import org.opensearch.ad.transport.ADResultBulkTransportAction;
import org.opensearch.ad.transport.ADSingleStreamResultAction;
import org.opensearch.ad.transport.ADSingleStreamResultTransportAction;
import org.opensearch.ad.transport.ADStatsNodesAction;
import org.opensearch.ad.transport.ADStatsNodesTransportAction;
import org.opensearch.ad.transport.ADTaskProfileAction;
import org.opensearch.ad.transport.ADTaskProfileTransportAction;
import org.opensearch.ad.transport.AnomalyDetectorJobAction;
import org.opensearch.ad.transport.AnomalyDetectorJobTransportAction;
import org.opensearch.ad.transport.AnomalyResultAction;
import org.opensearch.ad.transport.AnomalyResultTransportAction;
import org.opensearch.ad.transport.CronAction;
import org.opensearch.ad.transport.DeleteADModelAction;
import org.opensearch.ad.transport.DeleteADModelTransportAction;
import org.opensearch.ad.transport.DeleteAnomalyDetectorAction;
import org.opensearch.ad.transport.DeleteAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.DeleteAnomalyResultsAction;
import org.opensearch.ad.transport.DeleteAnomalyResultsTransportAction;
import org.opensearch.ad.transport.EntityADResultAction;
import org.opensearch.ad.transport.EntityADResultTransportAction;
import org.opensearch.ad.transport.ForwardADTaskAction;
import org.opensearch.ad.transport.ForwardADTaskTransportAction;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.ad.transport.GetAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.IndexAnomalyDetectorAction;
import org.opensearch.ad.transport.IndexAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorAction;
import org.opensearch.ad.transport.PreviewAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.RCFPollingAction;
import org.opensearch.ad.transport.RCFPollingTransportAction;
import org.opensearch.ad.transport.RCFResultAction;
import org.opensearch.ad.transport.RCFResultTransportAction;
import org.opensearch.ad.transport.SearchADTasksAction;
import org.opensearch.ad.transport.SearchADTasksTransportAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorInfoTransportAction;
import org.opensearch.ad.transport.SearchAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.SearchAnomalyResultAction;
import org.opensearch.ad.transport.SearchAnomalyResultTransportAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultAction;
import org.opensearch.ad.transport.SearchTopAnomalyResultTransportAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorAction;
import org.opensearch.ad.transport.StatsAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.StopDetectorAction;
import org.opensearch.ad.transport.StopDetectorTransportAction;
import org.opensearch.ad.transport.ThresholdResultAction;
import org.opensearch.ad.transport.ThresholdResultTransportAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorAction;
import org.opensearch.ad.transport.ValidateAnomalyDetectorTransportAction;
import org.opensearch.ad.transport.handler.ADIndexMemoryPressureAwareResultHandler;
import org.opensearch.ad.transport.handler.ADSearchHandler;
import org.opensearch.client.Client;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.settings.SettingsFilter;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.OpenSearchExecutors;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.NamedWriteableRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.env.Environment;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.forecast.ExecuteForecastResultResponseRecorder;
import org.opensearch.forecast.ForecastJobProcessor;
import org.opensearch.forecast.ForecastTaskProfileRunner;
import org.opensearch.forecast.caching.ForecastCacheProvider;
import org.opensearch.forecast.caching.ForecastPriorityCache;
import org.opensearch.forecast.indices.ForecastIndex;
import org.opensearch.forecast.indices.ForecastIndexManagement;
import org.opensearch.forecast.ml.ForecastCheckpointDao;
import org.opensearch.forecast.ml.ForecastColdStart;
import org.opensearch.forecast.ml.ForecastModelManager;
import org.opensearch.forecast.ml.ForecastRealTimeInferencer;
import org.opensearch.forecast.model.ForecastResult;
import org.opensearch.forecast.model.Forecaster;
import org.opensearch.forecast.ratelimit.ForecastCheckpointMaintainWorker;
import org.opensearch.forecast.ratelimit.ForecastCheckpointReadWorker;
import org.opensearch.forecast.ratelimit.ForecastCheckpointWriteWorker;
import org.opensearch.forecast.ratelimit.ForecastColdEntityWorker;
import org.opensearch.forecast.ratelimit.ForecastColdStartWorker;
import org.opensearch.forecast.ratelimit.ForecastResultWriteWorker;
import org.opensearch.forecast.ratelimit.ForecastSaveResultStrategy;
import org.opensearch.forecast.rest.RestDeleteForecasterAction;
import org.opensearch.forecast.rest.RestForecasterJobAction;
import org.opensearch.forecast.rest.RestForecasterSuggestAction;
import org.opensearch.forecast.rest.RestGetForecasterAction;
import org.opensearch.forecast.rest.RestIndexForecasterAction;
import org.opensearch.forecast.rest.RestRunOnceForecasterAction;
import org.opensearch.forecast.rest.RestSearchForecastTasksAction;
import org.opensearch.forecast.rest.RestSearchForecasterAction;
import org.opensearch.forecast.rest.RestSearchForecasterInfoAction;
import org.opensearch.forecast.rest.RestSearchTopForecastResultAction;
import org.opensearch.forecast.rest.RestStatsForecasterAction;
import org.opensearch.forecast.rest.RestValidateForecasterAction;
import org.opensearch.forecast.rest.handler.ForecastIndexJobActionHandler;
import org.opensearch.forecast.settings.ForecastEnabledSetting;
import org.opensearch.forecast.settings.ForecastNumericSetting;
import org.opensearch.forecast.settings.ForecastSettings;
import org.opensearch.forecast.stats.ForecastModelsOnNodeSupplier;
import org.opensearch.forecast.stats.ForecastStats;
import org.opensearch.forecast.stats.suppliers.ForecastModelsOnNodeCountSupplier;
import org.opensearch.forecast.task.ForecastTaskManager;
import org.opensearch.forecast.transport.DeleteForecastModelAction;
import org.opensearch.forecast.transport.DeleteForecastModelTransportAction;
import org.opensearch.forecast.transport.DeleteForecasterAction;
import org.opensearch.forecast.transport.DeleteForecasterTransportAction;
import org.opensearch.forecast.transport.EntityForecastResultAction;
import org.opensearch.forecast.transport.EntityForecastResultTransportAction;
import org.opensearch.forecast.transport.ForecastEntityProfileAction;
import org.opensearch.forecast.transport.ForecastEntityProfileTransportAction;
import org.opensearch.forecast.transport.ForecastProfileAction;
import org.opensearch.forecast.transport.ForecastProfileTransportAction;
import org.opensearch.forecast.transport.ForecastResultAction;
import org.opensearch.forecast.transport.ForecastResultBulkAction;
import org.opensearch.forecast.transport.ForecastResultBulkTransportAction;
import org.opensearch.forecast.transport.ForecastResultTransportAction;
import org.opensearch.forecast.transport.ForecastRunOnceAction;
import org.opensearch.forecast.transport.ForecastRunOnceProfileAction;
import org.opensearch.forecast.transport.ForecastRunOnceProfileTransportAction;
import org.opensearch.forecast.transport.ForecastRunOnceTransportAction;
import org.opensearch.forecast.transport.ForecastSingleStreamResultAction;
import org.opensearch.forecast.transport.ForecastSingleStreamResultTransportAction;
import org.opensearch.forecast.transport.ForecastStatsNodesAction;
import org.opensearch.forecast.transport.ForecastStatsNodesTransportAction;
import org.opensearch.forecast.transport.ForecasterJobAction;
import org.opensearch.forecast.transport.ForecasterJobTransportAction;
import org.opensearch.forecast.transport.GetForecasterAction;
import org.opensearch.forecast.transport.GetForecasterTransportAction;
import org.opensearch.forecast.transport.IndexForecasterAction;
import org.opensearch.forecast.transport.IndexForecasterTransportAction;
import org.opensearch.forecast.transport.SearchForecastTasksAction;
import org.opensearch.forecast.transport.SearchForecastTasksTransportAction;
import org.opensearch.forecast.transport.SearchForecasterAction;
import org.opensearch.forecast.transport.SearchForecasterInfoAction;
import org.opensearch.forecast.transport.SearchForecasterInfoTransportAction;
import org.opensearch.forecast.transport.SearchForecasterTransportAction;
import org.opensearch.forecast.transport.SearchTopForecastResultAction;
import org.opensearch.forecast.transport.SearchTopForecastResultTransportAction;
import org.opensearch.forecast.transport.StatsForecasterAction;
import org.opensearch.forecast.transport.StatsForecasterTransportAction;
import org.opensearch.forecast.transport.StopForecasterAction;
import org.opensearch.forecast.transport.StopForecasterTransportAction;
import org.opensearch.forecast.transport.SuggestForecasterParamAction;
import org.opensearch.forecast.transport.SuggestForecasterParamTransportAction;
import org.opensearch.forecast.transport.ValidateForecasterAction;
import org.opensearch.forecast.transport.ValidateForecasterTransportAction;
import org.opensearch.forecast.transport.handler.ForecastIndexMemoryPressureAwareResultHandler;
import org.opensearch.forecast.transport.handler.ForecastSearchHandler;
import org.opensearch.indices.SystemIndexDescriptor;
import org.opensearch.jobscheduler.spi.JobSchedulerExtension;
import org.opensearch.jobscheduler.spi.ScheduledJobParser;
import org.opensearch.jobscheduler.spi.ScheduledJobRunner;
import org.opensearch.monitor.jvm.JvmInfo;
import org.opensearch.monitor.jvm.JvmService;
import org.opensearch.plugins.ActionPlugin;
import org.opensearch.plugins.Plugin;
import org.opensearch.plugins.ScriptPlugin;
import org.opensearch.plugins.SystemIndexPlugin;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.script.ScriptService;
import org.opensearch.threadpool.ExecutorBuilder;
import org.opensearch.threadpool.ScalingExecutorBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.JobRunner;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.NodeStateManager;
import org.opensearch.timeseries.breaker.CircuitBreakerService;
import org.opensearch.timeseries.cluster.ADDataMigrator;
import org.opensearch.timeseries.cluster.ClusterEventListener;
import org.opensearch.timeseries.cluster.ClusterManagerEventListener;
import org.opensearch.timeseries.cluster.HashRing;
import org.opensearch.timeseries.dataprocessor.LinearUniformImputer;
import org.opensearch.timeseries.feature.FeatureManager;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.function.ThrowingSupplierWrapper;
import org.opensearch.timeseries.model.Job;
import org.opensearch.timeseries.ratelimit.CheckPointMaintainRequestAdapter;
import org.opensearch.timeseries.settings.TimeSeriesEnabledSetting;
import org.opensearch.timeseries.settings.TimeSeriesSettings;
import org.opensearch.timeseries.stats.StatNames;
import org.opensearch.timeseries.stats.TimeSeriesStat;
import org.opensearch.timeseries.stats.suppliers.CounterSupplier;
import org.opensearch.timeseries.stats.suppliers.IndexStatusSupplier;
import org.opensearch.timeseries.stats.suppliers.SettableSupplier;
import org.opensearch.timeseries.task.TaskCacheManager;
import org.opensearch.timeseries.transport.CronTransportAction;
import org.opensearch.timeseries.transport.handler.ResultBulkIndexingHandler;
import org.opensearch.timeseries.util.ClientUtil;
import org.opensearch.timeseries.util.DiscoveryNodeFilterer;
import org.opensearch.timeseries.util.IndexUtils;
import org.opensearch.timeseries.util.SecurityClientUtil;
import org.opensearch.watcher.ResourceWatcherService;

public class TimeSeriesAnalyticsPlugin
extends Plugin
implements ActionPlugin,
ScriptPlugin,
SystemIndexPlugin,
JobSchedulerExtension {
    private static final Logger LOG = LogManager.getLogger(TimeSeriesAnalyticsPlugin.class);
    public static final String LEGACY_AD_BASE = "/_opendistro/_anomaly_detection";
    public static final String LEGACY_OPENDISTRO_AD_BASE_URI = "/_opendistro/_anomaly_detection/detectors";
    public static final String AD_BASE_URI = "/_plugins/_anomaly_detection";
    public static final String AD_BASE_DETECTORS_URI = "/_plugins/_anomaly_detection/detectors";
    public static final String AD_THREAD_POOL_PREFIX = "opensearch.ad.";
    public static final String AD_THREAD_POOL_NAME = "ad-threadpool";
    public static final String AD_BATCH_TASK_THREAD_POOL_NAME = "ad-batch-task-threadpool";
    public static final String FORECAST_BASE_URI = "/_plugins/_forecast";
    public static final String FORECAST_FORECASTERS_URI = "/_plugins/_forecast/forecasters";
    public static final String FORECAST_THREAD_POOL_PREFIX = "opensearch.forecast.";
    public static final String FORECAST_THREAD_POOL_NAME = "forecast-threadpool";
    public static final String TIME_SERIES_JOB_TYPE = "opensearch_time_series_analytics";
    private static Gson gson;
    private ADIndexManagement anomalyDetectionIndices;
    private ForecastIndexManagement forecastIndices;
    private AnomalyDetectorRunner anomalyDetectorRunner;
    private Client client;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private ADStats adStats;
    private ForecastStats forecastStats;
    private ClientUtil clientUtil;
    private SecurityClientUtil securityClientUtil;
    private DiscoveryNodeFilterer nodeFilter;
    private IndexUtils indexUtils;
    private ADTaskManager adTaskManager;
    private ForecastTaskManager forecastTaskManager;
    private ADBatchTaskRunner adBatchTaskRunner;
    GenericObjectPool<LinkedBuffer> serializeRCFBufferPool;
    private NodeStateManager stateManager;
    private ExecuteADResultResponseRecorder adResultResponseRecorder;
    private ExecuteForecastResultResponseRecorder forecastResultResponseRecorder;
    private ADIndexJobActionHandler adIndexJobActionHandler;
    private ForecastIndexJobActionHandler forecastIndexJobActionHandler;

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ADJobProcessor adJobRunner = ADJobProcessor.getInstance();
        adJobRunner.setClient(this.client);
        adJobRunner.setThreadPool(this.threadPool);
        adJobRunner.registerSettings(settings);
        adJobRunner.setIndexManagement(this.anomalyDetectionIndices);
        adJobRunner.setTaskManager(this.adTaskManager);
        adJobRunner.setNodeStateManager(this.stateManager);
        adJobRunner.setExecuteResultResponseRecorder(this.adResultResponseRecorder);
        adJobRunner.setIndexJobActionHandler(this.adIndexJobActionHandler);
        RestGetAnomalyDetectorAction restGetAnomalyDetectorAction = new RestGetAnomalyDetectorAction();
        RestIndexAnomalyDetectorAction restIndexAnomalyDetectorAction = new RestIndexAnomalyDetectorAction(settings, this.clusterService);
        RestSearchAnomalyDetectorAction searchAnomalyDetectorAction = new RestSearchAnomalyDetectorAction();
        RestSearchAnomalyResultAction searchAnomalyResultAction = new RestSearchAnomalyResultAction();
        RestSearchADTasksAction searchADTasksAction = new RestSearchADTasksAction();
        RestDeleteAnomalyDetectorAction deleteAnomalyDetectorAction = new RestDeleteAnomalyDetectorAction();
        RestExecuteAnomalyDetectorAction executeAnomalyDetectorAction = new RestExecuteAnomalyDetectorAction(settings, this.clusterService);
        RestStatsAnomalyDetectorAction statsAnomalyDetectorAction = new RestStatsAnomalyDetectorAction(this.adStats, this.nodeFilter);
        RestAnomalyDetectorJobAction anomalyDetectorJobAction = new RestAnomalyDetectorJobAction(settings, this.clusterService);
        RestSearchAnomalyDetectorInfoAction searchAnomalyDetectorInfoAction = new RestSearchAnomalyDetectorInfoAction();
        RestPreviewAnomalyDetectorAction previewAnomalyDetectorAction = new RestPreviewAnomalyDetectorAction();
        RestDeleteAnomalyResultsAction deleteAnomalyResultsAction = new RestDeleteAnomalyResultsAction();
        RestSearchTopAnomalyResultAction searchTopAnomalyResultAction = new RestSearchTopAnomalyResultAction();
        RestValidateAnomalyDetectorAction validateAnomalyDetectorAction = new RestValidateAnomalyDetectorAction(settings, this.clusterService);
        RestIndexForecasterAction restIndexForecasterAction = new RestIndexForecasterAction(settings, this.clusterService);
        RestForecasterJobAction restForecasterJobAction = new RestForecasterJobAction();
        RestGetForecasterAction restGetForecasterAction = new RestGetForecasterAction();
        RestDeleteForecasterAction deleteForecasterAction = new RestDeleteForecasterAction();
        RestSearchForecasterAction searchForecasterAction = new RestSearchForecasterAction();
        RestSearchForecasterInfoAction searchForecasterInfoAction = new RestSearchForecasterInfoAction();
        RestSearchTopForecastResultAction searchTopForecastResultAction = new RestSearchTopForecastResultAction();
        RestSearchForecastTasksAction searchForecastTasksAction = new RestSearchForecastTasksAction();
        RestStatsForecasterAction statsForecasterAction = new RestStatsForecasterAction(this.forecastStats, this.nodeFilter);
        RestRunOnceForecasterAction runOnceForecasterAction = new RestRunOnceForecasterAction();
        RestValidateForecasterAction validateForecasterAction = new RestValidateForecasterAction(settings, this.clusterService);
        RestForecasterSuggestAction suggestForecasterParamAction = new RestForecasterSuggestAction(settings, this.clusterService);
        ForecastJobProcessor forecastJobRunner = ForecastJobProcessor.getInstance();
        forecastJobRunner.setClient(this.client);
        forecastJobRunner.setThreadPool(this.threadPool);
        forecastJobRunner.registerSettings(settings);
        forecastJobRunner.setIndexManagement(this.forecastIndices);
        forecastJobRunner.setTaskManager(this.forecastTaskManager);
        forecastJobRunner.setNodeStateManager(this.stateManager);
        forecastJobRunner.setExecuteResultResponseRecorder(this.forecastResultResponseRecorder);
        forecastJobRunner.setIndexJobActionHandler(this.forecastIndexJobActionHandler);
        return ImmutableList.of((Object)((Object)restGetAnomalyDetectorAction), (Object)((Object)restIndexAnomalyDetectorAction), (Object)((Object)searchAnomalyDetectorAction), (Object)((Object)searchAnomalyResultAction), (Object)((Object)searchADTasksAction), (Object)((Object)deleteAnomalyDetectorAction), (Object)((Object)executeAnomalyDetectorAction), (Object)((Object)anomalyDetectorJobAction), (Object)((Object)statsAnomalyDetectorAction), (Object)((Object)searchAnomalyDetectorInfoAction), (Object)((Object)previewAnomalyDetectorAction), (Object)((Object)deleteAnomalyResultsAction), (Object[])new RestHandler[]{searchTopAnomalyResultAction, validateAnomalyDetectorAction, restIndexForecasterAction, restForecasterJobAction, restGetForecasterAction, deleteForecasterAction, searchForecasterAction, searchForecasterInfoAction, searchTopForecastResultAction, searchForecastTasksAction, statsForecasterAction, runOnceForecasterAction, validateForecasterAction, suggestForecasterParamAction});
    }

    private static Void initGson() {
        gson = new GsonBuilder().serializeSpecialFloatingPointValues().create();
        return null;
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.client = client;
        this.threadPool = threadPool;
        Settings settings = environment.settings();
        this.clientUtil = new ClientUtil(client);
        this.indexUtils = new IndexUtils(clusterService, indexNameExpressionResolver);
        this.nodeFilter = new DiscoveryNodeFilterer(clusterService);
        this.clusterService = clusterService;
        LinearUniformImputer imputer = new LinearUniformImputer(true);
        JvmService jvmService = new JvmService(environment.settings());
        RandomCutForestMapper rcfMapper = new RandomCutForestMapper();
        rcfMapper.setSaveExecutorContextEnabled(true);
        rcfMapper.setSaveTreeStateEnabled(true);
        rcfMapper.setPartialTreeStateEnabled(true);
        V1JsonToV3StateConverter converter = new V1JsonToV3StateConverter();
        CircuitBreakerService circuitBreakerService = new CircuitBreakerService(jvmService).init();
        long heapSizeBytes = JvmInfo.jvmInfo().getMem().getHeapMax().getBytes();
        this.serializeRCFBufferPool = AccessController.doPrivileged(new PrivilegedAction<GenericObjectPool<LinkedBuffer>>(){

            @Override
            public GenericObjectPool<LinkedBuffer> run() {
                return new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<LinkedBuffer>(){

                    public LinkedBuffer create() throws Exception {
                        return LinkedBuffer.allocate((int)512);
                    }

                    public PooledObject<LinkedBuffer> wrap(LinkedBuffer obj) {
                        return new DefaultPooledObject((Object)obj);
                    }
                });
            }
        });
        this.serializeRCFBufferPool.setMaxTotal(20);
        this.serializeRCFBufferPool.setMaxIdle(20);
        this.serializeRCFBufferPool.setMinIdle(0);
        this.serializeRCFBufferPool.setBlockWhenExhausted(false);
        this.serializeRCFBufferPool.setTimeBetweenEvictionRuns(TimeSeriesSettings.HOURLY_MAINTENANCE);
        this.stateManager = new NodeStateManager(client, xContentRegistry, settings, this.clientUtil, this.getClock(), TimeSeriesSettings.HOURLY_MAINTENANCE, clusterService, TimeSeriesSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, TimeSeriesSettings.BACKOFF_MINUTES);
        this.securityClientUtil = new SecurityClientUtil(this.stateManager, settings);
        SearchFeatureDao searchFeatureDao = new SearchFeatureDao(client, xContentRegistry, this.securityClientUtil, settings, clusterService, 256);
        FeatureManager featureManager = new FeatureManager(searchFeatureDao, imputer, 24, 512, 0.25, 2, 0.25, 300, threadPool);
        Random random = new Random(42L);
        ADEnabledSetting.getInstance().init(clusterService);
        ADNumericSetting.getInstance().init(clusterService);
        this.anomalyDetectionIndices = ThrowingSupplierWrapper.throwingSupplierWrapper(() -> new ADIndexManagement(client, clusterService, threadPool, settings, this.nodeFilter, TimeSeriesSettings.MAX_UPDATE_RETRY_TIMES, xContentRegistry)).get();
        double adModelMaxSizePercent = (Double)AnomalyDetectorSettings.AD_MODEL_MAX_SIZE_PERCENTAGE.get(settings);
        MemoryTracker adMemoryTracker = new MemoryTracker(jvmService, adModelMaxSizePercent, clusterService, circuitBreakerService);
        ADCheckpointDao adCheckpoint = new ADCheckpointDao(client, this.clientUtil, gson, rcfMapper, converter, new ThresholdedRandomCutForestMapper(), (Schema<ThresholdedRandomCutForestState>)AccessController.doPrivileged(() -> RuntimeSchema.getSchema(ThresholdedRandomCutForestState.class)), HybridThresholdingModel.class, this.anomalyDetectionIndices, 30000000, this.serializeRCFBufferPool, 512, 0.0050000000000000044, this.getClock());
        ADCacheProvider adCacheProvider = new ADCacheProvider();
        CheckPointMaintainRequestAdapter adAdapter = new CheckPointMaintainRequestAdapter(adCheckpoint, ".opendistro-anomaly-checkpoints", AnomalyDetectorSettings.AD_CHECKPOINT_SAVING_FREQ, this.getClock(), clusterService, settings, adCacheProvider);
        ADCheckpointWriteWorker adCheckpointWriteQueue = new ADCheckpointWriteWorker(heapSizeBytes, TimeSeriesSettings.CHECKPOINT_WRITE_QUEUE_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, adCheckpoint, ".opendistro-anomaly-checkpoints", TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, TimeSeriesSettings.HOURLY_MAINTENANCE);
        ADCheckpointMaintainWorker adCheckpointMaintainQueue = new ADCheckpointMaintainWorker(heapSizeBytes, TimeSeriesSettings.CHECKPOINT_MAINTAIN_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, adCheckpointWriteQueue, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, adAdapter::convert);
        ADPriorityCache adPriorityCache = new ADPriorityCache(adCheckpoint, (Integer)AnomalyDetectorSettings.AD_DEDICATED_CACHE_SIZE.get(settings), AnomalyDetectorSettings.AD_CHECKPOINT_TTL, 1000000, adMemoryTracker, 50, this.getClock(), clusterService, TimeSeriesSettings.HOURLY_MAINTENANCE, threadPool, 10000, settings, AnomalyDetectorSettings.AD_CHECKPOINT_SAVING_FREQ, adCheckpointWriteQueue, adCheckpointMaintainQueue);
        adCacheProvider.set(adPriorityCache);
        ADColdStart adEntityColdStarter = new ADColdStart(this.getClock(), threadPool, this.stateManager, 256, 50, 32, 64, 24, searchFeatureDao, 0.995, featureManager, TimeSeriesSettings.HOURLY_MAINTENANCE, adCheckpointWriteQueue, TimeSeriesSettings.MAX_COLD_START_ROUNDS, (int)((TimeValue)AnomalyDetectorSettings.AD_COOLDOWN_MINUTES.get(settings)).getMinutes());
        ADModelManager adModelManager = new ADModelManager(adCheckpoint, this.getClock(), 50, 256, 32, 0.995, 400, TimeSeriesSettings.HOURLY_MAINTENANCE, AnomalyDetectorSettings.AD_CHECKPOINT_SAVING_FREQ, adEntityColdStarter, featureManager, adMemoryTracker, settings, clusterService);
        ADIndexMemoryPressureAwareResultHandler adIndexMemoryPressureAwareResultHandler = new ADIndexMemoryPressureAwareResultHandler(client, this.anomalyDetectionIndices, clusterService);
        ADResultWriteWorker adResultWriteQueue = new ADResultWriteWorker(heapSizeBytes, TimeSeriesSettings.RESULT_WRITE_QUEUE_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, adIndexMemoryPressureAwareResultHandler, xContentRegistry, this.stateManager, TimeSeriesSettings.HOURLY_MAINTENANCE);
        ADSaveResultStrategy adSaveResultStrategy = new ADSaveResultStrategy(this.anomalyDetectionIndices.getSchemaVersion(ADIndex.RESULT), adResultWriteQueue);
        ADColdStartWorker adColdstartQueue = new ADColdStartWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_ENTITY_COLD_START_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, adEntityColdStarter, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, adPriorityCache, adModelManager, adSaveResultStrategy);
        ImmutableMap adStatsMap = ImmutableMap.builder().put((Object)StatNames.AD_EXECUTE_REQUEST_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_EXECUTE_FAIL_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_HC_EXECUTE_REQUEST_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_HC_EXECUTE_FAIL_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.ANOMALY_RESULTS_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-results"))).put((Object)StatNames.AD_MODELS_CHECKPOINT_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-checkpoints"))).put((Object)StatNames.ANOMALY_DETECTION_STATE_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detection-state"))).put((Object)StatNames.DETECTOR_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.SINGLE_STREAM_DETECTOR_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.HC_DETECTOR_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.AD_EXECUTING_BATCH_TASK_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_CANCELED_BATCH_TASK_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_TOTAL_BATCH_TASK_EXECUTION_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_BATCH_TASK_FAILURE_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.AD_MODEL_CORRUTPION_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.MODEL_INFORMATION.getName(), new TimeSeriesStat<List<Map<String, Object>>>(false, new ADModelsOnNodeSupplier(adModelManager, adCacheProvider, settings, clusterService))).put((Object)StatNames.CONFIG_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detectors"))).put((Object)StatNames.JOB_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detector-jobs"))).put((Object)StatNames.MODEL_COUNT.getName(), new TimeSeriesStat<Long>(false, new ADModelsOnNodeCountSupplier(adModelManager, adCacheProvider))).build();
        this.adStats = new ADStats((Map<String, TimeSeriesStat<?>>)adStatsMap);
        ADRealTimeInferencer adInferencer = new ADRealTimeInferencer(adModelManager, this.adStats, adCheckpoint, adColdstartQueue, adSaveResultStrategy, adCacheProvider, threadPool, this.getClock());
        ADCheckpointReadWorker adCheckpointReadQueue = new ADCheckpointReadWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, adModelManager, adCheckpoint, adColdstartQueue, this.stateManager, adCacheProvider, TimeSeriesSettings.HOURLY_MAINTENANCE, adCheckpointWriteQueue, adInferencer);
        ADColdEntityWorker adColdEntityQueue = new ADColdEntityWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, AnomalyDetectorSettings.AD_COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, adCheckpointReadQueue, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager);
        ADDataMigrator adDataMigrator = new ADDataMigrator(client, clusterService, xContentRegistry, this.anomalyDetectionIndices);
        this.anomalyDetectorRunner = new AnomalyDetectorRunner(adModelManager, featureManager, 1000);
        ADTaskCacheManager adTaskCacheManager = new ADTaskCacheManager(settings, clusterService, adMemoryTracker);
        ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement> anomalyResultBulkIndexHandler = new ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement>(client, settings, threadPool, ".opendistro-anomaly-results", this.anomalyDetectionIndices, this.clientUtil, this.indexUtils, clusterService, AnomalyDetectorSettings.AD_BACKOFF_INITIAL_DELAY, AnomalyDetectorSettings.AD_MAX_RETRY_FOR_BACKOFF);
        ADSearchHandler adSearchHandler = new ADSearchHandler(settings, clusterService, client);
        ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement> anomalyResultHandler = new ResultBulkIndexingHandler<AnomalyResult, ADIndex, ADIndexManagement>(client, settings, threadPool, ".opendistro-anomaly-results", this.anomalyDetectionIndices, this.clientUtil, this.indexUtils, clusterService, AnomalyDetectorSettings.AD_BACKOFF_INITIAL_DELAY, AnomalyDetectorSettings.AD_MAX_RETRY_FOR_BACKOFF);
        HashRing hashRing = new HashRing(this.nodeFilter, this.getClock(), settings, client, clusterService, adDataMigrator, adModelManager);
        ADTaskProfileRunner adTaskProfileRunner = new ADTaskProfileRunner(hashRing, client);
        this.adTaskManager = new ADTaskManager(settings, clusterService, client, xContentRegistry, this.anomalyDetectionIndices, this.nodeFilter, hashRing, adTaskCacheManager, threadPool, this.stateManager, adTaskProfileRunner);
        this.adBatchTaskRunner = new ADBatchTaskRunner(settings, threadPool, clusterService, client, this.securityClientUtil, circuitBreakerService, featureManager, this.adTaskManager, this.anomalyDetectionIndices, this.adStats, anomalyResultBulkIndexHandler, adTaskCacheManager, searchFeatureDao, hashRing, adModelManager);
        this.adResultResponseRecorder = new ExecuteADResultResponseRecorder(this.anomalyDetectionIndices, anomalyResultHandler, this.adTaskManager, this.nodeFilter, threadPool, client, this.stateManager, adTaskCacheManager, 32);
        this.adIndexJobActionHandler = new ADIndexJobActionHandler(client, this.anomalyDetectionIndices, xContentRegistry, this.adTaskManager, this.adResultResponseRecorder, this.stateManager, settings);
        ForecastEnabledSetting.getInstance().init(clusterService);
        ForecastNumericSetting.getInstance().init(clusterService);
        this.forecastIndices = ThrowingSupplierWrapper.throwingSupplierWrapper(() -> new ForecastIndexManagement(client, clusterService, threadPool, settings, this.nodeFilter, ForecastSettings.FORECAST_MAX_UPDATE_RETRY_TIMES, xContentRegistry)).get();
        double forecastModelMaxSizePercent = (Double)ForecastSettings.FORECAST_MODEL_MAX_SIZE_PERCENTAGE.get(settings);
        MemoryTracker forecastMemoryTracker = new MemoryTracker(jvmService, forecastModelMaxSizePercent, clusterService, circuitBreakerService);
        ForecastCheckpointDao forecastCheckpoint = new ForecastCheckpointDao(client, this.clientUtil, gson, 30000000, this.serializeRCFBufferPool, 512, this.forecastIndices, new RCFCasterMapper(), (Schema<RCFCasterState>)AccessController.doPrivileged(() -> RuntimeSchema.getSchema(RCFCasterState.class)), this.getClock());
        ForecastCacheProvider forecastCacheProvider = new ForecastCacheProvider();
        CheckPointMaintainRequestAdapter forecastAdapter = new CheckPointMaintainRequestAdapter(forecastCheckpoint, ForecastIndex.CHECKPOINT.getIndexName(), ForecastSettings.FORECAST_CHECKPOINT_SAVING_FREQ, this.getClock(), clusterService, settings, forecastCacheProvider);
        ForecastCheckpointWriteWorker forecastCheckpointWriteQueue = new ForecastCheckpointWriteWorker(heapSizeBytes, TimeSeriesSettings.CHECKPOINT_WRITE_QUEUE_SIZE_IN_BYTES, ForecastSettings.FORECAST_CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, forecastCheckpoint, ForecastIndex.CHECKPOINT.getIndexName(), TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, TimeSeriesSettings.HOURLY_MAINTENANCE);
        ForecastCheckpointMaintainWorker forecastCheckpointMaintainQueue = new ForecastCheckpointMaintainWorker(heapSizeBytes, TimeSeriesSettings.CHECKPOINT_MAINTAIN_REQUEST_SIZE_IN_BYTES, ForecastSettings.FORECAST_CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, forecastCheckpointWriteQueue, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, forecastAdapter::convert);
        ForecastPriorityCache forecastPriorityCache = new ForecastPriorityCache(forecastCheckpoint, (Integer)ForecastSettings.FORECAST_DEDICATED_CACHE_SIZE.get(settings), AnomalyDetectorSettings.AD_CHECKPOINT_TTL, 1000000, adMemoryTracker, 50, this.getClock(), clusterService, TimeSeriesSettings.HOURLY_MAINTENANCE, threadPool, FORECAST_THREAD_POOL_NAME, 10000, settings, ForecastSettings.FORECAST_CHECKPOINT_SAVING_FREQ, forecastCheckpointWriteQueue, forecastCheckpointMaintainQueue);
        forecastCacheProvider.set(forecastPriorityCache);
        ForecastColdStart forecastColdStarter = new ForecastColdStart(this.getClock(), threadPool, this.stateManager, 256, 50, 32, searchFeatureDao, 0.995, featureManager, TimeSeriesSettings.HOURLY_MAINTENANCE, forecastCheckpointWriteQueue, (int)((TimeValue)AnomalyDetectorSettings.AD_COOLDOWN_MINUTES.get(settings)).getMinutes(), -1L, -1, TimeSeriesSettings.MAX_COLD_START_ROUNDS);
        ForecastModelManager forecastModelManager = new ForecastModelManager(forecastCheckpoint, this.getClock(), 50, 256, 32, forecastColdStarter, forecastMemoryTracker, featureManager);
        ForecastIndexMemoryPressureAwareResultHandler forecastIndexMemoryPressureAwareResultHandler = new ForecastIndexMemoryPressureAwareResultHandler(client, this.forecastIndices, clusterService);
        ForecastResultWriteWorker forecastResultWriteQueue = new ForecastResultWriteWorker(heapSizeBytes, TimeSeriesSettings.RESULT_WRITE_QUEUE_SIZE_IN_BYTES, ForecastSettings.FORECAST_RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, forecastIndexMemoryPressureAwareResultHandler, xContentRegistry, this.stateManager, TimeSeriesSettings.HOURLY_MAINTENANCE);
        ForecastSaveResultStrategy forecastSaveResultStrategy = new ForecastSaveResultStrategy(this.forecastIndices.getSchemaVersion(ForecastIndex.RESULT), forecastResultWriteQueue);
        ForecastColdStartWorker forecastColdstartQueue = new ForecastColdStartWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, ForecastSettings.FORECAST_COLD_START_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, forecastColdStarter, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager, forecastPriorityCache, forecastModelManager, forecastSaveResultStrategy);
        ImmutableMap forecastStatsMap = ImmutableMap.builder().put((Object)StatNames.FORECAST_EXECUTE_REQUEST_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.FORECAST_EXECUTE_FAIL_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.FORECAST_HC_EXECUTE_REQUEST_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.FORECAST_HC_EXECUTE_FAIL_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.FORECAST_RESULTS_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ForecastIndex.RESULT.getIndexName()))).put((Object)StatNames.FORECAST_MODELS_CHECKPOINT_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ForecastIndex.CHECKPOINT.getIndexName()))).put((Object)StatNames.FORECAST_STATE_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ForecastIndex.STATE.getIndexName()))).put((Object)StatNames.FORECASTER_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.SINGLE_STREAM_FORECASTER_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.HC_FORECASTER_COUNT.getName(), new TimeSeriesStat<Long>(true, new SettableSupplier())).put((Object)StatNames.FORECAST_MODEL_CORRUTPION_COUNT.getName(), new TimeSeriesStat<Long>(false, new CounterSupplier())).put((Object)StatNames.MODEL_INFORMATION.getName(), new TimeSeriesStat<List<Map<String, Object>>>(false, new ForecastModelsOnNodeSupplier(forecastCacheProvider, settings, clusterService))).put((Object)StatNames.CONFIG_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detectors"))).put((Object)StatNames.JOB_INDEX_STATUS.getName(), new TimeSeriesStat<String>(true, new IndexStatusSupplier(this.indexUtils, ".opendistro-anomaly-detector-jobs"))).put((Object)StatNames.MODEL_COUNT.getName(), new TimeSeriesStat<Long>(false, new ForecastModelsOnNodeCountSupplier(forecastCacheProvider))).build();
        this.forecastStats = new ForecastStats((Map<String, TimeSeriesStat<?>>)forecastStatsMap);
        ForecastRealTimeInferencer forecastInferencer = new ForecastRealTimeInferencer(forecastModelManager, this.forecastStats, forecastCheckpoint, forecastColdstartQueue, forecastSaveResultStrategy, forecastCacheProvider, threadPool, this.getClock());
        ForecastCheckpointReadWorker forecastCheckpointReadQueue = new ForecastCheckpointReadWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, ForecastSettings.FORECAST_CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, TimeSeriesSettings.QUEUE_MAINTENANCE, forecastModelManager, forecastCheckpoint, forecastColdstartQueue, this.stateManager, forecastCacheProvider, TimeSeriesSettings.HOURLY_MAINTENANCE, forecastCheckpointWriteQueue, forecastInferencer);
        ForecastColdEntityWorker forecastColdEntityQueue = new ForecastColdEntityWorker(heapSizeBytes, TimeSeriesSettings.FEATURE_REQUEST_SIZE_IN_BYTES, ForecastSettings.FORECAST_COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, clusterService, random, circuitBreakerService, threadPool, settings, 0.5f, this.getClock(), 0.1f, 0.3f, 10000, forecastCheckpointReadQueue, TimeSeriesSettings.HOURLY_MAINTENANCE, this.stateManager);
        TaskCacheManager forecastTaskCacheManager = new TaskCacheManager(settings, clusterService);
        this.forecastTaskManager = new ForecastTaskManager(forecastTaskCacheManager, client, xContentRegistry, this.forecastIndices, clusterService, settings, threadPool, this.stateManager);
        ResultBulkIndexingHandler<ForecastResult, ForecastIndex, ForecastIndexManagement> forecastResultHandler = new ResultBulkIndexingHandler<ForecastResult, ForecastIndex, ForecastIndexManagement>(client, settings, threadPool, ForecastIndex.RESULT.getIndexName(), this.forecastIndices, this.clientUtil, this.indexUtils, clusterService, ForecastSettings.FORECAST_BACKOFF_INITIAL_DELAY, ForecastSettings.FORECAST_MAX_RETRY_FOR_BACKOFF);
        ForecastSearchHandler forecastSearchHandler = new ForecastSearchHandler(settings, clusterService, client);
        this.forecastResultResponseRecorder = new ExecuteForecastResultResponseRecorder(this.forecastIndices, forecastResultHandler, this.forecastTaskManager, this.nodeFilter, threadPool, client, this.stateManager, forecastTaskCacheManager, 32);
        this.forecastIndexJobActionHandler = new ForecastIndexJobActionHandler(client, this.forecastIndices, xContentRegistry, this.forecastTaskManager, this.forecastResultResponseRecorder, this.stateManager, settings);
        return ImmutableList.of((Object)searchFeatureDao, (Object)imputer, (Object)gson, (Object)jvmService, (Object)hashRing, (Object)featureManager, (Object)this.stateManager, (Object)new ClusterEventListener(clusterService, hashRing), (Object)circuitBreakerService, (Object)new ClusterManagerEventListener(clusterService, threadPool, client, this.getClock(), this.clientUtil, this.nodeFilter, AnomalyDetectorSettings.AD_CHECKPOINT_TTL, ForecastSettings.FORECAST_CHECKPOINT_TTL, settings), (Object)this.nodeFilter, (Object)this.anomalyDetectionIndices, (Object[])new Object[]{this.anomalyDetectorRunner, adModelManager, this.adStats, adIndexMemoryPressureAwareResultHandler, adCheckpoint, adCacheProvider, this.adTaskManager, this.adBatchTaskRunner, adSearchHandler, adColdstartQueue, adResultWriteQueue, adCheckpointReadQueue, adCheckpointWriteQueue, adColdEntityQueue, adEntityColdStarter, adTaskCacheManager, this.adResultResponseRecorder, this.adIndexJobActionHandler, adSaveResultStrategy, new ADTaskProfileRunner(hashRing, client), adInferencer, this.forecastIndices, this.forecastStats, forecastModelManager, forecastIndexMemoryPressureAwareResultHandler, forecastCheckpoint, forecastCacheProvider, forecastColdstartQueue, forecastResultWriteQueue, forecastCheckpointReadQueue, forecastCheckpointWriteQueue, forecastColdEntityQueue, forecastColdStarter, this.forecastTaskManager, forecastSearchHandler, this.forecastIndexJobActionHandler, forecastTaskCacheManager, forecastSaveResultStrategy, new ForecastTaskProfileRunner(), forecastInferencer});
    }

    protected Clock getClock() {
        return Clock.systemUTC();
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settings) {
        return ImmutableList.of((Object)new ScalingExecutorBuilder(AD_THREAD_POOL_NAME, 1, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) / 2), TimeValue.timeValueMinutes((long)10L), "opensearch.ad.ad-threadpool"), (Object)new ScalingExecutorBuilder(AD_BATCH_TASK_THREAD_POOL_NAME, 1, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) / 8), TimeValue.timeValueMinutes((long)10L), "opensearch.ad.ad-batch-task-threadpool"), (Object)new ScalingExecutorBuilder(FORECAST_THREAD_POOL_NAME, 1, Math.max(1, OpenSearchExecutors.allocatedProcessors((Settings)settings) * 3 / 4), TimeValue.timeValueMinutes((long)10L), "opensearch.forecast.forecast-threadpool"));
    }

    public List<Setting<?>> getSettings() {
        List<Setting<?>> adEnabledSetting = ADEnabledSetting.getInstance().getSettings();
        List<Setting<?>> adNumericSetting = ADNumericSetting.getInstance().getSettings();
        List<Setting<?>> forecastEnabledSetting = ForecastEnabledSetting.getInstance().getSettings();
        List<Setting<?>> forecastNumericSetting = ForecastNumericSetting.getInstance().getSettings();
        List<Setting<?>> timeSeriesEnabledSetting = TimeSeriesEnabledSetting.getInstance().getSettings();
        ImmutableList systemSetting = ImmutableList.of(LegacyOpenDistroAnomalyDetectorSettings.MAX_CACHE_MISS_HANDLING_PER_SECOND, AnomalyDetectorSettings.AD_DEDICATED_CACHE_SIZE, LegacyOpenDistroAnomalyDetectorSettings.DETECTION_INTERVAL, LegacyOpenDistroAnomalyDetectorSettings.DETECTION_WINDOW_DELAY, LegacyOpenDistroAnomalyDetectorSettings.MAX_ANOMALY_FEATURES, AnomalyDetectorSettings.DETECTION_INTERVAL, AnomalyDetectorSettings.DETECTION_WINDOW_DELAY, AnomalyDetectorSettings.MAX_ANOMALY_FEATURES, LegacyOpenDistroAnomalyDetectorSettings.REQUEST_TIMEOUT, LegacyOpenDistroAnomalyDetectorSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, LegacyOpenDistroAnomalyDetectorSettings.COOLDOWN_MINUTES, LegacyOpenDistroAnomalyDetectorSettings.BACKOFF_MINUTES, (Object[])new Setting[]{LegacyOpenDistroAnomalyDetectorSettings.BACKOFF_INITIAL_DELAY, LegacyOpenDistroAnomalyDetectorSettings.MAX_RETRY_FOR_BACKOFF, AnomalyDetectorSettings.AD_REQUEST_TIMEOUT, AnomalyDetectorSettings.AD_MAX_RETRY_FOR_UNRESPONSIVE_NODE, AnomalyDetectorSettings.AD_COOLDOWN_MINUTES, AnomalyDetectorSettings.AD_BACKOFF_MINUTES, AnomalyDetectorSettings.AD_BACKOFF_INITIAL_DELAY, AnomalyDetectorSettings.AD_MAX_RETRY_FOR_BACKOFF, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS, LegacyOpenDistroAnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, AnomalyDetectorSettings.AD_RESULT_HISTORY_ROLLOVER_PERIOD, AnomalyDetectorSettings.AD_RESULT_HISTORY_MAX_DOCS_PER_SHARD, AnomalyDetectorSettings.AD_RESULT_HISTORY_RETENTION_PERIOD, LegacyOpenDistroAnomalyDetectorSettings.MODEL_MAX_SIZE_PERCENTAGE, LegacyOpenDistroAnomalyDetectorSettings.MAX_SINGLE_ENTITY_ANOMALY_DETECTORS, LegacyOpenDistroAnomalyDetectorSettings.MAX_MULTI_ENTITY_ANOMALY_DETECTORS, LegacyOpenDistroAnomalyDetectorSettings.INDEX_PRESSURE_SOFT_LIMIT, LegacyOpenDistroAnomalyDetectorSettings.MAX_PRIMARY_SHARDS, AnomalyDetectorSettings.AD_MODEL_MAX_SIZE_PERCENTAGE, AnomalyDetectorSettings.AD_MAX_SINGLE_ENTITY_ANOMALY_DETECTORS, AnomalyDetectorSettings.AD_MAX_HC_ANOMALY_DETECTORS, AnomalyDetectorSettings.AD_INDEX_PRESSURE_SOFT_LIMIT, AnomalyDetectorSettings.AD_INDEX_PRESSURE_HARD_LIMIT, AnomalyDetectorSettings.AD_MAX_PRIMARY_SHARDS, LegacyOpenDistroAnomalyDetectorSettings.AD_FILTER_BY_BACKEND_ROLES, AnomalyDetectorSettings.AD_FILTER_BY_BACKEND_ROLES, LegacyOpenDistroAnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, LegacyOpenDistroAnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS, LegacyOpenDistroAnomalyDetectorSettings.MAX_OLD_AD_TASK_DOCS_PER_DETECTOR, LegacyOpenDistroAnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE, AnomalyDetectorSettings.MAX_BATCH_TASK_PER_NODE, AnomalyDetectorSettings.BATCH_TASK_PIECE_INTERVAL_SECONDS, AnomalyDetectorSettings.MAX_OLD_AD_TASK_DOCS_PER_DETECTOR, AnomalyDetectorSettings.BATCH_TASK_PIECE_SIZE, AnomalyDetectorSettings.MAX_TOP_ENTITIES_FOR_HISTORICAL_ANALYSIS, AnomalyDetectorSettings.MAX_RUNNING_ENTITIES_PER_DETECTOR_FOR_HISTORICAL_ANALYSIS, AnomalyDetectorSettings.MAX_CACHED_DELETED_TASKS, AnomalyDetectorSettings.AD_CHECKPOINT_READ_QUEUE_CONCURRENCY, AnomalyDetectorSettings.AD_CHECKPOINT_WRITE_QUEUE_CONCURRENCY, AnomalyDetectorSettings.AD_ENTITY_COLD_START_QUEUE_CONCURRENCY, AnomalyDetectorSettings.AD_RESULT_WRITE_QUEUE_CONCURRENCY, AnomalyDetectorSettings.AD_CHECKPOINT_READ_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.AD_CHECKPOINT_WRITE_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.AD_RESULT_WRITE_QUEUE_BATCH_SIZE, AnomalyDetectorSettings.AD_COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_ENTITY_COLD_START_QUEUE_MAX_HEAP_PERCENT, AnomalyDetectorSettings.AD_EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_MILLISECS, AnomalyDetectorSettings.AD_EXPECTED_CHECKPOINT_MAINTAIN_TIME_IN_MILLISECS, AnomalyDetectorSettings.AD_CHECKPOINT_SAVING_FREQ, AnomalyDetectorSettings.AD_CHECKPOINT_TTL, LegacyOpenDistroAnomalyDetectorSettings.MAX_ENTITIES_PER_QUERY, LegacyOpenDistroAnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW, AnomalyDetectorSettings.AD_MAX_ENTITIES_PER_QUERY, AnomalyDetectorSettings.MAX_ENTITIES_FOR_PREVIEW, AnomalyDetectorSettings.MAX_CONCURRENT_PREVIEW, AnomalyDetectorSettings.AD_PAGE_SIZE, AnomalyDetectorSettings.DELETE_AD_RESULT_WHEN_DELETE_DETECTOR, AnomalyDetectorSettings.AD_MAX_MODEL_SIZE_PER_NODE, ForecastSettings.FORECAST_DEDICATED_CACHE_SIZE, ForecastSettings.FORECAST_INTERVAL, ForecastSettings.FORECAST_WINDOW_DELAY, ForecastSettings.FORECAST_BACKOFF_MINUTES, ForecastSettings.FORECAST_BACKOFF_INITIAL_DELAY, ForecastSettings.FORECAST_MAX_RETRY_FOR_BACKOFF, ForecastSettings.FORECAST_RESULT_HISTORY_MAX_DOCS_PER_SHARD, ForecastSettings.FORECAST_RESULT_HISTORY_RETENTION_PERIOD, ForecastSettings.FORECAST_RESULT_HISTORY_ROLLOVER_PERIOD, ForecastSettings.FORECAST_MODEL_MAX_SIZE_PERCENTAGE, ForecastSettings.FORECAST_INDEX_PRESSURE_SOFT_LIMIT, ForecastSettings.FORECAST_INDEX_PRESSURE_HARD_LIMIT, ForecastSettings.FORECAST_MAX_PRIMARY_SHARDS, ForecastSettings.FORECAST_REQUEST_TIMEOUT, ForecastSettings.MAX_SINGLE_STREAM_FORECASTERS, ForecastSettings.MAX_HC_FORECASTERS, ForecastSettings.FORECAST_FILTER_BY_BACKEND_ROLES, ForecastSettings.MAX_OLD_TASK_DOCS_PER_FORECASTER, ForecastSettings.FORECAST_CHECKPOINT_READ_QUEUE_CONCURRENCY, ForecastSettings.FORECAST_CHECKPOINT_WRITE_QUEUE_CONCURRENCY, ForecastSettings.FORECAST_COLD_START_QUEUE_CONCURRENCY, ForecastSettings.FORECAST_RESULT_WRITE_QUEUE_CONCURRENCY, ForecastSettings.FORECAST_CHECKPOINT_READ_QUEUE_BATCH_SIZE, ForecastSettings.FORECAST_CHECKPOINT_WRITE_QUEUE_BATCH_SIZE, ForecastSettings.FORECAST_RESULT_WRITE_QUEUE_BATCH_SIZE, ForecastSettings.FORECAST_COLD_ENTITY_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_CHECKPOINT_READ_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_CHECKPOINT_WRITE_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_RESULT_WRITE_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_CHECKPOINT_MAINTAIN_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_COLD_START_QUEUE_MAX_HEAP_PERCENT, ForecastSettings.FORECAST_EXPECTED_COLD_ENTITY_EXECUTION_TIME_IN_MILLISECS, ForecastSettings.FORECAST_EXPECTED_CHECKPOINT_MAINTAIN_TIME_IN_MILLISECS, ForecastSettings.FORECAST_CHECKPOINT_SAVING_FREQ, ForecastSettings.FORECAST_CHECKPOINT_TTL, ForecastSettings.FORECAST_MAX_ENTITIES_PER_INTERVAL, ForecastSettings.FORECAST_PAGE_SIZE, ForecastSettings.FORECAST_MAX_MODEL_SIZE_PER_NODE, ForecastSettings.DELETE_FORECAST_RESULT_WHEN_DELETE_FORECASTER, TimeSeriesSettings.MAX_RETRY_FOR_UNRESPONSIVE_NODE, TimeSeriesSettings.BACKOFF_MINUTES, TimeSeriesSettings.COOLDOWN_MINUTES, TimeSeriesSettings.MAX_CACHED_DELETED_TASKS});
        return Collections.unmodifiableList(Stream.of(adEnabledSetting.stream(), forecastEnabledSetting.stream(), timeSeriesEnabledSetting.stream(), systemSetting.stream(), adNumericSetting.stream(), forecastNumericSetting.stream()).reduce(Stream::concat).orElseGet(Stream::empty).collect(Collectors.toList()));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return ImmutableList.of((Object)AnomalyDetector.XCONTENT_REGISTRY, (Object)AnomalyResult.XCONTENT_REGISTRY, (Object)DetectorInternalState.XCONTENT_REGISTRY, (Object)Job.XCONTENT_REGISTRY, (Object)Forecaster.XCONTENT_REGISTRY);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)DeleteADModelAction.INSTANCE, DeleteADModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopDetectorAction.INSTANCE, StopDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RCFResultAction.INSTANCE, RCFResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ThresholdResultAction.INSTANCE, ThresholdResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AnomalyResultAction.INSTANCE, AnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)CronAction.INSTANCE, CronTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADStatsNodesAction.INSTANCE, ADStatsNodesTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADProfileAction.INSTANCE, ADProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)RCFPollingAction.INSTANCE, RCFPollingTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyDetectorAction.INSTANCE, SearchAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyResultAction.INSTANCE, SearchAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchADTasksAction.INSTANCE, SearchADTasksTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StatsAnomalyDetectorAction.INSTANCE, StatsAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAnomalyDetectorAction.INSTANCE, DeleteAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetAnomalyDetectorAction.INSTANCE, GetAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexAnomalyDetectorAction.INSTANCE, IndexAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)AnomalyDetectorJobAction.INSTANCE, AnomalyDetectorJobTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADResultBulkAction.INSTANCE, ADResultBulkTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EntityADResultAction.INSTANCE, EntityADResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADEntityProfileAction.INSTANCE, ADEntityProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchAnomalyDetectorInfoAction.INSTANCE, SearchAnomalyDetectorInfoTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)PreviewAnomalyDetectorAction.INSTANCE, PreviewAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADBatchAnomalyResultAction.INSTANCE, ADBatchAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADBatchTaskRemoteExecutionAction.INSTANCE, ADBatchTaskRemoteExecutionTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADTaskProfileAction.INSTANCE, ADTaskProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADCancelTaskAction.INSTANCE, ADCancelTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForwardADTaskAction.INSTANCE, ForwardADTaskTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteAnomalyResultsAction.INSTANCE, DeleteAnomalyResultsTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchTopAnomalyResultAction.INSTANCE, SearchTopAnomalyResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateAnomalyDetectorAction.INSTANCE, ValidateAnomalyDetectorTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADSingleStreamResultAction.INSTANCE, ADSingleStreamResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ADHCImputeAction.INSTANCE, ADHCImputeTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)IndexForecasterAction.INSTANCE, IndexForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastResultAction.INSTANCE, ForecastResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)EntityForecastResultAction.INSTANCE, EntityForecastResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastResultBulkAction.INSTANCE, ForecastResultBulkTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastSingleStreamResultAction.INSTANCE, ForecastSingleStreamResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecasterJobAction.INSTANCE, ForecasterJobTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StopForecasterAction.INSTANCE, StopForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteForecastModelAction.INSTANCE, DeleteForecastModelTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)GetForecasterAction.INSTANCE, GetForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)DeleteForecasterAction.INSTANCE, DeleteForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchForecasterAction.INSTANCE, SearchForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchForecasterInfoAction.INSTANCE, SearchForecasterInfoTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchTopForecastResultAction.INSTANCE, SearchTopForecastResultTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastEntityProfileAction.INSTANCE, ForecastEntityProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastProfileAction.INSTANCE, ForecastProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SearchForecastTasksAction.INSTANCE, SearchForecastTasksTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)StatsForecasterAction.INSTANCE, StatsForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastStatsNodesAction.INSTANCE, ForecastStatsNodesTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastRunOnceAction.INSTANCE, ForecastRunOnceTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ForecastRunOnceProfileAction.INSTANCE, ForecastRunOnceProfileTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)ValidateForecasterAction.INSTANCE, ValidateForecasterTransportAction.class, new Class[0]), new ActionPlugin.ActionHandler((ActionType)SuggestForecasterParamAction.INSTANCE, SuggestForecasterParamTransportAction.class, new Class[0]));
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        ArrayList<SystemIndexDescriptor> systemIndexDescriptors = new ArrayList<SystemIndexDescriptor>();
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opendistro-anomaly-detectors", "Time Series Analytics config index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opendistro-anomaly-results*", "AD result index pattern"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opendistro-anomaly-checkpoints", "AD Checkpoints index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opendistro-anomaly-detection-state", "AD State index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opensearch-forecast-checkpoints", "Forecast Checkpoints index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opensearch-forecast-state", "Forecast state index"));
        systemIndexDescriptors.add(new SystemIndexDescriptor(".opendistro-anomaly-detector-jobs", "Time Series Analytics job index"));
        return systemIndexDescriptors;
    }

    public String getJobType() {
        return TIME_SERIES_JOB_TYPE;
    }

    public String getJobIndex() {
        return ".opendistro-anomaly-detector-jobs";
    }

    public ScheduledJobRunner getJobRunner() {
        return JobRunner.getJobRunnerInstance();
    }

    public ScheduledJobParser getJobParser() {
        return (parser, id, jobDocVersion) -> {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            return Job.parse(parser);
        };
    }

    public void close() {
        if (this.serializeRCFBufferPool != null) {
            try {
                AccessController.doPrivileged(() -> {
                    this.serializeRCFBufferPool.clear();
                    this.serializeRCFBufferPool.close();
                    return null;
                });
                this.serializeRCFBufferPool = null;
            }
            catch (Exception e) {
                LOG.error("Failed to shut down object Pool", (Throwable)e);
            }
        }
    }

    static {
        SpecialPermission.check();
        AccessController.doPrivileged(TimeSeriesAnalyticsPlugin::initGson);
    }
}

