/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.h3;

import org.opensearch.geospatial.h3.BaseCells;
import org.opensearch.geospatial.h3.CellBoundary;
import org.opensearch.geospatial.h3.Constants;
import org.opensearch.geospatial.h3.CoordIJK;
import org.opensearch.geospatial.h3.H3Index;
import org.opensearch.geospatial.h3.LatLng;
import org.opensearch.geospatial.h3.Vec2d;

final class FaceIJK {
    private static final int IJ = 1;
    private static final int KI = 2;
    private static final int JK = 3;
    private static final int[] maxDimByCIIres = new int[]{2, -1, 14, -1, 98, -1, 686, -1, 4802, -1, 33614, -1, 235298, -1, 1647086, -1, 11529602};
    private static final int[] unitScaleByCIIres = new int[]{1, -1, 7, -1, 49, -1, 343, -1, 2401, -1, 16807, -1, 117649, -1, 823543, -1, 5764801};
    private static final int[][] adjacentFaceDir = new int[][]{{0, 2, -1, -1, 1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 1, 0, 2, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {2, -1, -1, 1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1}, {3, -1, -1, -1, -1, 0, -1, -1, -1, -1, 1, -1, -1, -1, 2, -1, -1, -1, -1, -1}, {-1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, 3, -1, -1, -1, -1, 0, -1, -1, -1, 2, 1, -1, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, 1, 2, -1, -1, -1, 0, -1, -1, -1, -1, 3, -1}, {-1, -1, -1, -1, -1, 2, -1, -1, -1, 1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 3}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, -1, 0, 1, -1, -1, 2}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1, -1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, -1, -1, -1, 2, 0, 1}, {-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 3, 1, -1, -1, 2, 0}};
    private static final int MAX_FACE_COORD = 2;
    private static final FaceOrientIJK[][] faceNeighbors = new FaceOrientIJK[][]{{new FaceOrientIJK(0, 0, 0, 0, 0), new FaceOrientIJK(4, 2, 0, 2, 1), new FaceOrientIJK(1, 2, 2, 0, 5), new FaceOrientIJK(5, 0, 2, 2, 3)}, {new FaceOrientIJK(1, 0, 0, 0, 0), new FaceOrientIJK(0, 2, 0, 2, 1), new FaceOrientIJK(2, 2, 2, 0, 5), new FaceOrientIJK(6, 0, 2, 2, 3)}, {new FaceOrientIJK(2, 0, 0, 0, 0), new FaceOrientIJK(1, 2, 0, 2, 1), new FaceOrientIJK(3, 2, 2, 0, 5), new FaceOrientIJK(7, 0, 2, 2, 3)}, {new FaceOrientIJK(3, 0, 0, 0, 0), new FaceOrientIJK(2, 2, 0, 2, 1), new FaceOrientIJK(4, 2, 2, 0, 5), new FaceOrientIJK(8, 0, 2, 2, 3)}, {new FaceOrientIJK(4, 0, 0, 0, 0), new FaceOrientIJK(3, 2, 0, 2, 1), new FaceOrientIJK(0, 2, 2, 0, 5), new FaceOrientIJK(9, 0, 2, 2, 3)}, {new FaceOrientIJK(5, 0, 0, 0, 0), new FaceOrientIJK(10, 2, 2, 0, 3), new FaceOrientIJK(14, 2, 0, 2, 3), new FaceOrientIJK(0, 0, 2, 2, 3)}, {new FaceOrientIJK(6, 0, 0, 0, 0), new FaceOrientIJK(11, 2, 2, 0, 3), new FaceOrientIJK(10, 2, 0, 2, 3), new FaceOrientIJK(1, 0, 2, 2, 3)}, {new FaceOrientIJK(7, 0, 0, 0, 0), new FaceOrientIJK(12, 2, 2, 0, 3), new FaceOrientIJK(11, 2, 0, 2, 3), new FaceOrientIJK(2, 0, 2, 2, 3)}, {new FaceOrientIJK(8, 0, 0, 0, 0), new FaceOrientIJK(13, 2, 2, 0, 3), new FaceOrientIJK(12, 2, 0, 2, 3), new FaceOrientIJK(3, 0, 2, 2, 3)}, {new FaceOrientIJK(9, 0, 0, 0, 0), new FaceOrientIJK(14, 2, 2, 0, 3), new FaceOrientIJK(13, 2, 0, 2, 3), new FaceOrientIJK(4, 0, 2, 2, 3)}, {new FaceOrientIJK(10, 0, 0, 0, 0), new FaceOrientIJK(5, 2, 2, 0, 3), new FaceOrientIJK(6, 2, 0, 2, 3), new FaceOrientIJK(15, 0, 2, 2, 3)}, {new FaceOrientIJK(11, 0, 0, 0, 0), new FaceOrientIJK(6, 2, 2, 0, 3), new FaceOrientIJK(7, 2, 0, 2, 3), new FaceOrientIJK(16, 0, 2, 2, 3)}, {new FaceOrientIJK(12, 0, 0, 0, 0), new FaceOrientIJK(7, 2, 2, 0, 3), new FaceOrientIJK(8, 2, 0, 2, 3), new FaceOrientIJK(17, 0, 2, 2, 3)}, {new FaceOrientIJK(13, 0, 0, 0, 0), new FaceOrientIJK(8, 2, 2, 0, 3), new FaceOrientIJK(9, 2, 0, 2, 3), new FaceOrientIJK(18, 0, 2, 2, 3)}, {new FaceOrientIJK(14, 0, 0, 0, 0), new FaceOrientIJK(9, 2, 2, 0, 3), new FaceOrientIJK(5, 2, 0, 2, 3), new FaceOrientIJK(19, 0, 2, 2, 3)}, {new FaceOrientIJK(15, 0, 0, 0, 0), new FaceOrientIJK(16, 2, 0, 2, 1), new FaceOrientIJK(19, 2, 2, 0, 5), new FaceOrientIJK(10, 0, 2, 2, 3)}, {new FaceOrientIJK(16, 0, 0, 0, 0), new FaceOrientIJK(17, 2, 0, 2, 1), new FaceOrientIJK(15, 2, 2, 0, 5), new FaceOrientIJK(11, 0, 2, 2, 3)}, {new FaceOrientIJK(17, 0, 0, 0, 0), new FaceOrientIJK(18, 2, 0, 2, 1), new FaceOrientIJK(16, 2, 2, 0, 5), new FaceOrientIJK(12, 0, 2, 2, 3)}, {new FaceOrientIJK(18, 0, 0, 0, 0), new FaceOrientIJK(19, 2, 0, 2, 1), new FaceOrientIJK(17, 2, 2, 0, 5), new FaceOrientIJK(13, 0, 2, 2, 3)}, {new FaceOrientIJK(19, 0, 0, 0, 0), new FaceOrientIJK(15, 2, 0, 2, 1), new FaceOrientIJK(18, 2, 2, 0, 5), new FaceOrientIJK(14, 0, 2, 2, 3)}};
    int face;
    CoordIJK coord;

    FaceIJK(int face, CoordIJK coord) {
        this.face = face;
        this.coord = coord;
    }

    public Overage adjustOverageClassII(int res, boolean pentLeading4, boolean substrate) {
        Overage overage = Overage.NO_OVERAGE;
        int maxDim = maxDimByCIIres[res];
        if (substrate) {
            maxDim *= 3;
        }
        if (substrate && this.coord.i + this.coord.j + this.coord.k == maxDim) {
            overage = Overage.FACE_EDGE;
        } else if (this.coord.i + this.coord.j + this.coord.k > maxDim) {
            FaceOrientIJK fijkOrient;
            overage = Overage.NEW_FACE;
            if (this.coord.k > 0) {
                if (this.coord.j > 0) {
                    fijkOrient = faceNeighbors[this.face][3];
                } else {
                    fijkOrient = faceNeighbors[this.face][2];
                    if (pentLeading4) {
                        this.coord.ijkSub(maxDim, 0, 0);
                        this.coord.ijkRotate60cw();
                        this.coord.ijkAdd(maxDim, 0, 0);
                    }
                }
            } else {
                fijkOrient = faceNeighbors[this.face][1];
            }
            this.face = fijkOrient.face;
            for (int i = 0; i < fijkOrient.ccwRot60; ++i) {
                this.coord.ijkRotate60ccw();
            }
            int unitScale = unitScaleByCIIres[res];
            if (substrate) {
                unitScale *= 3;
            }
            this.coord.ijkAdd(fijkOrient.translateI * unitScale, fijkOrient.translateJ * unitScale, fijkOrient.translateK * unitScale);
            this.coord.ijkNormalize();
            if (substrate && this.coord.i + this.coord.j + this.coord.k == maxDim) {
                overage = Overage.FACE_EDGE;
            }
        }
        return overage;
    }

    public LatLng faceIjkToGeo(int res) {
        Vec2d v = this.coord.ijkToHex2d();
        return v.hex2dToGeo(this.face, res, false);
    }

    public CellBoundary faceIjkPentToCellBoundary(int res, int start, int length) {
        FaceIJK[] fijkVerts = new FaceIJK[Constants.NUM_PENT_VERTS];
        int adjRes = this.faceIjkPentToVerts(res, fijkVerts);
        int additionalIteration = length == Constants.NUM_PENT_VERTS ? 1 : 0;
        CellBoundary boundary = new CellBoundary();
        FaceIJK lastFijk = null;
        for (int vert = start; vert < start + length + additionalIteration; ++vert) {
            int v = vert % Constants.NUM_PENT_VERTS;
            FaceIJK fijk = fijkVerts[v];
            fijk.adjustPentVertOverage(adjRes);
            if (H3Index.isResolutionClassIII(res) && vert > start) {
                Vec2d edge1;
                Vec2d edge0;
                FaceIJK tmpFijk = new FaceIJK(fijk.face, new CoordIJK(fijk.coord.i, fijk.coord.j, fijk.coord.k));
                Vec2d orig2d0 = lastFijk.coord.ijkToHex2d();
                int currentToLastDir = adjacentFaceDir[tmpFijk.face][lastFijk.face];
                FaceOrientIJK fijkOrient = faceNeighbors[tmpFijk.face][currentToLastDir];
                tmpFijk.face = fijkOrient.face;
                CoordIJK ijk = tmpFijk.coord;
                for (int i = 0; i < fijkOrient.ccwRot60; ++i) {
                    ijk.ijkRotate60ccw();
                }
                int unitScale = unitScaleByCIIres[adjRes] * 3;
                ijk.ijkAdd(fijkOrient.translateI * unitScale, fijkOrient.translateJ * unitScale, fijkOrient.translateK * unitScale);
                ijk.ijkNormalize();
                Vec2d orig2d1 = ijk.ijkToHex2d();
                int maxDim = maxDimByCIIres[adjRes];
                Vec2d v0 = new Vec2d(3.0 * (double)maxDim, 0.0);
                Vec2d v1 = new Vec2d(-1.5 * (double)maxDim, 3.0 * Constants.M_SQRT3_2 * (double)maxDim);
                Vec2d v2 = new Vec2d(-1.5 * (double)maxDim, -3.0 * Constants.M_SQRT3_2 * (double)maxDim);
                switch (adjacentFaceDir[tmpFijk.face][fijk.face]) {
                    case 1: {
                        edge0 = v0;
                        edge1 = v1;
                        break;
                    }
                    case 3: {
                        edge0 = v1;
                        edge1 = v2;
                        break;
                    }
                    default: {
                        assert (adjacentFaceDir[tmpFijk.face][fijk.face] == 2);
                        edge0 = v2;
                        edge1 = v0;
                    }
                }
                Vec2d inter = Vec2d.v2dIntersect(orig2d0, orig2d1, edge0, edge1);
                LatLng point = inter.hex2dToGeo(tmpFijk.face, adjRes, true);
                boundary.add(point);
            }
            if (vert < start + Constants.NUM_PENT_VERTS) {
                Vec2d vec = fijk.coord.ijkToHex2d();
                LatLng point = vec.hex2dToGeo(fijk.face, adjRes, true);
                boundary.add(point);
            }
            lastFijk = fijk;
        }
        return boundary;
    }

    public CellBoundary faceIjkToCellBoundary(int res, int start, int length) {
        FaceIJK[] fijkVerts = new FaceIJK[Constants.NUM_HEX_VERTS];
        int adjRes = this.faceIjkToVerts(res, fijkVerts);
        int additionalIteration = length == Constants.NUM_HEX_VERTS ? 1 : 0;
        CellBoundary boundary = new CellBoundary();
        int lastFace = -1;
        Overage lastOverage = Overage.NO_OVERAGE;
        for (int vert = start; vert < start + length + additionalIteration; ++vert) {
            int v = vert % Constants.NUM_HEX_VERTS;
            FaceIJK fijk = new FaceIJK(fijkVerts[v].face, new CoordIJK(fijkVerts[v].coord.i, fijkVerts[v].coord.j, fijkVerts[v].coord.k));
            boolean pentLeading4 = false;
            Overage overage = fijk.adjustOverageClassII(adjRes, false, true);
            if (H3Index.isResolutionClassIII(res) && vert > start && fijk.face != lastFace && lastOverage != Overage.FACE_EDGE) {
                boolean isIntersectionAtVertex;
                Vec2d edge1;
                Vec2d edge0;
                int lastV = (v + 5) % Constants.NUM_HEX_VERTS;
                Vec2d orig2d0 = fijkVerts[lastV].coord.ijkToHex2d();
                Vec2d orig2d1 = fijkVerts[v].coord.ijkToHex2d();
                int maxDim = maxDimByCIIres[adjRes];
                Vec2d v0 = new Vec2d(3.0 * (double)maxDim, 0.0);
                Vec2d v1 = new Vec2d(-1.5 * (double)maxDim, 3.0 * Constants.M_SQRT3_2 * (double)maxDim);
                Vec2d v2 = new Vec2d(-1.5 * (double)maxDim, -3.0 * Constants.M_SQRT3_2 * (double)maxDim);
                int face2 = lastFace == this.face ? fijk.face : lastFace;
                switch (adjacentFaceDir[this.face][face2]) {
                    case 1: {
                        edge0 = v0;
                        edge1 = v1;
                        break;
                    }
                    case 3: {
                        edge0 = v1;
                        edge1 = v2;
                        break;
                    }
                    default: {
                        assert (adjacentFaceDir[this.face][face2] == 2);
                        edge0 = v2;
                        edge1 = v0;
                    }
                }
                Vec2d inter = Vec2d.v2dIntersect(orig2d0, orig2d1, edge0, edge1);
                boolean bl = isIntersectionAtVertex = orig2d0.equals(inter) || orig2d1.equals(inter);
                if (!isIntersectionAtVertex) {
                    LatLng point = inter.hex2dToGeo(this.face, adjRes, true);
                    boundary.add(point);
                }
            }
            if (vert < start + Constants.NUM_HEX_VERTS) {
                Vec2d vec = fijk.coord.ijkToHex2d();
                LatLng point = vec.hex2dToGeo(fijk.face, adjRes, true);
                boundary.add(point);
            }
            lastFace = fijk.face;
            lastOverage = overage;
        }
        return boundary;
    }

    public long faceIjkToH3(int res) {
        int i;
        long h = H3Index.H3_INIT;
        h = H3Index.H3_set_mode(h, Constants.H3_CELL_MODE);
        h = H3Index.H3_set_resolution(h, res);
        if (res == 0) {
            if (this.coord.i > 2 || this.coord.j > 2 || this.coord.k > 2) {
                throw new IllegalArgumentException(" out of range input");
            }
            return H3Index.H3_set_base_cell(h, BaseCells.getBaseCell(this));
        }
        for (int r = res - 1; r >= 0; --r) {
            CoordIJK lastCenter;
            int lastI = this.coord.i;
            int lastJ = this.coord.j;
            int lastK = this.coord.k;
            if (H3Index.isResolutionClassIII(r + 1)) {
                this.coord.upAp7();
                lastCenter = new CoordIJK(this.coord.i, this.coord.j, this.coord.k);
                lastCenter.downAp7();
            } else {
                this.coord.upAp7r();
                lastCenter = new CoordIJK(this.coord.i, this.coord.j, this.coord.k);
                lastCenter.downAp7r();
            }
            CoordIJK diff = new CoordIJK(lastI - lastCenter.i, lastJ - lastCenter.j, lastK - lastCenter.k);
            diff.ijkNormalize();
            h = H3Index.H3_set_index_digit(h, r + 1, diff.unitIjkToDigit());
        }
        if (this.coord.i > 2 || this.coord.j > 2 || this.coord.k > 2) {
            throw new IllegalArgumentException(" out of range input");
        }
        int baseCell = BaseCells.getBaseCell(this);
        h = H3Index.H3_set_base_cell(h, baseCell);
        int numRots = BaseCells.getBaseCellCCWrot60(this);
        if (BaseCells.isBaseCellPentagon(baseCell)) {
            if (H3Index.h3LeadingNonZeroDigit(h) == CoordIJK.Direction.K_AXES_DIGIT.digit()) {
                h = BaseCells.baseCellIsCwOffset(baseCell, this.face) ? H3Index.h3Rotate60cw(h) : H3Index.h3Rotate60ccw(h);
            }
            for (i = 0; i < numRots; ++i) {
                h = H3Index.h3RotatePent60ccw(h);
            }
        } else {
            for (i = 0; i < numRots; ++i) {
                h = H3Index.h3Rotate60ccw(h);
            }
        }
        return h;
    }

    private int faceIjkToVerts(int res, FaceIJK[] fijkVerts) {
        CoordIJK[] verts = H3Index.isResolutionClassIII(res) ? new CoordIJK[]{new CoordIJK(5, 4, 0), new CoordIJK(1, 5, 0), new CoordIJK(0, 5, 4), new CoordIJK(0, 1, 5), new CoordIJK(4, 0, 5), new CoordIJK(5, 0, 1)} : new CoordIJK[]{new CoordIJK(2, 1, 0), new CoordIJK(1, 2, 0), new CoordIJK(0, 2, 1), new CoordIJK(0, 1, 2), new CoordIJK(1, 0, 2), new CoordIJK(2, 0, 1)};
        this.coord.downAp3();
        this.coord.downAp3r();
        if (H3Index.isResolutionClassIII(res)) {
            this.coord.downAp7r();
            ++res;
        }
        for (int v = 0; v < Constants.NUM_HEX_VERTS; ++v) {
            verts[v].ijkAdd(this.coord.i, this.coord.j, this.coord.k);
            verts[v].ijkNormalize();
            fijkVerts[v] = new FaceIJK(this.face, verts[v]);
        }
        return res;
    }

    private int faceIjkPentToVerts(int res, FaceIJK[] fijkVerts) {
        CoordIJK[] verts = H3Index.isResolutionClassIII(res) ? new CoordIJK[]{new CoordIJK(5, 4, 0), new CoordIJK(1, 5, 0), new CoordIJK(0, 5, 4), new CoordIJK(0, 1, 5), new CoordIJK(4, 0, 5)} : new CoordIJK[]{new CoordIJK(2, 1, 0), new CoordIJK(1, 2, 0), new CoordIJK(0, 2, 1), new CoordIJK(0, 1, 2), new CoordIJK(1, 0, 2)};
        this.coord.downAp3();
        this.coord.downAp3r();
        if (H3Index.isResolutionClassIII(res)) {
            this.coord.downAp7r();
            ++res;
        }
        for (int v = 0; v < Constants.NUM_PENT_VERTS; ++v) {
            verts[v].ijkAdd(this.coord.i, this.coord.j, this.coord.k);
            verts[v].ijkNormalize();
            fijkVerts[v] = new FaceIJK(this.face, verts[v]);
        }
        return res;
    }

    private Overage adjustPentVertOverage(int res) {
        Overage overage;
        while ((overage = this.adjustOverageClassII(res, false, true)) == Overage.NEW_FACE) {
        }
        return overage;
    }

    static enum Overage {
        NO_OVERAGE,
        FACE_EDGE,
        NEW_FACE;

    }

    private static class FaceOrientIJK {
        final int face;
        final int translateI;
        final int translateJ;
        final int translateK;
        final int ccwRot60;

        FaceOrientIJK(int face, int translateI, int translateJ, int translateK, int ccwRot60) {
            this.face = face;
            this.translateI = translateI;
            this.translateJ = translateJ;
            this.translateK = translateK;
            this.ccwRot60 = ccwRot60;
        }
    }
}

