/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.exception.SemanticCheckException;
import org.opensearch.sql.expression.function.FunctionBuilder;
import org.opensearch.sql.expression.function.FunctionName;
import org.opensearch.sql.expression.function.FunctionResolver;
import org.opensearch.sql.expression.function.FunctionSignature;
import org.opensearch.sql.expression.function.OpenSearchFunctions;

public class RelevanceFunctionResolver
implements FunctionResolver {
    private final FunctionName functionName;

    @Override
    public Pair<FunctionSignature, FunctionBuilder> resolve(FunctionSignature unresolvedSignature) {
        if (!unresolvedSignature.getFunctionName().equals(this.functionName)) {
            throw new SemanticCheckException(String.format("Expected '%s' but got '%s'", this.functionName.getFunctionName(), unresolvedSignature.getFunctionName().getFunctionName()));
        }
        List<ExprType> paramTypes = unresolvedSignature.getParamTypeList();
        for (int i = 1; i < paramTypes.size(); ++i) {
            ExprType paramType = paramTypes.get(i);
            if (ExprCoreType.STRING.equals(paramType)) continue;
            throw new SemanticCheckException(this.getWrongParameterErrorMessage(i, paramType, ExprCoreType.STRING));
        }
        FunctionBuilder buildFunction = (functionProperties, args) -> new OpenSearchFunctions.OpenSearchFunction(this.functionName, args);
        return Pair.of((Object)unresolvedSignature, (Object)buildFunction);
    }

    private String getWrongParameterErrorMessage(int i, ExprType paramType, ExprType expectedType) {
        return String.format("Expected type %s instead of %s for parameter #%d", expectedType.typeName(), paramType.typeName(), i + 1);
    }

    @Generated
    public RelevanceFunctionResolver(FunctionName functionName) {
        this.functionName = functionName;
    }

    @Override
    @Generated
    public FunctionName getFunctionName() {
        return this.functionName;
    }
}

