/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.aggregation;

import com.tdunning.math.stats.AVLTreeDigest;
import java.util.List;
import org.opensearch.sql.common.utils.StringUtils;
import org.opensearch.sql.data.model.ExprNullValue;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.data.model.ExprValueUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.expression.aggregation.AggregationState;
import org.opensearch.sql.expression.aggregation.Aggregator;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.utils.ExpressionUtils;

public class PercentileApproximateAggregator
extends Aggregator<PercentileApproximateState> {
    public static Aggregator percentileApprox(List<Expression> arguments, ExprCoreType returnType) {
        return new PercentileApproximateAggregator(arguments, returnType);
    }

    public PercentileApproximateAggregator(List<Expression> arguments, ExprCoreType returnType) {
        super(BuiltinFunctionName.PERCENTILE_APPROX.getName(), arguments, returnType);
        if (!ExprCoreType.numberTypes().contains(returnType)) {
            throw new IllegalArgumentException(String.format("percentile aggregation over %s type is not supported", returnType));
        }
    }

    @Override
    public PercentileApproximateState create() {
        if (this.getArguments().size() == 2) {
            return new PercentileApproximateState(this.getArguments().get(1).valueOf().doubleValue());
        }
        return new PercentileApproximateState(this.getArguments().get(1).valueOf().doubleValue(), this.getArguments().get(2).valueOf().doubleValue());
    }

    @Override
    protected PercentileApproximateState iterate(ExprValue value, PercentileApproximateState state) {
        state.evaluate(value);
        return state;
    }

    public String toString() {
        return StringUtils.format((String)"%s(%s)", (Object[])new Object[]{"percentile", ExpressionUtils.format(this.getArguments())});
    }

    protected static class PercentileApproximateState
    extends AVLTreeDigest
    implements AggregationState {
        public static final double DEFAULT_COMPRESSION = 100.0;
        private final double percent;

        PercentileApproximateState(double percent) {
            super(100.0);
            if (percent < 0.0 || percent > 100.0) {
                throw new IllegalArgumentException("out of bounds percent value, must be in [0, 100]");
            }
            this.percent = percent / 100.0;
        }

        PercentileApproximateState(double percent, double compression) {
            super(compression);
            if (percent < 0.0 || percent > 100.0) {
                throw new IllegalArgumentException("out of bounds percent value, must be in [0, 100]");
            }
            this.percent = percent / 100.0;
        }

        public void evaluate(ExprValue value) {
            this.add(value.doubleValue());
        }

        @Override
        public ExprValue result() {
            return this.size() == 0L ? ExprNullValue.of() : ExprValueUtils.doubleValue(this.quantile(this.percent));
        }
    }
}

