/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;

public class ECDSAVerifyInput {
    public ECDSASignatureAlgorithm _signatureAlgorithm;
    public DafnySequence<? extends Byte> _verificationKey;
    public DafnySequence<? extends Byte> _message;
    public DafnySequence<? extends Byte> _signature;
    private static final TypeDescriptor<ECDSAVerifyInput> _TYPE = TypeDescriptor.referenceWithInitializer(ECDSAVerifyInput.class, () -> ECDSAVerifyInput.Default());
    private static final ECDSAVerifyInput theDefault = ECDSAVerifyInput.create(ECDSASignatureAlgorithm.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));

    public ECDSAVerifyInput(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> verificationKey, DafnySequence<? extends Byte> message, DafnySequence<? extends Byte> signature) {
        this._signatureAlgorithm = signatureAlgorithm;
        this._verificationKey = verificationKey;
        this._message = message;
        this._signature = signature;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        ECDSAVerifyInput o = (ECDSAVerifyInput)other;
        return Objects.equals(this._signatureAlgorithm, o._signatureAlgorithm) && Objects.equals(this._verificationKey, o._verificationKey) && Objects.equals(this._message, o._message) && Objects.equals(this._signature, o._signature);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signatureAlgorithm);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._verificationKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._message);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signature);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.ECDSAVerifyInput.ECDSAVerifyInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._signatureAlgorithm));
        s.append(", ");
        s.append(Helpers.toString(this._verificationKey));
        s.append(", ");
        s.append(Helpers.toString(this._message));
        s.append(", ");
        s.append(Helpers.toString(this._signature));
        s.append(")");
        return s.toString();
    }

    public static TypeDescriptor<ECDSAVerifyInput> _typeDescriptor() {
        return _TYPE;
    }

    public static ECDSAVerifyInput Default() {
        return theDefault;
    }

    public static ECDSAVerifyInput create(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> verificationKey, DafnySequence<? extends Byte> message, DafnySequence<? extends Byte> signature) {
        return new ECDSAVerifyInput(signatureAlgorithm, verificationKey, message, signature);
    }

    public static ECDSAVerifyInput create_ECDSAVerifyInput(ECDSASignatureAlgorithm signatureAlgorithm, DafnySequence<? extends Byte> verificationKey, DafnySequence<? extends Byte> message, DafnySequence<? extends Byte> signature) {
        return ECDSAVerifyInput.create(signatureAlgorithm, verificationKey, message, signature);
    }

    public boolean is_ECDSAVerifyInput() {
        return true;
    }

    public ECDSASignatureAlgorithm dtor_signatureAlgorithm() {
        return this._signatureAlgorithm;
    }

    public DafnySequence<? extends Byte> dtor_verificationKey() {
        return this._verificationKey;
    }

    public DafnySequence<? extends Byte> dtor_message() {
        return this._message;
    }

    public DafnySequence<? extends Byte> dtor_signature() {
        return this._signature;
    }
}

