/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.support;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class WildcardMatcher
implements Predicate<String> {
    public static final WildcardMatcher ANY = new WildcardMatcher(){

        @Override
        public boolean matchAny(Stream<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAny(Collection<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAny(String ... candidates) {
            return true;
        }

        @Override
        public boolean matchAll(Stream<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAll(Collection<String> candidates) {
            return true;
        }

        @Override
        public boolean matchAll(String[] candidates) {
            return true;
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
            return (T)((Collection)candidates.collect(collector));
        }

        @Override
        public boolean test(String candidate) {
            return true;
        }

        public String toString() {
            return "*";
        }
    };
    public static final WildcardMatcher NONE = new WildcardMatcher(){

        @Override
        public boolean matchAny(Stream<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAny(Collection<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAny(String ... candidates) {
            return false;
        }

        @Override
        public boolean matchAll(Stream<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAll(Collection<String> candidates) {
            return false;
        }

        @Override
        public boolean matchAll(String[] candidates) {
            return false;
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(Collection<String> candidate, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public <T extends Collection<String>> T getMatchAny(String[] candidate, Collector<String, ?, T> collector) {
            return (T)((Collection)Stream.empty().collect(collector));
        }

        @Override
        public boolean test(String candidate) {
            return false;
        }

        public String toString() {
            return "<NONE>";
        }
    };

    public static WildcardMatcher from(String pattern, boolean caseSensitive) {
        if (pattern == null) {
            return NONE;
        }
        if (pattern.equals("*")) {
            return ANY;
        }
        if (pattern.startsWith("/") && pattern.endsWith("/")) {
            return new RegexMatcher(pattern, caseSensitive);
        }
        if (pattern.indexOf(63) >= 0 || pattern.indexOf(42) >= 0) {
            return caseSensitive ? new SimpleMatcher(pattern) : new CasefoldingMatcher(pattern, SimpleMatcher::new);
        }
        return caseSensitive ? new Exact(pattern) : new CasefoldingMatcher(pattern, x$0 -> new Exact((String)x$0));
    }

    public static WildcardMatcher from(String pattern) {
        return WildcardMatcher.from(pattern, true);
    }

    public static <T> WildcardMatcher from(Stream<T> stream, boolean caseSensitive) {
        Collection matchers = (Collection)stream.map(t -> {
            if (t == null) {
                return NONE;
            }
            if (t instanceof String) {
                return WildcardMatcher.from((String)t, caseSensitive);
            }
            if (t instanceof WildcardMatcher) {
                return (WildcardMatcher)t;
            }
            throw new UnsupportedOperationException("WildcardMatcher can't be constructed from " + t.getClass().getSimpleName());
        }).collect(ImmutableSet.toImmutableSet());
        if (matchers.isEmpty()) {
            return NONE;
        }
        if (matchers.size() == 1) {
            return (WildcardMatcher)matchers.stream().findFirst().get();
        }
        return new MatcherCombiner(matchers);
    }

    public static <T> WildcardMatcher from(Collection<T> collection, boolean caseSensitive) {
        if (collection == null || collection.isEmpty()) {
            return NONE;
        }
        if (collection.size() == 1) {
            T t = collection.stream().findFirst().get();
            if (t instanceof String) {
                return WildcardMatcher.from((String)t, caseSensitive);
            }
            if (t instanceof WildcardMatcher) {
                return (WildcardMatcher)t;
            }
            throw new UnsupportedOperationException("WildcardMatcher can't be constructed from " + t.getClass().getSimpleName());
        }
        return WildcardMatcher.from(collection.stream(), caseSensitive);
    }

    public static WildcardMatcher from(String[] patterns, boolean caseSensitive) {
        if (patterns == null || patterns.length == 0) {
            return NONE;
        }
        if (patterns.length == 1) {
            return WildcardMatcher.from(patterns[0], caseSensitive);
        }
        return WildcardMatcher.from(Arrays.stream(patterns), caseSensitive);
    }

    public static WildcardMatcher from(Stream<String> patterns) {
        return WildcardMatcher.from(patterns, true);
    }

    public static WildcardMatcher from(Collection<?> patterns) {
        return WildcardMatcher.from(patterns, true);
    }

    public static WildcardMatcher from(String ... patterns) {
        return WildcardMatcher.from(patterns, true);
    }

    public WildcardMatcher concat(Stream<WildcardMatcher> matchers) {
        return new MatcherCombiner((Collection)Stream.concat(matchers, Stream.of(this)).collect(ImmutableSet.toImmutableSet()));
    }

    public WildcardMatcher concat(Collection<WildcardMatcher> matchers) {
        if (matchers.isEmpty()) {
            return this;
        }
        return this.concat(matchers.stream());
    }

    public WildcardMatcher concat(WildcardMatcher ... matchers) {
        if (matchers.length == 0) {
            return this;
        }
        return this.concat(Arrays.stream(matchers));
    }

    public boolean matchAny(Stream<String> candidates) {
        return candidates.anyMatch(this);
    }

    public boolean matchAny(Collection<String> candidates) {
        return this.matchAny(candidates.stream());
    }

    public boolean matchAny(String ... candidates) {
        return this.matchAny(Arrays.stream(candidates));
    }

    public boolean matchAll(Stream<String> candidates) {
        return candidates.allMatch(this);
    }

    public boolean matchAll(Collection<String> candidates) {
        return this.matchAll(candidates.stream());
    }

    public boolean matchAll(String[] candidates) {
        return this.matchAll(Arrays.stream(candidates));
    }

    public <T extends Collection<String>> T getMatchAny(Stream<String> candidates, Collector<String, ?, T> collector) {
        return (T)((Collection)candidates.filter(this).collect(collector));
    }

    public <T extends Collection<String>> T getMatchAny(Collection<String> candidate, Collector<String, ?, T> collector) {
        return this.getMatchAny(candidate.stream(), collector);
    }

    public <T extends Collection<String>> T getMatchAny(String[] candidate, Collector<String, ?, T> collector) {
        return this.getMatchAny(Arrays.stream(candidate), collector);
    }

    public Optional<WildcardMatcher> findFirst(String candidate) {
        return Optional.ofNullable(this.test(candidate) ? this : null);
    }

    public Iterable<String> iterateMatching(Iterable<String> candidates) {
        return this.iterateMatching(candidates, Function.identity());
    }

    public <E> Iterable<E> iterateMatching(final Iterable<E> candidates, final Function<E, String> toStringFunction) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                final Iterator delegate = candidates.iterator();
                return new Iterator<E>(){
                    private E next;

                    @Override
                    public boolean hasNext() {
                        if (this.next == null) {
                            this.init();
                        }
                        return this.next != null;
                    }

                    @Override
                    public E next() {
                        if (this.next == null) {
                            this.init();
                        }
                        Object result = this.next;
                        this.next = null;
                        return result;
                    }

                    private void init() {
                        while (delegate.hasNext()) {
                            Object candidate = delegate.next();
                            if (!WildcardMatcher.this.test((String)toStringFunction.apply(candidate))) continue;
                            this.next = candidate;
                            break;
                        }
                    }
                };
            }
        };
    }

    public static List<WildcardMatcher> matchers(Collection<String> patterns) {
        return patterns.stream().map(p -> WildcardMatcher.from(p, true)).collect(Collectors.toList());
    }

    public static List<String> getAllMatchingPatterns(Collection<WildcardMatcher> matchers, String candidate) {
        return matchers.stream().filter(p -> p.test(candidate)).map(Objects::toString).collect(Collectors.toList());
    }

    public static List<String> getAllMatchingPatterns(Collection<WildcardMatcher> pattern, Collection<String> candidates) {
        return pattern.stream().filter(p -> p.matchAny(candidates)).map(Objects::toString).collect(Collectors.toList());
    }

    public static boolean isExact(String pattern) {
        return pattern == null || !pattern.contains("*") && !pattern.contains("?") && (!pattern.startsWith("/") || !pattern.endsWith("/"));
    }

    private static final class RegexMatcher
    extends WildcardMatcher {
        private final Pattern pattern;

        private RegexMatcher(String pattern, boolean caseSensitive) {
            Preconditions.checkArgument((pattern.length() > 1 && pattern.startsWith("/") && pattern.endsWith("/") ? 1 : 0) != 0);
            String stripSlashesPattern = pattern.substring(1, pattern.length() - 1);
            this.pattern = caseSensitive ? Pattern.compile(stripSlashesPattern) : Pattern.compile(stripSlashesPattern, 2);
        }

        @Override
        public boolean test(String candidate) {
            return this.pattern.matcher(candidate).matches();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RegexMatcher that = (RegexMatcher)o;
            return this.pattern.pattern().equals(that.pattern.pattern());
        }

        public int hashCode() {
            return this.pattern.pattern().hashCode();
        }

        public String toString() {
            return "/" + this.pattern.pattern() + "/";
        }
    }

    private static final class SimpleMatcher
    extends WildcardMatcher {
        private final String pattern;

        SimpleMatcher(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean test(String candidate) {
            int i = 0;
            int j = 0;
            int n = candidate.length();
            int m = this.pattern.length();
            int text_backup = -1;
            int wild_backup = -1;
            while (i < n) {
                if (j < m && this.pattern.charAt(j) == '*') {
                    text_backup = i;
                    wild_backup = ++j;
                    continue;
                }
                if (j < m && (this.pattern.charAt(j) == '?' || this.pattern.charAt(j) == candidate.charAt(i))) {
                    ++i;
                    ++j;
                    continue;
                }
                if (wild_backup == -1) {
                    return false;
                }
                i = ++text_backup;
                j = wild_backup;
            }
            while (j < m && this.pattern.charAt(j) == '*') {
                ++j;
            }
            return j >= m;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleMatcher that = (SimpleMatcher)o;
            return this.pattern.equals(that.pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public String toString() {
            return this.pattern;
        }
    }

    private static final class CasefoldingMatcher
    extends WildcardMatcher {
        private final WildcardMatcher inner;

        public CasefoldingMatcher(String pattern, Function<String, WildcardMatcher> simpleWildcardMatcher) {
            this.inner = simpleWildcardMatcher.apply(pattern.toLowerCase());
        }

        @Override
        public boolean test(String candidate) {
            return this.inner.test(candidate.toLowerCase());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CasefoldingMatcher that = (CasefoldingMatcher)o;
            return this.inner.equals(that.inner);
        }

        public int hashCode() {
            return this.inner.hashCode();
        }

        public String toString() {
            return this.inner.toString();
        }
    }

    public static final class Exact
    extends WildcardMatcher {
        private final String pattern;

        private Exact(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean test(String candidate) {
            return this.pattern.equals(candidate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Exact that = (Exact)o;
            return this.pattern.equals(that.pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public String toString() {
            return this.pattern;
        }
    }

    private static final class MatcherCombiner
    extends WildcardMatcher {
        private final Collection<WildcardMatcher> wildcardMatchers;
        private final int hashCode;

        MatcherCombiner(Collection<WildcardMatcher> wildcardMatchers) {
            Preconditions.checkArgument((wildcardMatchers.size() > 1 ? 1 : 0) != 0);
            this.wildcardMatchers = wildcardMatchers;
            this.hashCode = wildcardMatchers.hashCode();
        }

        @Override
        public boolean test(String candidate) {
            return this.wildcardMatchers.stream().anyMatch(m -> m.test(candidate));
        }

        @Override
        public Optional<WildcardMatcher> findFirst(String candidate) {
            return this.wildcardMatchers.stream().filter(m -> m.test(candidate)).findFirst();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MatcherCombiner that = (MatcherCombiner)o;
            return this.wildcardMatchers.equals(that.wildcardMatchers);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return this.wildcardMatchers.toString();
        }
    }
}

