/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.rules.resthandler.health_stats;

import java.util.List;
import java.util.Set;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.common.Strings;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsAction;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsRequest;
import org.opensearch.plugin.insights.rules.action.health_stats.HealthStatsResponse;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestHealthStatsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_insights/health_stats"));
    }

    public String getName() {
        return "query_insights_health_stats_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        HealthStatsRequest healthStatsRequest = RestHealthStatsAction.prepareRequest(request);
        healthStatsRequest.timeout(request.param("timeout"));
        return channel -> client.execute((ActionType)HealthStatsAction.INSTANCE, (ActionRequest)healthStatsRequest, this.healthStatsResponse((RestChannel)channel));
    }

    static HealthStatsRequest prepareRequest(RestRequest request) {
        String[] nodesIds = Strings.splitStringByCommaToArray((String)request.param("nodeId"));
        return new HealthStatsRequest(nodesIds);
    }

    protected Set<String> responseParams() {
        return Settings.FORMAT_PARAMS;
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }

    RestResponseListener<HealthStatsResponse> healthStatsResponse(RestChannel channel) {
        return new RestResponseListener<HealthStatsResponse>(channel){

            public RestResponse buildResponse(HealthStatsResponse response) throws Exception {
                return new BytesRestResponse(RestStatus.OK, response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
            }
        };
    }
}

