/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.ranklib;

import ciir.umass.edu.learning.DataPoint;
import ciir.umass.edu.utilities.RankLibError;
import com.o19s.es.ltr.ranker.LtrRanker;
import java.util.Arrays;

public class DenseProgramaticDataPoint
extends DataPoint
implements LtrRanker.FeatureVector {
    private static final int RANKLIB_FEATURE_INDEX_OFFSET = 1;

    public DenseProgramaticDataPoint(int numFeatures) {
        this.fVals = new float[numFeatures + 1];
    }

    public float getFeatureValue(int fid) {
        if (fid > 0 && fid < this.fVals.length) {
            return DenseProgramaticDataPoint.isUnknown((float)this.fVals[fid]) ? 0.0f : this.fVals[fid];
        }
        throw RankLibError.create((String)("Error in DenseDataPoint::getFeatureValue(): requesting unspecified feature, fid=" + fid));
    }

    public void setFeatureValue(int fid, float fval) {
        if (fid <= 0 || fid >= this.fVals.length) {
            throw RankLibError.create((String)("Error in DenseDataPoint::setFeatureValue(): feature (id=" + fid + ") not found."));
        }
        this.fVals[fid] = fval;
    }

    public void setFeatureVector(float[] dfVals) {
        this.fVals = dfVals;
    }

    public float[] getFeatureVector() {
        return this.fVals;
    }

    @Override
    public void setFeatureScore(int featureIdx, float score) {
        this.setFeatureValue(featureIdx + 1, score);
    }

    @Override
    public float getFeatureScore(int featureIdx) {
        return this.getFeatureValue(featureIdx + 1);
    }

    public void reset() {
        Arrays.fill(this.fVals, 0.0f);
    }
}

