/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import com.intel.qat.InternalJNI;
import com.intel.qat.QatException;
import java.lang.ref.Cleaner;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class QatZipper {
    public static final int DEFAULT_COMPRESS_LEVEL = 6;
    public static final int DEFAULT_RETRY_COUNT = 0;
    public static final Mode DEFAULT_MODE = Mode.HARDWARE;
    public static final PollingMode DEFAULT_POLLING_MODE = PollingMode.BUSY;
    private boolean isValid;
    private int retryCount;
    private int bytesRead;
    private int bytesWritten;
    private long session;
    private static Cleaner cleaner;
    private final Cleaner.Cleanable cleanable;

    public QatZipper(Algorithm algorithm, int level, Mode mode, int retryCount, PollingMode pmode) throws QatException {
        if (retryCount < 0) {
            throw new IllegalArgumentException("Invalid value for retry count.");
        }
        this.retryCount = retryCount;
        InternalJNI.setup(this, algorithm.ordinal(), level, mode.ordinal(), pmode.ordinal());
        this.cleanable = cleaner.register(this, new QatCleaner(this.session));
        this.isValid = true;
    }

    public QatZipper() {
        this(Algorithm.DEFLATE, 6, DEFAULT_MODE, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Algorithm algorithm) {
        this(algorithm, 6, DEFAULT_MODE, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Mode mode) {
        this(Algorithm.DEFLATE, 6, mode, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(PollingMode pmode) {
        this(Algorithm.DEFLATE, 6, DEFAULT_MODE, 0, pmode);
    }

    public QatZipper(Algorithm algorithm, int level) {
        this(algorithm, level, DEFAULT_MODE, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Algorithm algorithm, Mode mode) {
        this(algorithm, 6, mode, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Algorithm algorithm, PollingMode pmode) {
        this(algorithm, 6, DEFAULT_MODE, 0, pmode);
    }

    public QatZipper(Algorithm algorithm, Mode mode, PollingMode pmode) {
        this(algorithm, 6, mode, 0, pmode);
    }

    public QatZipper(Algorithm algorithm, int level, Mode mode) {
        this(algorithm, level, mode, 0, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Algorithm algorithm, int level, PollingMode pmode) {
        this(algorithm, level, DEFAULT_MODE, 0, pmode);
    }

    public QatZipper(Algorithm algorithm, int level, Mode mode, int retryCount) {
        this(algorithm, level, mode, retryCount, DEFAULT_POLLING_MODE);
    }

    public QatZipper(Algorithm algorithm, int level, Mode mode, PollingMode pmode) {
        this(algorithm, level, mode, 0, pmode);
    }

    public int maxCompressedLength(long len) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        return InternalJNI.maxCompressedSize(this.session, len);
    }

    public int compress(byte[] src, byte[] dst) {
        return this.compress(src, 0, src.length, dst, 0, dst.length);
    }

    public int compress(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int compressedSize;
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        if (src == null || dst == null || srcLen == 0 || dst.length == 0) {
            throw new IllegalArgumentException("Either source or destination array or both have size 0 or null value.");
        }
        if (srcOffset < 0 || srcLen < 0 || srcOffset > src.length - srcLen) {
            throw new ArrayIndexOutOfBoundsException("Source offset is out of bound.");
        }
        if (dstOffset < 0 || dstLen < 0 || dstOffset > dst.length - dstLen) {
            throw new ArrayIndexOutOfBoundsException("Destination offset is out of bound.");
        }
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = compressedSize = InternalJNI.compressByteArray(this, this.session, src, srcOffset, srcLen, dst, dstOffset, dstLen, this.retryCount);
        return compressedSize;
    }

    public int compress(ByteBuffer src, ByteBuffer dst) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        if (src == null || dst == null || src.position() == src.limit() || dst.position() == dst.limit()) {
            throw new IllegalArgumentException();
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int srcPos = src.position();
        int dstPos = dst.position();
        this.bytesWritten = 0;
        this.bytesRead = 0;
        int compressedSize = 0;
        if (src.hasArray() && dst.hasArray()) {
            compressedSize = InternalJNI.compressByteBuffer(this.session, src, src.array(), srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + compressedSize);
        } else if (src.isDirect() && dst.isDirect()) {
            compressedSize = InternalJNI.compressDirectByteBuffer(this.session, src, srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.hasArray() && dst.isDirect()) {
            compressedSize = InternalJNI.compressDirectByteBufferDst(this.session, src, src.array(), srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.isDirect() && dst.hasArray()) {
            compressedSize = InternalJNI.compressDirectByteBufferSrc(this.session, src, srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + compressedSize);
        } else {
            int srcLen = src.remaining();
            int dstLen = dst.remaining();
            byte[] srcArr = new byte[srcLen];
            byte[] dstArr = new byte[dstLen];
            src.get(srcArr);
            dst.get(dstArr);
            src.position(src.position() - srcLen);
            dst.position(dst.position() - dstLen);
            int pos = src.position();
            compressedSize = InternalJNI.compressByteBuffer(this.session, src, srcArr, 0, srcLen, dstArr, 0, dstLen, this.retryCount);
            src.position(pos + src.position());
            dst.put(dstArr, 0, compressedSize);
        }
        this.bytesRead = src.position() - srcPos;
        this.bytesWritten = dst.position() - dstPos;
        return compressedSize;
    }

    public int decompress(byte[] src, byte[] dst) {
        return this.decompress(src, 0, src.length, dst, 0, dst.length);
    }

    public int decompress(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int decompressedSize;
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        if (src == null || dst == null || srcLen == 0 || dst.length == 0) {
            throw new IllegalArgumentException("Empty source or/and destination byte array(s).");
        }
        if (srcOffset < 0 || srcLen < 0 || srcOffset > src.length - srcLen) {
            throw new ArrayIndexOutOfBoundsException("Source offset is out of bound.");
        }
        if (dstOffset < 0 || dstLen < 0 || dstOffset > dst.length - dstLen) {
            throw new ArrayIndexOutOfBoundsException("Destination offset is out of bound.");
        }
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = decompressedSize = InternalJNI.decompressByteArray(this, this.session, src, srcOffset, srcLen, dst, dstOffset, dstLen, this.retryCount);
        return decompressedSize;
    }

    public int decompress(ByteBuffer src, ByteBuffer dst) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        if (src == null || dst == null || src.position() == src.limit() || dst.position() == dst.limit()) {
            throw new IllegalArgumentException();
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        int srcPos = src.position();
        int dstPos = dst.position();
        this.bytesWritten = 0;
        this.bytesRead = 0;
        int decompressedSize = 0;
        if (src.hasArray() && dst.hasArray()) {
            decompressedSize = InternalJNI.decompressByteBuffer(this.session, src, src.array(), srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + decompressedSize);
        } else if (src.isDirect() && dst.isDirect()) {
            decompressedSize = InternalJNI.decompressDirectByteBuffer(this.session, src, srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.hasArray() && dst.isDirect()) {
            decompressedSize = InternalJNI.decompressDirectByteBufferDst(this.session, src, src.array(), srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.isDirect() && dst.hasArray()) {
            decompressedSize = InternalJNI.decompressDirectByteBufferSrc(this.session, src, srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + decompressedSize);
        } else {
            int srcLen = src.remaining();
            int dstLen = dst.remaining();
            byte[] srcArr = new byte[srcLen];
            byte[] dstArr = new byte[dstLen];
            src.get(srcArr);
            dst.get(dstArr);
            src.position(src.position() - srcLen);
            dst.position(dst.position() - dstLen);
            int pos = src.position();
            decompressedSize = InternalJNI.decompressByteBuffer(this.session, src, srcArr, 0, srcLen, dstArr, 0, dstLen, this.retryCount);
            src.position(pos + src.position());
            dst.put(dstArr, 0, decompressedSize);
        }
        if (decompressedSize < 0) {
            throw new QatException("QAT: Compression failed");
        }
        this.bytesRead = src.position() - srcPos;
        this.bytesWritten = dst.position() - dstPos;
        return decompressedSize;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void end() throws QatException {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed.");
        }
        InternalJNI.teardown(this.session);
        this.isValid = false;
    }

    static {
        InternalJNI.initFieldIDs();
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            cleaner = Cleaner.create();
        } else {
            PrivilegedAction<Void> pa = () -> {
                cleaner = Cleaner.create();
                return null;
            };
            AccessController.doPrivileged(pa);
        }
    }

    public static enum Algorithm {
        DEFLATE,
        LZ4;

    }

    public static enum Mode {
        HARDWARE,
        AUTO;

    }

    public static enum PollingMode {
        BUSY,
        PERIODICAL;

    }

    static class QatCleaner
    implements Runnable {
        private long qzSession;

        public QatCleaner(long session) {
            this.qzSession = session;
        }

        @Override
        public void run() {
            if (this.qzSession != 0L) {
                InternalJNI.teardown(this.qzSession);
            }
        }
    }
}

