/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.common.libsvm;

import com.oracle.labs.mlrg.olcut.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import libsvm.svm_model;
import libsvm.svm_node;
import org.tribuo.Example;
import org.tribuo.Excuse;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.common.libsvm.SVMParameters;
import org.tribuo.provenance.ModelProvenance;

public abstract class LibSVMModel<T extends Output<T>>
extends Model<T>
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final Logger logger = Logger.getLogger(LibSVMModel.class.getName());
    protected List<svm_model> models;

    protected LibSVMModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<T> outputIDInfo, boolean generatesProbabilities, List<svm_model> models) {
        super(name, description, featureIDMap, outputIDInfo, generatesProbabilities);
        this.models = models;
    }

    @Deprecated
    public List<svm_model> getModel() {
        return this.getInnerModels();
    }

    public List<svm_model> getInnerModels() {
        ArrayList<svm_model> copy = new ArrayList<svm_model>();
        for (svm_model m : this.models) {
            copy.add(LibSVMModel.copyModel(m));
        }
        return Collections.unmodifiableList(copy);
    }

    public Map<String, List<Pair<String, Double>>> getTopFeatures(int n) {
        return Collections.emptyMap();
    }

    public Optional<Excuse<T>> getExcuse(Example<T> example) {
        return Optional.empty();
    }

    protected static svm_model copyModel(svm_model model) {
        int i;
        svm_model newModel = new svm_model();
        newModel.param = SVMParameters.copyParameters(model.param);
        newModel.l = model.l;
        newModel.nr_class = model.nr_class;
        newModel.rho = model.rho != null ? Arrays.copyOf(model.rho, model.rho.length) : null;
        newModel.probA = model.probA != null ? Arrays.copyOf(model.probA, model.probA.length) : null;
        newModel.probB = model.probB != null ? Arrays.copyOf(model.probB, model.probB.length) : null;
        newModel.label = model.label != null ? Arrays.copyOf(model.label, model.label.length) : null;
        newModel.sv_indices = model.sv_indices != null ? Arrays.copyOf(model.sv_indices, model.sv_indices.length) : null;
        int[] nArray = newModel.nSV = model.nSV != null ? Arrays.copyOf(model.nSV, model.nSV.length) : null;
        if (model.SV != null) {
            newModel.SV = new svm_node[model.SV.length][];
            for (i = 0; i < newModel.SV.length; ++i) {
                if (model.SV[i] == null) continue;
                svm_node[] copy = new svm_node[model.SV[i].length];
                for (int j = 0; j < copy.length; ++j) {
                    if (model.SV[i][j] == null) continue;
                    svm_node curCopy = new svm_node();
                    curCopy.index = model.SV[i][j].index;
                    curCopy.value = model.SV[i][j].value;
                    copy[j] = curCopy;
                }
                newModel.SV[i] = copy;
            }
        }
        if (model.sv_coef != null) {
            newModel.sv_coef = new double[model.sv_coef.length][];
            for (i = 0; i < newModel.sv_coef.length; ++i) {
                if (model.sv_coef[i] == null) continue;
                newModel.sv_coef[i] = Arrays.copyOf(model.sv_coef[i], model.sv_coef[i].length);
            }
        }
        return newModel;
    }

    public static boolean modelEquals(svm_model first, svm_model second) {
        boolean svCoeffEquals = Arrays.deepEquals((Object[])first.sv_coef, (Object[])second.sv_coef);
        boolean probAEquals = Arrays.equals(first.probA, second.probA);
        boolean probBEquals = Arrays.equals(first.probB, second.probB);
        boolean nSVEquals = Arrays.equals(first.nSV, second.nSV);
        boolean rhoEquals = Arrays.equals(first.rho, second.rho);
        boolean labelEquals = Arrays.equals(first.label, second.label);
        if (svCoeffEquals && probAEquals && probBEquals && nSVEquals && rhoEquals && labelEquals) {
            try {
                for (int i = 0; i < first.SV.length; ++i) {
                    for (int j = 0; j < first.SV[i].length; ++j) {
                        svm_node firstNode = first.SV[i][j];
                        svm_node secondNode = second.SV[i][j];
                        if (firstNode.index != secondNode.index) {
                            return false;
                        }
                        if (Double.compare(firstNode.value, secondNode.value) == 0) continue;
                        return false;
                    }
                }
                return true;
            }
            catch (NullPointerException e) {
                return false;
            }
        }
        return false;
    }
}

