/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.workflow;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.ExceptionsHelper;
import org.opensearch.action.admin.indices.delete.DeleteIndexRequest;
import org.opensearch.action.support.PlainActionFuture;
import org.opensearch.client.Client;
import org.opensearch.core.action.ActionListener;
import org.opensearch.flowframework.exception.WorkflowStepException;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.workflow.WorkflowData;
import org.opensearch.flowframework.workflow.WorkflowStep;

public class DeleteIndexStep
implements WorkflowStep {
    private static final Logger logger = LogManager.getLogger(DeleteIndexStep.class);
    private final Client client;
    public static final String NAME = "delete_index";
    public static final Set<String> REQUIRED_INPUTS = Set.of("index_name");
    public static final Set<String> OPTIONAL_INPUTS = Collections.emptySet();
    public static final Set<String> PROVIDED_OUTPUTS = Set.of("index_name");

    public DeleteIndexStep(Client client) {
        this.client = client;
    }

    @Override
    public PlainActionFuture<WorkflowData> execute(String currentNodeId, WorkflowData currentNodeInputs, Map<String, WorkflowData> outputs, Map<String, String> previousNodeInputs, Map<String, String> params, String tenantId) {
        PlainActionFuture deleteIndexFuture = PlainActionFuture.newFuture();
        try {
            Map<String, Object> inputs = ParseUtils.getInputsFromPreviousSteps(REQUIRED_INPUTS, OPTIONAL_INPUTS, currentNodeInputs, outputs, previousNodeInputs, params);
            String indexName = (String)inputs.get("index_name");
            DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indexName);
            this.client.admin().indices().delete(deleteIndexRequest, ActionListener.wrap(acknowledgedResponse -> {
                logger.info("Deleted index: {}", (Object)indexName);
                deleteIndexFuture.onResponse((Object)new WorkflowData(Map.ofEntries(Map.entry("index_name", indexName)), currentNodeInputs.getWorkflowId(), currentNodeInputs.getNodeId()));
            }, ex -> {
                Exception e = WorkflowStepException.getSafeException(ex);
                String errorMessage = e == null ? ParameterizedMessageFactory.INSTANCE.newMessage("Failed to delete the index {}", (Object)indexName).getFormattedMessage() : e.getMessage();
                logger.error(errorMessage, (Throwable)e);
                deleteIndexFuture.onFailure((Exception)((Object)new WorkflowStepException(errorMessage, ExceptionsHelper.status((Throwable)e))));
            }));
        }
        catch (Exception e) {
            deleteIndexFuture.onFailure(e);
        }
        return deleteIndexFuture;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean allowDeleteRequired() {
        return true;
    }
}

