/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.ArrayUtils;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelInput;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsAction;
import org.opensearch.ml.common.transport.undeploy.MLUndeployModelsRequest;
import org.opensearch.ml.settings.MLCommonsSettings;
import org.opensearch.ml.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;

public class RestMLUndeployModelAction
extends BaseRestHandler {
    private static final String ML_UNDEPLOY_MODEL_ACTION = "ml_undeploy_model_action";
    private ClusterService clusterService;
    private Settings settings;
    private boolean allowCustomDeploymentPlan;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLUndeployModelAction(ClusterService clusterService, Settings settings, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.allowCustomDeploymentPlan = (Boolean)MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN.get(settings);
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MLCommonsSettings.ML_COMMONS_ALLOW_CUSTOM_DEPLOYMENT_PLAN, it -> {
            this.allowCustomDeploymentPlan = it;
        });
    }

    public String getName() {
        return ML_UNDEPLOY_MODEL_ACTION;
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_undeploy", "/_plugins/_ml", "model_id"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/{%s}/_unload", "/_plugins/_ml", "model_id")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_undeploy", "/_plugins/_ml"), RestRequest.Method.POST, String.format(Locale.ROOT, "%s/models/_unload", "/_plugins/_ml")));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        MLUndeployModelsRequest mlUndeployModelsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)MLUndeployModelsAction.INSTANCE, (ActionRequest)mlUndeployModelsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    MLUndeployModelsRequest getRequest(RestRequest request) throws IOException {
        Object[] targetNodeIds;
        String modelId = request.param("model_id");
        String tenantId = TenantAwareHelper.getTenantID(this.mlFeatureEnabledSetting.isMultiTenancyEnabled(), request);
        Object[] targetModelIds = null;
        if (modelId != null) {
            targetModelIds = new String[]{modelId};
        }
        if (request.hasContent()) {
            XContentParser parser = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
            MLUndeployModelInput mlInput = MLUndeployModelInput.parse((XContentParser)parser);
            Object[] nodeIds = mlInput.getNodeIds();
            Object[] modelIds = mlInput.getModelIds();
            if (ArrayUtils.isNotEmpty((Object[])nodeIds)) {
                if (!this.allowCustomDeploymentPlan) {
                    throw new IllegalArgumentException("Don't allow custom deployment plan");
                }
                targetNodeIds = nodeIds;
            } else {
                targetNodeIds = RestActionUtils.getAllNodes(this.clusterService);
            }
            if (ArrayUtils.isNotEmpty((Object[])modelIds)) {
                targetModelIds = modelIds;
            }
        } else {
            targetNodeIds = RestActionUtils.getAllNodes(this.clusterService);
        }
        return new MLUndeployModelsRequest((String[])targetModelIds, (String[])targetNodeIds, tenantId);
    }
}

