/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.agent.tools;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.agent.tools.AbstractRetrieverTool;
import org.opensearch.client.Client;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.spi.tools.ToolAnnotation;
import org.opensearch.ml.common.spi.tools.WithModelTool;

@ToolAnnotation(value="NeuralSparseSearchTool")
public class NeuralSparseSearchTool
extends AbstractRetrieverTool
implements WithModelTool {
    @Generated
    private static final Logger log = LogManager.getLogger(NeuralSparseSearchTool.class);
    public static final String TYPE = "NeuralSparseSearchTool";
    public static final String EMBEDDING_FIELD = "embedding_field";
    public static final String NESTED_PATH_FIELD = "nested_path";
    private String name = "NeuralSparseSearchTool";
    private String modelId;
    private String embeddingField;
    private String nestedPath;

    public NeuralSparseSearchTool(Client client, NamedXContentRegistry xContentRegistry, String index, String embeddingField, String[] sourceFields, Integer docSize, String modelId, String nestedPath) {
        super(client, xContentRegistry, index, sourceFields, docSize);
        this.modelId = modelId;
        this.embeddingField = embeddingField;
        this.nestedPath = nestedPath;
    }

    @Override
    protected String getQueryBody(String queryText) {
        if (StringUtils.isBlank((CharSequence)this.embeddingField) || StringUtils.isBlank((CharSequence)this.modelId)) {
            throw new IllegalArgumentException("Parameter [embedding_field] and [model_id] can not be null or empty.");
        }
        Map<String, Map<String, Map<String, Map<String, Object>>>> queryBody = StringUtils.isBlank((CharSequence)this.nestedPath) ? Map.of("query", Map.of("neural_sparse", Map.of(this.embeddingField, Map.of("query_text", queryText, "model_id", this.modelId)))) : Map.of("query", Map.of("nested", Map.of("path", this.nestedPath, "score_mode", "max", "query", Map.of("neural_sparse", Map.of(this.embeddingField, Map.of("query_text", queryText, "model_id", this.modelId))))));
        try {
            return AccessController.doPrivileged(() -> org.opensearch.ml.common.utils.StringUtils.gson.toJson((Object)queryBody));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public static NeuralSparseSearchToolBuilder builder() {
        return new NeuralSparseSearchToolBuilder();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getEmbeddingField() {
        return this.embeddingField;
    }

    @Generated
    public String getNestedPath() {
        return this.nestedPath;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setEmbeddingField(String embeddingField) {
        this.embeddingField = embeddingField;
    }

    @Generated
    public void setNestedPath(String nestedPath) {
        this.nestedPath = nestedPath;
    }

    @Generated
    public static class NeuralSparseSearchToolBuilder {
        @Generated
        private Client client;
        @Generated
        private NamedXContentRegistry xContentRegistry;
        @Generated
        private String index;
        @Generated
        private String embeddingField;
        @Generated
        private String[] sourceFields;
        @Generated
        private Integer docSize;
        @Generated
        private String modelId;
        @Generated
        private String nestedPath;

        @Generated
        NeuralSparseSearchToolBuilder() {
        }

        @Generated
        public NeuralSparseSearchToolBuilder client(Client client) {
            this.client = client;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder xContentRegistry(NamedXContentRegistry xContentRegistry) {
            this.xContentRegistry = xContentRegistry;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder index(String index) {
            this.index = index;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder embeddingField(String embeddingField) {
            this.embeddingField = embeddingField;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder sourceFields(String[] sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder docSize(Integer docSize) {
            this.docSize = docSize;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Generated
        public NeuralSparseSearchToolBuilder nestedPath(String nestedPath) {
            this.nestedPath = nestedPath;
            return this;
        }

        @Generated
        public NeuralSparseSearchTool build() {
            return new NeuralSparseSearchTool(this.client, this.xContentRegistry, this.index, this.embeddingField, this.sourceFields, this.docSize, this.modelId, this.nestedPath);
        }

        @Generated
        public String toString() {
            return "NeuralSparseSearchTool.NeuralSparseSearchToolBuilder(client=" + String.valueOf(this.client) + ", xContentRegistry=" + String.valueOf(this.xContentRegistry) + ", index=" + this.index + ", embeddingField=" + this.embeddingField + ", sourceFields=" + Arrays.deepToString(this.sourceFields) + ", docSize=" + this.docSize + ", modelId=" + this.modelId + ", nestedPath=" + this.nestedPath + ")";
        }
    }

    public static class Factory
    extends AbstractRetrieverTool.Factory<NeuralSparseSearchTool>
    implements WithModelTool.Factory<NeuralSparseSearchTool> {
        private static Factory INSTANCE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Factory getInstance() {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            Class<NeuralSparseSearchTool> clazz = NeuralSparseSearchTool.class;
            synchronized (NeuralSparseSearchTool.class) {
                if (INSTANCE != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return INSTANCE;
                }
                INSTANCE = new Factory();
                // ** MonitorExit[var0] (shouldn't be in output)
                return INSTANCE;
            }
        }

        public NeuralSparseSearchTool create(Map<String, Object> params) {
            String index = (String)params.get("index");
            String embeddingField = (String)params.get(NeuralSparseSearchTool.EMBEDDING_FIELD);
            String[] sourceFields = (String[])org.opensearch.ml.common.utils.StringUtils.gson.fromJson((String)params.get("source_field"), String[].class);
            String modelId = (String)params.get("model_id");
            Integer docSize = params.containsKey("doc_size") ? Integer.parseInt((String)params.get("doc_size")) : 2;
            String nestedPath = (String)params.get(NeuralSparseSearchTool.NESTED_PATH_FIELD);
            return NeuralSparseSearchTool.builder().client(this.client).xContentRegistry(this.xContentRegistry).index(index).embeddingField(embeddingField).sourceFields(sourceFields).modelId(modelId).docSize(docSize).nestedPath(nestedPath).build();
        }

        public String getDefaultType() {
            return NeuralSparseSearchTool.TYPE;
        }

        public String getDefaultVersion() {
            return null;
        }

        public List<String> getAllModelKeys() {
            return List.of("model_id");
        }
    }
}

