/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.internal;

import java.util.Arrays;

public final class AwsKmsCmkArnInfo {
    private static final String arnLiteral = "arn";
    private static final String kmsServiceName = "kms";
    private final String partition_;
    private final String accountId_;
    private final String region_;
    private final String resource_;
    private final String resourceType_;

    public static AwsKmsCmkArnInfo parseInfoFromKeyArn(String keyArn) {
        if (keyArn == null || keyArn.isEmpty()) {
            return null;
        }
        String[] parts = AwsKmsArnParts.splitArn(keyArn);
        if (!arnLiteral.equals(parts[AwsKmsArnParts.ArnLiteral.index()])) {
            return null;
        }
        if (!kmsServiceName.equals(parts[AwsKmsArnParts.Service.index()])) {
            return null;
        }
        boolean emptyParts = Arrays.stream(parts).anyMatch(String::isEmpty);
        if (emptyParts || AwsKmsArnParts.values().length != parts.length) {
            return null;
        }
        String[] resourceParts = AwsKmsArnParts.Resource.splitResourceParts(parts[AwsKmsArnParts.ResourceParts.index()]);
        if (Arrays.stream(resourceParts).anyMatch(String::isEmpty) || AwsKmsArnParts.Resource.values().length > resourceParts.length) {
            return null;
        }
        if (!"key".equals(resourceParts[AwsKmsArnParts.Resource.ResourceType.index()]) && !"alias".equals(resourceParts[AwsKmsArnParts.Resource.ResourceType.index()])) {
            return null;
        }
        return new AwsKmsCmkArnInfo(parts[AwsKmsArnParts.Partition.index()], parts[AwsKmsArnParts.Region.index()], parts[AwsKmsArnParts.Account.index()], resourceParts[AwsKmsArnParts.Resource.ResourceType.index()], resourceParts[AwsKmsArnParts.Resource.Resource.index()]);
    }

    public static void validAwsKmsIdentifier(String identifier) {
        if (identifier == null || identifier.isEmpty()) {
            throw new IllegalArgumentException("Null or empty string is not a valid Aws KMS identifier.");
        }
        if (identifier.startsWith("arn:") && AwsKmsCmkArnInfo.parseInfoFromKeyArn(identifier) == null) {
            throw new IllegalArgumentException("Invalid ARN used as an identifier.");
        }
        if (identifier.startsWith("alias/")) {
            return;
        }
    }

    public static boolean isMRK(String resource) {
        if (resource.startsWith("arn:")) {
            return AwsKmsCmkArnInfo.isMRK(AwsKmsCmkArnInfo.parseInfoFromKeyArn(resource));
        }
        if (resource.startsWith("alias/")) {
            return false;
        }
        return resource.startsWith("mrk-");
    }

    public static boolean isMRK(AwsKmsCmkArnInfo arn) {
        if (arn == null) {
            throw new Error("Invalid Arn");
        }
        return AwsKmsCmkArnInfo.isMRK(arn.getResource()) && arn.getResourceType().equals("key");
    }

    public static boolean awsKmsArnMatchForDecrypt(String configuredKeyIdentifier, String providerInfoKeyIdentifier) {
        if (configuredKeyIdentifier.equals(providerInfoKeyIdentifier)) {
            return true;
        }
        AwsKmsCmkArnInfo configuredArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(configuredKeyIdentifier);
        AwsKmsCmkArnInfo providerInfoKeyArnInfo = AwsKmsCmkArnInfo.parseInfoFromKeyArn(providerInfoKeyIdentifier);
        if (providerInfoKeyArnInfo == null || configuredArnInfo == null) {
            return false;
        }
        if (!AwsKmsCmkArnInfo.isMRK(configuredArnInfo) || !AwsKmsCmkArnInfo.isMRK(providerInfoKeyArnInfo)) {
            return false;
        }
        return configuredArnInfo.getPartition().equals(providerInfoKeyArnInfo.getPartition()) && configuredArnInfo.getAccountId().equals(providerInfoKeyArnInfo.getAccountId()) && configuredArnInfo.getResourceType().equals(providerInfoKeyArnInfo.getResourceType()) && configuredArnInfo.getResource().equals(providerInfoKeyArnInfo.getResource());
    }

    AwsKmsCmkArnInfo(String partition, String region, String accountId, String resourceType, String resource) {
        this.partition_ = partition;
        this.region_ = region;
        this.accountId_ = accountId;
        this.resourceType_ = resourceType;
        this.resource_ = resource;
    }

    public String getPartition() {
        return this.partition_;
    }

    public String getAccountId() {
        return this.accountId_;
    }

    public String getRegion() {
        return this.region_;
    }

    public String getResourceType() {
        return this.resourceType_;
    }

    public String getResource() {
        return this.resource_;
    }

    public String toString() {
        return this.toString(this.region_);
    }

    public String toString(String mrkRegion) {
        return String.join((CharSequence)AwsKmsArnParts.Delimiter, arnLiteral, this.partition_, kmsServiceName, mrkRegion, this.accountId_, String.join((CharSequence)AwsKmsArnParts.Resource.ResourceDelimiter, this.resourceType_, this.resource_));
    }

    static enum AwsKmsArnParts {
        ArnLiteral(0),
        Partition(1),
        Service(2),
        Region(3),
        Account(4),
        ResourceParts(5);

        int index_;
        static String Delimiter;

        private AwsKmsArnParts(int i) {
            this.index_ = i;
        }

        int index() {
            return this.index_;
        }

        public static String[] splitArn(String arn) {
            return arn.split(Delimiter, AwsKmsArnParts.values().length);
        }

        static {
            Delimiter = ":";
        }

        static enum Resource {
            ResourceType(0),
            Resource(1);

            static String ResourceDelimiter;
            int index_;

            private Resource(int i) {
                this.index_ = i;
            }

            int index() {
                return this.index_;
            }

            public static String[] splitResourceParts(String resource) {
                return resource.split(ResourceDelimiter, 2);
            }

            static {
                ResourceDelimiter = "/";
            }
        }
    }
}

