untrusted comment: signature from openbsd 6.1 base secret key
RWQEQa33SgQSEo1p09ZluIZ7NkRYdgqZKoIVY4yr8WLKAHqmRQKe/x50An78HK6nmmDx+A5dpp/0OOreiVs6TLo7EPUn29G02As=

OpenBSD 6.1 errata 029, September 27, 2017:

Out of bounds TCB settings may result in a kernel panic.

Apply by doing:
    signify -Vep /etc/signify/openbsd-61-base.pub -x 029_tcb.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    cd /usr/src/sys/arch/`machine`/compile/$KK
    make obj
    make config
    make
    make install

Index: sys/arch/amd64/amd64/sys_machdep.c
===================================================================
RCS file: /cvs/src/sys/arch/amd64/amd64/sys_machdep.c,v
--- sys/arch/amd64/amd64/sys_machdep.c	18 May 2015 19:59:27 -0000	1.16
+++ sys/arch/amd64/amd64/sys_machdep.c	27 Sep 2017 06:35:13 -0000
@@ -111,6 +111,8 @@ amd64_set_fsbase(struct proc *p, void *a
 	if ((error = copyin(args, &base, sizeof(base))) != 0)
 		return (error);
 
+	if (TCB_INVALID(base))
+		return EINVAL;
 	tcb_set(p, base);
 	return 0;
 }
Index: sys/arch/amd64/include/tcb.h
===================================================================
RCS file: /cvs/src/sys/arch/amd64/include/tcb.h,v
--- sys/arch/amd64/include/tcb.h	4 Sep 2016 08:49:35 -0000	1.4
+++ sys/arch/amd64/include/tcb.h	27 Sep 2017 06:35:13 -0000
@@ -27,6 +27,9 @@ void	tcb_set(struct proc *_p, void *_new
 #define TCB_GET(p)		tcb_get(p)
 #define TCB_SET(p, addr)	tcb_set(p, addr)
 
+/* address must be in canonical form; requiring lower-half is okay */
+#define TCB_INVALID(addr)	((u_long)(addr) > 0x0000ffffffffffff)
+
 #else /* _KERNEL */
 
 /* ELF TLS ABI calls for big TCB, with static TLS data at negative offsets */
Index: sys/kern/kern_fork.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_fork.c,v
--- sys/kern/kern_fork.c	12 Feb 2017 04:55:08 -0000	1.195
+++ sys/kern/kern_fork.c	27 Sep 2017 06:35:13 -0000
@@ -131,6 +131,10 @@ sys___tfork(struct proc *p, void *v, reg
 	if (KTRPOINT(p, KTR_STRUCT))
 		ktrstruct(p, "tfork", &param, sizeof(param));
 #endif
+#ifdef TCB_INVALID
+	if (TCB_INVALID(param.tf_tcb))
+		return EINVAL;
+#endif /* TCB_INVALID */
 
 	return thread_fork(p, param.tf_stack, param.tf_tcb, param.tf_tid,
 	    retval);
Index: sys/kern/kern_prot.c
===================================================================
RCS file: /cvs/src/sys/kern/kern_prot.c,v
--- sys/kern/kern_prot.c	7 Nov 2016 00:26:32 -0000	1.67
+++ sys/kern/kern_prot.c	27 Sep 2017 06:35:13 -0000
@@ -1095,6 +1095,10 @@ sys___set_tcb(struct proc *p, void *v, r
 		syscallarg(void *) tcb;
 	} */ *uap = v;
 
+#ifdef TCB_INVALID
+	if (TCB_INVALID(SCARG(uap, tcb)))
+		return EINVAL;
+#endif /* TCB_INVALID */
 	TCB_SET(p, SCARG(uap, tcb));
 	return (0);
 }
